/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.value;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Predicates;
import ventus.Intl;
import ventus.VentusApp;
import ventus.gui.value.EditValDlg;

public class PopupValEditor<T>
extends AValEditor<T>
implements IValEditor<T>,
IEventObserver {
    private static final long serialVersionUID = -5663638864598041174L;
    private static final String MIXED = Intl.intl("&lt;mixed&gt;");
    private final Mode d_mode;
    private final Supplier<? extends IValEditor<T>> d_editor;
    private final boolean d_live;
    private final String d_desc;
    private final Function<T, String> d_formatter;
    private final guiTextField d_fldText;
    private final JButton d_editButton;
    private final HTMLBtn d_htmlBtn;
    private final Predicate<Events> d_needsUpdate;
    private IValEditor<T> d_lastEditor;

    public PopupValEditor(Mode mode, Class<T> type, String desc, Supplier<? extends IValEditor<T>> popupEditor, Function<T, String> formatter) {
        this(mode, type, desc, popupEditor, formatter, Predicates.alwaysFalse());
    }

    public PopupValEditor(Mode mode, Class<T> type, String desc, Supplier<? extends IValEditor<T>> popupEditor, Function<T, String> formatter, Predicate<Events> needsUpdate) {
        super(type);
        this.d_mode = mode;
        this.d_formatter = formatter;
        this.d_editor = popupEditor;
        this.d_desc = desc;
        this.d_needsUpdate = needsUpdate;
        this.d_live = this.d_editor.get().isLive();
        ActionListener editAction = e -> SwingUtilities.invokeLater(() -> this.editValue());
        if (mode == Mode.HTML) {
            this.d_fldText = null;
            this.d_editButton = null;
            this.d_htmlBtn = new HTMLBtn("");
            this.d_htmlBtn.addActionListener(editAction);
        } else {
            this.d_htmlBtn = null;
            this.d_fldText = new guiTextField();
            this.d_fldText.setEditable(false);
            Dimension szFld = this.d_fldText.getPreferredSize();
            this.d_fldText.setPreferredSize(new Dimension((int)((double)szFld.width * 2.5), szFld.height));
            this.d_editButton = new JButton(Intl.intl("Edit..."));
            this.d_editButton.addActionListener(editAction);
        }
        GridBagHelper gb = new GridBagHelper(this);
        this.add(gb);
        gb.finalizeRows();
        this.loadValue(this.getValue());
        if (!Predicates.alwaysFalse(needsUpdate)) {
            VentusApp.getAppData().getEvents().addObserver(this);
        }
    }

    @Override
    public boolean isLive() {
        return this.d_live;
    }

    @Override
    public void update(Events events) {
        if (this.d_needsUpdate.test(events)) {
            this.updateText();
        }
    }

    @Override
    public void add(GridBagHelper gb) {
        if (this.d_mode == Mode.HTML) {
            gb.add(this.d_htmlBtn, 1.0);
        } else {
            gb.add(this.d_fldText, 1.0, this.d_editButton);
        }
    }

    @Override
    public T saveValue(Mediator mediator) {
        if (this.isLive()) {
            return this.getValue();
        }
        if (this.d_lastEditor != null) {
            T val = this.d_lastEditor.commit(mediator);
            this.d_lastEditor = null;
            return val;
        }
        return this.getValue();
    }

    @Override
    public void loadValue(T value) {
        this.updateText(value);
        if (this.d_lastEditor != null) {
            this.d_lastEditor.setValue(value);
        }
    }

    @Override
    public String formatNonLiveValue() {
        if (this.isLive()) {
            return "";
        }
        if (this.d_lastEditor != null) {
            return this.d_lastEditor.formatNonLiveValue();
        }
        Object value = this.getValue();
        return value == null ? null : this.d_formatter.apply(value);
    }

    public void updateText() {
        this.updateText(this.getValue());
    }

    private void updateText(T value) {
        this.updateText(value == null ? null : this.d_formatter.apply(value));
    }

    private void updateText(String inText) {
        String text = inText != null ? inText : MIXED;
        switch (this.d_mode.ordinal()) {
            case 1: {
                this.d_fldText.setText(text);
                this.d_fldText.setCaretPosition(0);
                String tt = text.isEmpty() ? null : text;
                this.d_fldText.setToolTipText(tt);
                break;
            }
            case 0: {
                this.d_htmlBtn.setText(text);
                String tt = text.isEmpty() ? null : "<html>" + text + "</html>";
                this.d_htmlBtn.setToolTipText(tt);
                break;
            }
        }
    }

    public boolean editValue() {
        EditValDlg<T> dlg;
        JTextComponent comp = this.d_htmlBtn != null ? this.d_htmlBtn : this.d_fldText;
        Window parent = SwingUtilities.getWindowAncestor(comp);
        IValEditor editor = this.d_lastEditor;
        if (editor == null) {
            editor = this.d_editor.get();
            editor.setValue(this.getValue());
        }
        if ((dlg = new EditValDlg<T>(parent, this.d_desc, editor)).doModal() == 1) {
            if (this.isLive()) {
                T newVal = editor.getValue();
                this.setValue(newVal);
            } else {
                this.d_lastEditor = editor;
                this.updateText(editor.formatNonLiveValue());
                this.fireNonLiveValueEdited();
            }
            return true;
        }
        return false;
    }

    public static enum Mode {
        HTML,
        BUTTON;

    }
}

