/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.schematics.SimError;
import ventus.feature.props.IDisplayProp;
import ventus.treeview.TVEntryPoint;
import ventus.treeview.Util;
import ventus.unitsystem.UnitSystem;

public class guiUtil
extends thunderheadeng.gui.guiUtil {
    public static final int ICON_HEIGHT = 16;
    private static final ErrorIconSet s_warningIcon = new ErrorIconSet("warn16.gif", "warn8.gif");
    private static final ErrorIconSet s_errorIcon = new ErrorIconSet("error16.gif", "error8.gif");

    public static String getFileNameNoExt(String filename) {
        int extix = filename.lastIndexOf(46);
        if (extix < 0) {
            return filename;
        }
        return filename.substring(0, extix);
    }

    public static ImageIcon loadMerlinIcon(String name) {
        return guiUtil.loadMerlinIcon(name, -1);
    }

    public static ImageIcon loadMerlinIcon(String name, int maxDimension) {
        return guiUtil.loadIcon("ventus/icons/" + name, maxDimension);
    }

    public static Cursor createMerlinCursor(String key, String filename, int hotspotx, int hotspoty) {
        return guiUtil.createCursor(key, "ventus/icons/" + filename, hotspotx, hotspoty);
    }

    public static JCheckBoxMenuItem createSelectableMenuItem(SelectableAction action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.addItemListener(action);
        return item;
    }

    public static JRadioButtonMenuItem[] createRbMenuItemMutexGroup(SelectableAction ... actions) {
        JRadioButtonMenuItem[] items = new JRadioButtonMenuItem[actions.length];
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < actions.length; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(actions[i]);
            items[i] = guiUtil.initMenuItem(item, actions[i], group);
        }
        return items;
    }

    public static JRadioButtonMenuItem[] createRbMenuItemMutexGroup(Collection<? extends SelectableAction> actions) {
        return guiUtil.createRbMenuItemMutexGroup(actions.toArray(new SelectableAction[actions.size()]));
    }

    public static JToggleButton createToolbarToggleButton(SelectableAction action) {
        JToggleButton button = new JToggleButton(action);
        guiUtil.initToolbarBtn(action, button);
        button.addItemListener(action);
        return button;
    }

    public static JButton createToolbarButton(Action action) {
        JButton btn = new JButton(action);
        guiUtil.initToolbarBtn(action, btn);
        return btn;
    }

    private static void initToolbarBtn(Action action, AbstractButton btn) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            btn.setText("");
            String ttt = (String)action.getValue("ShortDescription");
            if (ttt == null || ttt.trim().equals("")) {
                btn.setToolTipText((String)action.getValue("Name"));
            }
        }
    }

    public static void addMEMenuItems(JMenu menu, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            SelectableAction action = actions[m];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.addItemListener(action);
            menu.add(item);
            group.add(item);
        }
    }

    public static void addMEToolbarItems(JToolBar tb, SelectableAction ... actions) {
        ButtonGroup group = new ButtonGroup();
        for (int m = 0; m < actions.length; ++m) {
            JToggleButton item = guiUtil.createToolbarToggleButton(actions[m]);
            tb.add(item);
            group.add(item);
        }
    }

    public static Icon createDisabledIcon(Icon i, Component c) {
        if (i == null) {
            return null;
        }
        if (i instanceof ImageIcon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)i).getImage()));
        }
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        Graphics g = bi.getGraphics();
        i.paintIcon(c, g, 0, 0);
        g.dispose();
        return new ImageIcon(GrayFilter.createDisabledImage(bi));
    }

    public static Icon[] decorateIcons(VentusData md, TVEntryPoint<Object> tvep, Runnable redecorate, Component comp, IMerlinObj obj, Collection<? extends SimError> errors) {
        Icon[] baseIcons = tvep.getIcons(md, comp, obj, redecorate);
        if (errors.isEmpty()) {
            return baseIcons;
        }
        ErrorIconSet icons = guiUtil.chooseErrorIcons(errors);
        return new Icon[]{baseIcons[0] != null ? new DecoratedIcon(baseIcons[0], icons.decorator, 3) : icons.icon, baseIcons[1] != null ? new DecoratedIcon(baseIcons[1], icons.decorator, 3) : icons.icon};
    }

    private static ErrorIconSet chooseErrorIcons(Collection<? extends SimError> errors) {
        SimError.Level maxLevel = SimError.Level.MODERATE;
        for (SimError simError : errors) {
            if (simError.level.severity <= maxLevel.severity) continue;
            maxLevel = simError.level;
        }
        return maxLevel == SimError.Level.MODERATE ? s_warningIcon : s_errorIcon;
    }

    public static boolean decorateComboRenderer(VentusData data, JComboBox<?> cb, JList<?> list, Object value, JLabel c, boolean isSelected, boolean cellHasFocus) {
        Runnable redecorate = () -> {
            cb.repaint();
            list.repaint();
        };
        return guiUtil.decorateCellRenderer(data, redecorate, value, c, isSelected, cellHasFocus);
    }

    public static boolean decorateCellRenderer(VentusData data, Runnable redecorate, Object value, JLabel c, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof IMerlinObj) {
            TVEntryPoint<Object> ep = Util.getEP(value);
            IMerlinObj obj = (IMerlinObj)value;
            c.setText(ep.getName(data, obj));
            c.setFont(ep.getFont(data, obj));
            c.setEnabled(ep.isVisible(data, obj));
            Collection<SimError> errors = ep.getErrors(data, obj);
            Icon[] decorators = guiUtil.decorateIcons(data, ep, redecorate, c, obj, errors);
            c.setIcon(decorators[0]);
            c.setDisabledIcon(decorators[1]);
            c.setToolTipText(guiUtil.formatErrors(errors));
            c.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            return true;
        }
        return false;
    }

    private static String formatErrors(Collection<? extends SimError> errors) {
        if (errors.isEmpty()) {
            return null;
        }
        Object msg = "";
        for (SimError simError : errors) {
            if (simError.cause.isEmpty()) continue;
            if (!((String)msg).isEmpty()) {
                msg = (String)msg + "<br>";
            }
            if (simError.level == SimError.Level.CRITICAL) {
                msg = (String)msg + String.format("<b>%s %s</b>", Intl.intl("Error:"), simError.cause);
                continue;
            }
            msg = (String)msg + String.format("%s %s", Intl.intl("Warning:"), simError.cause);
        }
        if (((String)msg).isEmpty()) {
            return null;
        }
        return "<html>" + (String)msg + "</html>";
    }

    public static String format(UnitDouble ud) {
        int type = UnitSystem.getType(ud.getUnit());
        return guiUtil.format(ud, type);
    }

    public static String format(UnitDouble ud, int unitType) {
        if (unitType == -1) {
            unitType = UnitSystem.getType(ud.getUnit());
        }
        if (unitType == -1) {
            return Global.format(ud);
        }
        UnitSystem us = VentusApp.getApp().getUnitSystem();
        Unit unit = us.getUnit(unitType);
        return Global.format(ud.convert(unit));
    }

    public static void setLongTooltip(JComponent component, String text) {
        text = ((String)text).replace("\n", "<br>");
        text = "<html>" + (String)text + "</html>";
        component.setToolTipText((String)text);
    }

    public static int getWrappedLines(JTextComponent component) {
        int lines = 0;
        View view = component.getUI().getRootView(component).getView(0);
        int paragraphs = view.getViewCount();
        for (int i = 0; i < paragraphs; ++i) {
            lines += view.getView(i).getViewCount();
        }
        return lines;
    }

    public static String shorten(String str, int maxPixelWidth, FontMetrics fm) {
        if (fm.stringWidth(str) <= maxPixelWidth) {
            return str;
        }
        Object prevBestStr = "";
        for (int m = 1; m < str.length(); ++m) {
            String testStr = str.substring(0, m) + "...";
            int width = fm.stringWidth(testStr);
            if (width > maxPixelWidth) {
                return prevBestStr;
            }
            prevBestStr = testStr;
        }
        return prevBestStr;
    }

    public static JEditorPane newHTMLLabel() {
        JEditorPane editor = new JEditorPane("text/html", "");
        Font font = UIManager.getFont("Label.font");
        String bodyRule = String.format("body { font-family: %s; font-size: %dpt; }", font.getFamily(), font.getSize());
        ((HTMLDocument)editor.getDocument()).getStyleSheet().addRule(bodyRule);
        editor.setOpaque(false);
        editor.setEditable(false);
        return editor;
    }

    public static void initButton(AbstractButton btn, Material mat) {
        if (mat != null) {
            btn.setToolTipText(mat.getName());
        } else {
            btn.setToolTipText(null);
        }
    }

    public static String encodeToHtmlLabel(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return "<html>" + str.replace("\n", "<br>");
    }

    public static Pair<String, String> encodeToHtmlLabel(String v1, String v2) {
        return new Pair<String, String>(guiUtil.encodeToHtmlLabel(v1), guiUtil.encodeToHtmlLabel(v2));
    }

    public static Pair<String, String> encodeToHtmlLabels(String str1, String str2) {
        return new Pair<String, String>(guiUtil.encodeToHtmlLabel(str1), guiUtil.encodeToHtmlLabel(str2));
    }

    public static Window getWindow(Component c) {
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    public static <T> guiComboBox<T> newCombo(T item1, String label1, Object ... args) {
        assert (args.length % 2 == 0);
        ArrayList items = new ArrayList();
        final HashMap labels = new HashMap();
        BiConsumer<Object, String> add = (item, label) -> {
            items.add(item);
            labels.put(item, label);
        };
        add.accept(item1, label1);
        int m = 0;
        while (m < args.length) {
            Object item2 = args[m++];
            String label2 = (String)args[m++];
            add.accept(item2, label2);
        }
        guiComboBox<Object> result = new guiComboBox<Object>(items);
        result.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText((String)labels.get(value));
                return this;
            }
        });
        return result;
    }

    public static Pair<guiRadioButton, guiRadioButton> createPlacementButtons() {
        guiRadioButton d_uniformRB = new guiRadioButton(Intl.intl("Uniform (hex grid)"), false);
        d_uniformRB.setToolTipText(Intl.intl("Places occupants uniformly in a hexagonal grid pattern."));
        guiRadioButton d_randomRB = new guiRadioButton(Intl.intl("Random"), true);
        d_randomRB.setToolTipText(Intl.intl("Places occupants randomly in the space."));
        guiUtil.group(new AbstractButton[]{d_uniformRB, d_randomRB});
        return new Pair<guiRadioButton, guiRadioButton>(d_uniformRB, d_randomRB);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void add(Object container, Object item) {
        if (container instanceof JComponent && item instanceof JComponent) {
            ((JComponent)container).add((JComponent)item);
            return;
        }
        if (container instanceof JMenu && item instanceof Action) {
            ((JMenu)container).add((Action)item);
            return;
        }
        if (container instanceof JToolBar && item instanceof Action) {
            ((JToolBar)container).add((Action)item);
            return;
        }
        if (container instanceof DropDownButton) {
            DropDownButton dropDownButton = (DropDownButton)container;
            if (item instanceof Action) {
                Action action = (Action)item;
                dropDownButton.addAction(action);
                return;
            }
        }
        String msg = String.format("Unable to match types: container=%s, item=%s", container.getClass().getName(), item.getClass().getName());
        throw new IllegalArgumentException(msg);
    }

    public static guiLabel lblProp(IDisplayProp<?> prop) {
        return thunderheadeng.gui.guiUtil.lblProp(prop.getDisplayName(), prop.getDisplayDesc());
    }

    public static guiLabel lblPropHtml(IDisplayProp<?> prop) {
        return thunderheadeng.gui.guiUtil.lblPropHtml(prop.getDisplayName(), prop.getDisplayDesc());
    }

    private static class ErrorIconSet {
        public final Icon icon;
        public final Icon decorator;

        public ErrorIconSet(String iconName16, String iconName8) {
            this.icon = guiUtil.loadMerlinIcon(iconName16);
            this.decorator = guiUtil.loadMerlinIcon(iconName8);
        }
    }
}

