/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.framework.Deletion;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.Delete;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.INamedMerlinObj;
import ventus.data.VentusData;
import ventus.gui.InvisibleSplitPane;
import ventus.gui.LibraryDlg;

public class ManagerDlg<T extends INamedMerlinObj, MgrT extends IManager<T>>
extends guiDialog
implements ListSelectionListener,
DlgListener,
Observer,
ActionListener,
IEventObserver {
    private static final long serialVersionUID = -6801201917913411572L;
    private final guiPanel d_mgrEdPanel;
    private final guiPanel d_actPanel;
    private final guiPanel d_edPanel;
    private final ListCellRenderer<?> d_ren;
    public static final String KEY = "KEY";
    private MgrT d_mgr;
    private final RecordList d_recs;
    private IEditor<T> d_editor;
    private IEditor<MgrT> d_mgrEditor;
    private VentusData d_vd;
    private Icon d_icon;
    protected int d_edix;
    private final Class<T> d_clazz;
    private final JFrame d_owner;
    protected final LinkedHashMap<Action, Predicate<T>> d_actionStateMap = new LinkedHashMap();

    protected ManagerDlg(JFrame owner, String title, Class<T> clazz) {
        super((Window)owner, title, 11);
        this.d_owner = owner;
        this.d_clazz = clazz;
        VentusApp.getAppOpt().ifPresent(app -> app.getData().getEvents().addObserver(this));
        this.d_mgr = null;
        this.d_editor = null;
        this.d_mgrEditor = null;
        this.d_vd = null;
        this.d_ren = new ManagedListCellRen();
        this.d_recs = new RecordList();
        this.d_recs.addListener(this);
        this.d_edix = -1;
        this.addDlgListener(this);
        CloseListener closeLis = new CloseListener();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().unregisterKeyboardAction(ks);
        this.getRootPane().registerKeyboardAction(closeLis, ks, 2);
        this.setDefaultCloseOperation(0);
        this.removeWindowListener(this.d_cancelListener);
        this.addWindowListener(closeLis);
        guiPanel content = this.getDialogPane();
        content.setLayout(new BorderLayout());
        this.d_mgrEdPanel = new guiPanel(new GridBagLayout());
        guiPanel left = new guiPanel(new GridBagLayout());
        this.d_edPanel = new guiPanel(new GridBagLayout());
        this.d_actPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(this.d_actPanel, Box.createGlue(), 0, 100, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0);
        GridBagUtil.add(left, this.d_recs, 0, 0, 1, 1, 0, 0, 12, 0, 1, 1.0, 1.0);
        GridBagUtil.add(left, this.d_actPanel, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.0);
        InvisibleSplitPane splitPane = new InvisibleSplitPane(1, true, left, this.d_edPanel);
        splitPane.setDividerSize(12);
        content.add((Component)this.d_mgrEdPanel, "North");
        content.add((Component)splitPane, "Center");
        this.setResizable(true);
    }

    public VentusData getVentusData() {
        return this.d_vd;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.d_status = 16;
        this.fireButtonPressed(16);
    }

    public RecordList getList() {
        return this.d_recs;
    }

    protected T getSelectedItem() {
        return this.d_recs.getSelectedItem();
    }

    protected final boolean preSave() {
        if (this.d_editor.isModified()) {
            int opt = this.showConfirm();
            if (opt == 1) {
                this.d_editor.init(this.getList().getItem(this.d_edix));
            } else {
                if (opt == 0) {
                    return this.handleYes();
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        try {
            int ix = this.getList().getSelectedIx();
            if (this.d_edix == ix) {
                return;
            }
            if (-1 < this.d_edix && this.d_edix < this.d_mgr.size() && this.d_editor.isModified()) {
                switch (this.showConfirm()) {
                    case 0: {
                        boolean isValid = this.handleYes();
                        if (!isValid) {
                            this.handleCancel();
                            break;
                        }
                    }
                    case 1: {
                        this.handleNo(ix);
                        this.d_edix = ix;
                        break;
                    }
                    default: {
                        this.handleCancel();
                        break;
                    }
                }
            } else if (ix > -1) {
                this.d_edix = ix;
                this.handleNo(ix);
            } else {
                this.d_edix = ix;
                this.d_editor.init(null);
            }
        }
        finally {
            this.updateActions();
        }
    }

    protected boolean validateEditor(IEditor<T> editor, boolean showWarn, boolean allowModify) {
        return editor.getEditorPanel().validateData(showWarn, allowModify);
    }

    protected boolean handleYes() {
        Object edObj = this.getList().getItem(this.d_edix);
        if (!this.validateEditor(this.d_editor, true, true)) {
            this.d_recs.select(this.d_edix);
            return false;
        }
        this.commit(edObj);
        return true;
    }

    protected void handleNo(int ix) {
        this.d_edix = ix;
        Object edItem = this.d_edix > -1 ? (Object)this.getList().getItem(this.d_edix) : null;
        this.d_editor.init(edItem);
    }

    protected void handleCancel() {
        this.d_recs.select(this.d_edix);
    }

    public int showConfirm() {
        Object edObj = this.getList().getItem(this.d_edix);
        String msg = Intl.intl("Save changes to: ") + this.d_mgr.describe(edObj) + Intl.intl("?");
        return JOptionPane.showConfirmDialog(this, msg);
    }

    @Override
    public void okPressed() {
        this.applyPressed();
    }

    @Override
    public void resetPressed() {
    }

    @Override
    public void helpPressed() {
    }

    @Override
    public void cancelPressed() {
    }

    @Override
    public void closePressed() {
        if (this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    if (this.handleYes()) {
                        this.handleNo(this.d_edix);
                        this.setVisible(false);
                        break;
                    }
                    this.handleCancel();
                    break;
                }
                case 1: {
                    this.handleNo(this.d_edix);
                    this.setVisible(false);
                    break;
                }
                default: {
                    this.handleCancel();
                    break;
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    private void commit(T edObj) {
        this.d_vd.pauseUpdates();
        this.d_editor.commit(edObj);
        this.d_vd.resumeUpdates();
    }

    @Override
    public void applyPressed() {
        this.d_vd.pauseUpdates();
        if (this.d_editor.isModified()) {
            int ix = this.getList().getSelectedIx();
            Object edObj = this.getList().getItem(ix);
            this.d_editor.commit(edObj);
            this.getList().repaint();
        }
        if (this.d_mgrEditor != null && this.d_mgrEditor.isModified()) {
            this.d_mgrEditor.commit(this.d_mgr);
        }
        this.d_vd.resumeUpdates();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return this.validateEditor(this.d_editor, showWarn, allowModify) && (this.d_mgrEditor == null || this.d_mgrEditor.getEditorPanel().validateData(showWarn, allowModify));
    }

    protected void init(VentusData md, MgrT mgr, IEditor<T> ed, Icon icon) {
        this.init(md, mgr, ed, null, icon);
    }

    protected void init(VentusData md, MgrT mgr, IEditor<T> ed, IEditor<MgrT> mgrEditor, Icon icon) {
        this.d_vd = md;
        if (this.d_editor != null) {
            this.d_editor.removeObserver(this);
        }
        this.d_mgr = mgr;
        this.d_editor = ed;
        this.d_mgrEditor = mgrEditor;
        this.d_icon = icon;
        this.d_recs.setModel(mgr, this.d_ren);
        if (this.d_mgrEditor != null) {
            this.d_mgrEditor.init(this.d_mgr);
        }
        this.d_edix = -1;
        if (this.d_mgr.size() > 0) {
            this.d_recs.select(0);
        }
        this.d_actPanel.removeAll();
        int actionIx = 0;
        for (Action action : this.d_actionStateMap.keySet()) {
            int keystrokeIx = 0;
            while (true) {
                Object key = keystrokeIx == 0 ? KEY : KEY + keystrokeIx;
                ++keystrokeIx;
                KeyStroke k = (KeyStroke)action.getValue((String)key);
                if (k == null) break;
                this.d_recs.d_list.getActionMap().put("released", action);
                this.d_recs.d_list.getInputMap().put(k, "released");
            }
            JButton actBtn = new JButton(action);
            int bottom = actionIx == this.d_actionStateMap.size() - 1 ? 0 : 6;
            GridBagUtil.add(this.d_actPanel, actBtn, 0, actionIx, 1, 1, 0, 0, bottom, 0, 2, 1.0, 0.0);
            ++actionIx;
        }
        this.d_mgrEdPanel.removeAll();
        if (this.d_mgrEditor != null) {
            GridBagUtil.add(this.d_mgrEdPanel, this.d_mgrEditor.getEditorPanel(), 0, 0, 1, 1, 0, 0, 12, 0, 1, 1.0, 1.0, 18);
        }
        this.d_edPanel.removeAll();
        GridBagUtil.add(this.d_edPanel, this.d_editor.getEditorPanel(), 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        this.d_editor.addObserver(this);
        this.pack();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.d_recs.repaint();
    }

    protected Collection<? extends T> getModelColl(MgrT manager) {
        return manager.getSorted();
    }

    protected void addAction(Action action) {
        this.addAction(action, Predicates.alwaysTrue());
    }

    protected void addAction(Action action, Predicate<T> enabled) {
        this.d_actionStateMap.put(action, enabled);
    }

    protected boolean canRename(T selected) {
        return selected != null && EntryPointFactory.get(selected).tvEntryPoint.canRename(this.getVentusData(), selected);
    }

    protected boolean canDelete(T selected) {
        return selected != null && EntryPointFactory.get(selected).canDelete(this.getVentusData(), selected);
    }

    protected BiPredicate<String, String> validateName(boolean unique, boolean nonEmpty) {
        Predicate<String> nameExists = name -> this.d_mgr.getSorted().stream().filter(n -> n.getName().toLowerCase(Locale.ROOT).equals(name.toLowerCase(Locale.ROOT))).findFirst().orElse(null) != null;
        return (existing, name) -> {
            if (nonEmpty && name.isEmpty() || name.isBlank()) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Name must not be blank."));
                return false;
            }
            if (existing != null && existing.equals(name)) {
                return true;
            }
            if (unique && nameExists.test((String)name)) {
                JOptionPane.showMessageDialog(this, String.format(Intl.intl("The name \"%s\" is already in use.\nPlease enter a unique name."), name), Intl.intl("Name Already Exists"), 0);
                return false;
            }
            return true;
        };
    }

    @Override
    public void update(Events events) {
        IEventRecord<T> pevents = events.getEvents(this.d_clazz, new Class[0]);
        Set<T> addedObjs = pevents.getAddedObjs();
        if (!addedObjs.isEmpty()) {
            this.getList().updateModelView(this.d_mgr);
            this.getList().select((INamedMerlinObj)addedObjs.iterator().next());
            this.d_editor.getEditorPanel().setModified(false);
        }
    }

    public void updateActions() {
        for (Action action : this.d_actionStateMap.keySet()) {
            action.setEnabled(this.d_mgr != null && this.d_actionStateMap.get(action).test(this.getSelectedItem()));
        }
    }

    public static <T extends IMerlinObj> void defaultInit(IEditor<T> editor, T dataObj, Consumer<T> initFunc) {
        guiPanel editorPanel = editor.getEditorPanel();
        if (dataObj == null) {
            editorPanel.setEnabled(false);
            editorPanel.setModified(false);
            return;
        }
        initFunc.accept(dataObj);
        editorPanel.setModified(false);
    }

    public static <T extends IMerlinObj> T defaultCommit(IEditor<T> editor, final T dataObj, final String undoDesc, String loggerDesc, final Consumer<T> commitFunc) {
        assert (dataObj == null || dataObj.getDomain() != null);
        guiPanel editorPanel = editor.getEditorPanel();
        editorPanel.setModified(false);
        if (dataObj == null) {
            return dataObj;
        }
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                try (VentusData.WriteLock ignored = md.lockWrite();){
                    Undo.begin(undoDesc);
                    Undo.insertUndoEntry_restore(md, dataObj);
                    commitFunc.accept(dataObj);
                    Undo.end(md);
                }
            }
        };
        UIHook.run((Component)editorPanel, loggerDesc, op, 0);
        return dataObj;
    }

    public static interface IManager<T> {
        public int size();

        public String describe(T var1);

        public Collection<T> getSorted();
    }

    private class ManagedListCellRen
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -414623608016210827L;
        private final Font d_italic = new Font("SansSerif", 2, 11);
        private final Font d_plain = new Font("SansSerif", 0, 11);

        private ManagedListCellRen() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, ManagerDlg.this.d_mgr.describe((INamedMerlinObj)((INamedMerlinObj)value)), index, isSelected, cellHasFocus);
            if (index == ManagerDlg.this.d_edix && ManagerDlg.this.d_editor.isModified()) {
                c.setFont(this.d_italic);
            } else {
                c.setFont(this.d_plain);
            }
            return c;
        }
    }

    public class RecordList
    extends guiPanel
    implements ListSelectionListener {
        private static final long serialVersionUID = -1017895551275946059L;
        private final JList<T> d_list = new JList();
        private final JScrollPane d_jsp;
        private final List<ListSelectionListener> d_listeners;
        private boolean d_suppressNotify;

        public RecordList() {
            this.d_list.addListSelectionListener(this);
            this.d_list.setSelectionMode(0);
            this.d_jsp = new JScrollPane(this.d_list);
            this.d_jsp.setVerticalScrollBarPolicy(22);
            this.d_jsp.setPreferredSize(new Dimension(120, 180));
            this.setLayout(new BorderLayout());
            this.add((Component)this.d_jsp, "Center");
            this.d_suppressNotify = false;
            this.d_listeners = new ArrayList<ListSelectionListener>();
        }

        public T getSelectedItem() {
            return (INamedMerlinObj)this.d_list.getSelectedValue();
        }

        public int getSelectedIx() {
            return this.d_list.getSelectedIndex();
        }

        public T getItem(int ix) {
            return (INamedMerlinObj)this.d_list.getModel().getElementAt(ix);
        }

        public JList<T> getItems() {
            return this.d_list;
        }

        public void select(int ix) {
            this.d_list.setSelectedIndex(ix);
            this.valueChanged();
        }

        public void select(T obj) {
            this.d_list.setSelectedValue(obj, true);
            this.valueChanged();
        }

        public void setModel(MgrT mgr, ListCellRenderer<?> ren) {
            this.d_list.setCellRenderer(ren);
            this.d_list.setModel(new DefaultListModel());
            this.updateModelView(mgr);
        }

        public void updateModelView(MgrT mgr) {
            DefaultListModel model = (DefaultListModel)this.d_list.getModel();
            Object selected = this.d_list.getSelectedValue();
            int scrIx = this.d_jsp.getVerticalScrollBar().getValue();
            this.d_suppressNotify = true;
            model.clear();
            for (INamedMerlinObj obj : ManagerDlg.this.getModelColl(mgr)) {
                model.addElement(obj);
            }
            this.d_suppressNotify = false;
            int newScrIx = Math.min(scrIx, this.d_jsp.getVerticalScrollBar().getMaximum());
            this.d_jsp.getVerticalScrollBar().setValue(newScrIx);
            if (model.contains(selected)) {
                this.d_list.setSelectedValue(selected, false);
            } else {
                this.d_list.setSelectedIndex(0);
            }
        }

        public void addListener(ListSelectionListener listener) {
            this.d_listeners.add(listener);
        }

        public void removeListener(Object obj) {
            this.d_listeners.remove(obj);
        }

        private void valueChanged() {
            int newIx = this.d_list.getSelectedIndex();
            ListSelectionEvent evt = new ListSelectionEvent(this, newIx, newIx, false);
            this.valueChanged(evt);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.d_suppressNotify) {
                return;
            }
            for (ListSelectionListener listener : this.d_listeners) {
                listener.valueChanged(e);
            }
        }

        public int getNumItems() {
            return this.d_list.getModel().getSize();
        }
    }

    private class CloseListener
    extends WindowAdapter
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.close();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.close();
        }

        private void close() {
            ManagerDlg.this.d_status = 16;
            ManagerDlg.this.fireButtonPressed(16);
        }
    }

    protected class RenameAction
    extends AbstractAction {
        private static final long serialVersionUID = 6934870752462657989L;
        private final TypedProp<String> d_propName;
        private final BiPredicate<String, String> d_validate;

        public RenameAction(TypedProp<String> propname) {
            this(propname, this$0.validateName(true, true));
        }

        public RenameAction(TypedProp<String> propName, BiPredicate<String, String> validate) {
            super(Intl.intl("Rename..."));
            this.d_propName = propName;
            this.d_validate = validate;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String objName;
            if (!ManagerDlg.this.preSave()) {
                return;
            }
            int selIx = ManagerDlg.this.getList().getSelectedIx();
            String obj = ManagerDlg.this.getList().getItem(selIx);
            VentusData md = ManagerDlg.this.getVentusData();
            String currName = obj.getWithDetails(this.d_propName).orElse("");
            String categoryName = EntryPointFactory.get(obj).getCategoryName(ManagerDlg.this.d_vd, obj);
            do {
                if ((objName = this.promptRename(obj, categoryName)) != null && !objName.equals(currName)) continue;
                return;
            } while (!this.d_validate.test(obj.getName(), objName));
            ventus.actions.RenameAction.rename(md, ManagerDlg.this, Arrays.asList(obj), objName);
            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
            ManagerDlg.this.d_editor.init(obj);
        }

        private String promptRename(T obj, String categoryName) {
            return (String)JOptionPane.showInputDialog(ManagerDlg.this, Intl.intl("Name:"), String.format(Intl.intl("Rename %s"), categoryName), 3, ManagerDlg.this.d_icon, null, obj.getName());
        }
    }

    public class LibraryAction
    extends guiAction {
        private static final long serialVersionUID = -5364133990644521647L;
        private final String d_name;
        private final Function<VentusData, Composite<T>> d_getRoot;
        private final String d_libPathTail;
        private final String d_installPathTail;

        public LibraryAction(String name, Function<VentusData, Composite<T>> getRoot, String libPathTail, String installPathTail) {
            super(Intl.intl("Add From Library") + "...");
            this.d_name = name;
            this.d_getRoot = getRoot;
            this.d_libPathTail = libPathTail;
            this.d_installPathTail = installPathTail;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ManagerDlg.this.preSave()) {
                return;
            }
            LibraryDlg dlg = new LibraryDlg(ManagerDlg.this.d_owner, ManagerDlg.this.getVentusData(), () -> ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr), this.d_getRoot, root -> root.flatten(ManagerDlg.this.d_clazz), new LibraryDlg.LibraryInfo(this.d_name, this.d_installPathTail, this.d_libPathTail));
            dlg.doModal();
            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
        }
    }

    protected class DeleteAction
    extends guiAction {
        private static final long serialVersionUID = 719780049719631796L;

        public DeleteAction() {
            super(Intl.intl("Delete..."));
            this.putValue(ManagerDlg.KEY, KeyStroke.getKeyStroke(127, 0, true));
            this.putValue("KEY1", KeyStroke.getKeyStroke(8, 0, true));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int ix = ManagerDlg.this.getList().getSelectedIx();
            Object sm = ManagerDlg.this.getList().getItem(ix);
            AMerlinOp op = new AMerlinOp((INamedMerlinObj)sm, ix){
                final /* synthetic */ INamedMerlinObj val$sm;
                final /* synthetic */ int val$ix;
                {
                    this.val$sm = iNamedMerlinObj;
                    this.val$ix = n;
                }

                @Override
                public void run(VentusApp app, VentusData md) {
                    Deletion.DelStatus status = Delete.uiDelete(VentusApp.getApp(), ManagerDlg.this.getVentusData(), Arrays.asList(this.val$sm), true);
                    md.ui(() -> {
                        if (status.equals((Object)Deletion.DelStatus.SUCCESS)) {
                            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
                            ManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                            int newIx = this.val$ix - 1 < 0 && ManagerDlg.this.d_mgr.size() > 0 ? 0 : this.val$ix - 1;
                            ManagerDlg.this.getList().select(newIx);
                            if (newIx == this.val$ix && ManagerDlg.this.getList().getNumItems() > 0) {
                                ManagerDlg.this.d_editor.init(ManagerDlg.this.getList().getItem(newIx));
                            }
                        }
                    });
                }
            };
            UIHook.run((Component)ManagerDlg.this, "ManagerDlg.DeleteAction.actionPerformed", op, 0);
        }

        @Override
        public boolean isEnabled() {
            Object selected = ManagerDlg.this.getList().getSelectedItem();
            return selected != null && EntryPointFactory.get(selected).canDelete(ManagerDlg.this.getVentusData(), selected);
        }
    }
}

