/*
 * Decompiled with CFR 0.152.
 */
package ventus.geom;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.util.theUtil;
import ventus.geom.Geometry;

public class StrutUtil {
    public static StrutParam calcStrutParam(LineSeg edge1, LineSeg edge2, double loc1e1, double loc2e1, double minWidth, boolean slide) {
        double[] t = StrutUtil.getOverlap(edge1, edge2);
        if (t == null) {
            return null;
        }
        return StrutUtil.toStrutParam(edge1, Geometry.getEdgeSegment(edge1, loc1e1, loc2e1, t[0], t[1], minWidth, slide));
    }

    private static double[] getOverlap(LineSeg edge1, LineSeg edge2) {
        double t1 = StrutUtil.getCorrespondingT(edge2, edge1, edge2.p1);
        double t2 = StrutUtil.getCorrespondingT(edge2, edge1, edge2.p2);
        if (Double.isNaN(t1) || Double.isNaN(t2)) {
            return null;
        }
        double[] t = Util.rectify(t1, t2);
        if (t[0] >= 1.0 || t[1] <= 0.0) {
            return null;
        }
        return t;
    }

    public static double getCorrespondingT(LineSeg edge1, LineSeg edge2, Point3d pedge1, boolean clampt) {
        Vector3d planeNormal;
        Vector3d e1dir = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false);
        Vector3d e2dir = edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false);
        Point3d e2p1 = edge2.p1;
        if (e1dir.dot(e2dir) < 0.0) {
            e2p1 = edge2.p2;
            e2dir.negate();
        }
        if (theUtil.eq0((planeNormal = Util3D.cross(e2dir, e1dir)).dot(planeNormal), 1.0E-12)) {
            e1dir.normalize();
            double t = Inter3D.nearestTOnLine(edge2.p1, edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false), pedge1);
            if (clampt) {
                t = Util.clampT(t, 0.0, 1.0);
            }
            return t;
        }
        double rotAngle = Util3D.angle(e1dir, e2dir, planeNormal);
        planeNormal.normalize();
        Plane3d plane = new Plane3d(planeNormal, edge2.p1);
        Point3d e1p1Adjusted = plane.projectOntoPlane(edge1.p1);
        double[] st = new double[2];
        if (!Inter3D.copLineLine(e1p1Adjusted, e1dir, e2p1, e2dir, st, 1.0E-6)) {
            return Double.NaN;
        }
        Point3d rotpt = Util3D.linePoint(e1p1Adjusted, e1dir, st[0]);
        Matrix4d xform = Util.translateMat(rotpt.x, rotpt.y, rotpt.z);
        xform.mul(Util.rotMat(planeNormal.x, planeNormal.y, planeNormal.z, rotAngle));
        xform.mul(Util.translateMat(-rotpt.x, -rotpt.y, -rotpt.z));
        Point3d corresPt = new Point3d(pedge1);
        xform.transform(corresPt);
        double correst = Util3D.tOnLineSeg(edge2.p1, edge2.p2, corresPt);
        if (clampt) {
            correst = Util.clampT(correst, 0.0, 1.0);
        }
        return correst;
    }

    public static double getCorrespondingT(LineSeg edge1, LineSeg edge2, Point3d pedge1) {
        return StrutUtil.getCorrespondingT(edge1, edge2, pedge1, true);
    }

    public static Point3d[] calcStrutBoundaryFull(LineSeg edge1, LineSeg edge2, double t1e1, double t2e1, double t1e2, double t2e2) {
        return StrutUtil.calcStrutBoundary(edge1, edge2, (t1e1 + t2e1) * 0.5, (t2e1 - t1e1) * edge1.length(), (t1e2 + t2e2) * 0.5, (t2e2 - t1e2) * edge2.length());
    }

    public static Point3d[] calcStrutBoundary(LineSeg edge1, LineSeg edge2, double midt1, double desiredStrutWidth) {
        return StrutUtil.calcStrutBoundary(edge1, edge2, midt1, desiredStrutWidth, Double.NaN, desiredStrutWidth);
    }

    public static Point3d[] calcStrutBoundary(LineSeg edge1, LineSeg edge2, double midt1, double desiredStrutWidth1, double desiredStrutWidth2) {
        return StrutUtil.calcStrutBoundary(edge1, edge2, midt1, desiredStrutWidth1, Double.NaN, desiredStrutWidth2);
    }

    public static Point3d[] calcStrutBoundary(LineSeg edge1, LineSeg edge2, double midt1, double desiredWidth1, double midt2, double desiredWidth2) {
        StrutTest test2;
        StrutTest test1;
        boolean aligned = Util3D.testAligned(edge1.p1, edge1.getTangent(0.0, ICurve.Orient.POSITIVE, true), edge2.p2, edge2.getTangent(0.0, ICurve.Orient.POSITIVE, true), 1.0E-6, 1.0E-12);
        double[] bounds1 = new double[]{0.0, 1.0};
        double[] bounds2 = new double[]{0.0, 1.0};
        if (aligned) {
            double[] overlap1 = StrutUtil.getOverlap(edge1, edge2);
            double[] overlap2 = StrutUtil.getOverlap(edge2, edge1);
            if (overlap1 != null && overlap2 != null) {
                bounds1 = overlap1;
                bounds2 = overlap2;
            }
        }
        boolean sameOrient = StrutUtil.sameOrient(edge1, edge2);
        Function<StrutTest, Point3d[]> convertToBoundary = test -> StrutUtil.calcStrutBoundaryNoCross(edge1, test.e1range, edge2, test.e2range, test.midte1, desiredWidth1, test.midte2, desiredWidth2);
        double[] xyisect = Inter2D.isectLineSegLineSeg(edge1.p1.x, edge1.p1.y, edge1.p2.x, edge1.p2.y, edge2.p1.x, edge2.p1.y, edge2.p2.x, edge2.p2.y, 1.0E-6);
        if (xyisect == null || (theUtil.le(xyisect[0], bounds1[0], 1.0E-6) || theUtil.ge(xyisect[0], bounds1[1], 1.0E-6)) && (theUtil.le(xyisect[1], bounds2[0], 1.0E-6) || theUtil.ge(xyisect[1], bounds2[1], 1.0E-6))) {
            return convertToBoundary.apply(new StrutTest(midt1, midt2, bounds1[0], bounds1[1], bounds2[0], bounds2[1]));
        }
        if (sameOrient) {
            test1 = new StrutTest(midt1, midt2, bounds1[0], xyisect[0], bounds2[0], xyisect[1]);
            test2 = new StrutTest(midt1, midt2, xyisect[0], bounds1[1], xyisect[1], bounds2[1]);
        } else {
            test1 = new StrutTest(midt1, midt2, bounds1[0], xyisect[0], xyisect[1], bounds2[1]);
            test2 = new StrutTest(midt1, midt2, xyisect[0], bounds1[1], bounds2[0], xyisect[1]);
        }
        Point3d[] boundary1 = convertToBoundary.apply(test1);
        Point3d[] boundary2 = convertToBoundary.apply(test2);
        double[] slideTFullWidth1 = StrutUtil.getEdgeTs(edge1, midt1, desiredWidth1, bounds1[0], bounds1[1], true);
        if (slideTFullWidth1 != null) {
            boolean edge1Side2;
            boolean edge1Side1 = midt1 <= xyisect[0] && theUtil.le(slideTFullWidth1[1], xyisect[0], 1.0E-6);
            boolean bl = edge1Side2 = midt1 > xyisect[0] && theUtil.ge(slideTFullWidth1[0], xyisect[0], 1.0E-6);
            if (Double.isNaN(midt2)) {
                if (edge1Side1) {
                    return boundary1;
                }
                if (edge1Side2) {
                    return boundary2;
                }
            } else {
                double[] slideTFullWidth2 = StrutUtil.getEdgeTs(edge2, midt2, desiredWidth2, bounds2[0], bounds2[1], true);
                if (slideTFullWidth2 != null) {
                    boolean edge2Side2;
                    boolean edge2Side1 = midt2 <= xyisect[1] && theUtil.le(slideTFullWidth2[1], xyisect[1], 1.0E-6);
                    boolean bl2 = edge2Side2 = midt2 > xyisect[1] && theUtil.ge(slideTFullWidth2[0], xyisect[1], 1.0E-6);
                    if (!sameOrient) {
                        boolean t = edge2Side1;
                        edge2Side1 = edge2Side2;
                        edge2Side2 = t;
                    }
                    if (edge1Side1 && edge2Side1) {
                        return boundary1;
                    }
                    if (edge1Side2 && edge2Side2) {
                        return boundary2;
                    }
                    if (edge1Side1 && edge2Side2 || edge1Side2 && edge2Side1) {
                        return null;
                    }
                    if (edge1Side1 != edge2Side1) {
                        return boundary1;
                    }
                    if (edge1Side2 != edge2Side2) {
                        return boundary2;
                    }
                }
            }
        }
        if (boundary1 == null && boundary2 == null) {
            return null;
        }
        if (boundary2 == null) {
            return boundary1;
        }
        if (boundary1 == null) {
            return boundary2;
        }
        ToDoubleFunction<Point3d[]> getWidthSq = b -> {
            if (((Point3d[])b).length == 2) {
                return b[0].distanceSquared(b[1]);
            }
            return Math.min(b[0].distanceSquared(b[1]), b[2].distanceSquared(b[3]));
        };
        List<Predicate> validityTests = Arrays.asList(StrutUtil::isValidBoundaryStrict, StrutUtil::isValidBoundaryLessStrict);
        HashMap<StrutTest, Point3d[]> testBoundaries = new HashMap<StrutTest, Point3d[]>();
        testBoundaries.put(test1, boundary1);
        testBoundaries.put(test2, boundary2);
        Comparator compareStruts = (t1, t2) -> {
            Point3d[] b1 = (Point3d[])testBoundaries.get(t1);
            Point3d[] b2 = (Point3d[])testBoundaries.get(t2);
            for (Predicate t : validityTests) {
                boolean valid1 = t.test(b1);
                boolean valid2 = t.test(b2);
                if (valid1 && valid2) break;
                if (valid1) {
                    return -1;
                }
                if (!valid2) continue;
                return 1;
            }
            double width1 = getWidthSq.applyAsDouble(b1);
            double width2 = getWidthSq.applyAsDouble(b2);
            int comp = Double.compare(width2, width1);
            if (comp != 0) {
                return comp;
            }
            if (t1.midte1 == midt1) {
                return -1;
            }
            if (t2.midte1 == midt1) {
                return 1;
            }
            return 0;
        };
        return compareStruts.compare(test1, test2) <= 0 ? boundary1 : boundary2;
    }

    private static boolean sameOrient(LineSeg edge1, LineSeg edge2) {
        return edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false).dot(edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false)) >= 0.0;
    }

    private static boolean isValidBoundaryStrict(Point3d[] boundary) {
        if (boundary.length == 2) {
            return true;
        }
        List<Vector3d> normals = Arrays.asList(Util3D.simplePolygonNormal(Arrays.asList(boundary[0], boundary[1], boundary[2]), true), Util3D.simplePolygonNormal(Arrays.asList(boundary[2], boundary[3], boundary[0]), true), Util3D.simplePolygonNormal(Arrays.asList(boundary[0], boundary[1], boundary[3]), true), Util3D.simplePolygonNormal(Arrays.asList(boundary[1], boundary[2], boundary[3]), true));
        for (Vector3d normal : normals) {
            if (normal == null || !theUtil.lt0(normal.z, 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBoundaryLessStrict(Point3d[] boundary) {
        if (boundary.length == 2) {
            return true;
        }
        Vector3d normal = Util3D.simplePolygonNormal(Arrays.asList(boundary), true);
        return normal != null && theUtil.ge0(normal.z, 1.0E-6);
    }

    private static Point3d[] calcStrutBoundaryNoCross(LineSeg edge1, double[] edge1Range, LineSeg edge2, double[] edge2Range, double midt1, double desiredWidth1, double midt2, double desiredWidth2) {
        Point3d e1mid;
        assert (theUtil.ge(midt1, edge1Range[0], 1.0E-6));
        assert (theUtil.le(midt1, edge1Range[1], 1.0E-6));
        if (Double.isNaN(midt2) && Double.isNaN(midt2 = StrutUtil.getCorrespondingT(edge1, edge2, e1mid = edge1.evaluate(midt1)))) {
            return null;
        }
        double[] ta = StrutUtil.getEdgeTs(edge1, midt1, desiredWidth1, edge1Range[0], edge1Range[1], true);
        if (ta == null) {
            return null;
        }
        double[] tb = StrutUtil.getEdgeTs(edge2, midt2, desiredWidth2, edge2Range[0], edge2Range[1], true);
        if (tb == null) {
            return null;
        }
        return StrutUtil.calcStrutBoundaryNoCross(edge1, ta, edge2, tb);
    }

    private static Point3d[] calcStrutBoundaryNoCross(LineSeg edge1, double[] ta, LineSeg edge2, double[] tb) {
        if (ta[0] == ta[1] || tb[0] == tb[1]) {
            return null;
        }
        boolean sameOrient = StrutUtil.sameOrient(edge1, edge2);
        Point3d p1a = edge1.evaluate(ta[0]);
        Point3d p2a = edge1.evaluate(ta[1]);
        Point3d p1b = edge2.evaluate(tb[0]);
        Point3d p2b = edge2.evaluate(tb[1]);
        if (!sameOrient) {
            Point3d temp = p1b;
            p1b = p2b;
            p2b = temp;
        }
        boolean p1eq = p1b.epsilonEquals(p1a, 1.0E-6);
        boolean p2eq = p2b.epsilonEquals(p2a, 1.0E-6);
        if (p1eq && p2eq) {
            return new Point3d[]{p1a, p2a};
        }
        return new Point3d[]{p2a, p1a, p1b, p2b};
    }

    private static double[] isectLinesegLineseg(Point2d l1a, Point2d l1b, Point2d l2a, Point2d l2b, double tol) {
        double[] isect = Inter2D.isectLineLine(l1a, Util2D.vector(l1a, l1b), l2a, Util2D.vector(l2a, l2b), 1.0E-12);
        if (isect == null) {
            return null;
        }
        if (!Util.clampTIfValid(isect, 0.0, 1.0, tol)) {
            return null;
        }
        return isect;
    }

    private static double[] getEdgeTs(LineSeg edge, double midt, double desiredWidth, double mint, double maxt, boolean slide) {
        double halfWidT1 = desiredWidth * 0.5 / edge.length();
        double t1a = midt - halfWidT1;
        double t2a = midt + halfWidT1;
        if (slide) {
            return Geometry.getEdgeSegment(edge, t1a, t2a, mint, maxt, 0.0, true);
        }
        Util.clampT(t1a, mint, maxt);
        Util.clampT(t2a, mint, maxt);
        return new double[]{t1a, t2a};
    }

    public static StrutParam toStrutParam(LineSeg edge, double[] trange) {
        if (trange == null) {
            return null;
        }
        double midt = (trange[0] + trange[1]) * 0.5;
        double width = edge.length() * Math.abs(trange[1] - trange[0]);
        return new StrutParam(midt, width);
    }

    public static Point3d[] calcStrutBoundary(LineSeg edge, StrutParam param) {
        double htwid = 0.5 * param.width / edge.length();
        return new Point3d[]{edge.evaluate(param.midt - htwid), edge.evaluate(param.midt + htwid)};
    }

    public static class StrutParam {
        public final double midt;
        public final double width;

        public StrutParam(double midt, double width) {
            this.midt = midt;
            this.width = width;
        }
    }

    private static class StrutTest {
        public final double midte1;
        public final double midte2;
        public final double[] e1range;
        public final double[] e2range;

        public StrutTest(double midte1, double midte2, double e1min, double e1max, double e2min, double e2max) {
            this.midte1 = Util.clampT(midte1, e1min, e1max);
            this.midte2 = Double.isNaN(midte2) ? midte2 : Util.clampT(midte2, e2min, e2max);
            this.e1range = new double[]{e1min, e1max};
            this.e2range = new double[]{e2min, e2max};
        }
    }
}

