/*
 * Decompiled with CFR 0.152.
 */
package ventus.geom;

import java.awt.geom.Path2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.objs.LineSeg;

public class Geometry {
    public static final Unit LENGTH_UNIT = SI.METER;
    public static final Unit ANGLE_UNIT = SI.RADIAN;
    public static final Unit AREA_UNIT = SI.METER.pow(2);
    public static final Unit ACCEL_UNIT = SI.METER.divide(SI.SECOND.pow(2));
    public static final Unit VEL_UNIT = SI.METER.divide(SI.SECOND);
    public static final double SHORTEST_ARC_EPSILON = 1.0E-5;

    public static Path2D.Double pointsToPath(Collection<Point2d> points) {
        Path2D.Double path = new Path2D.Double();
        Geometry.pointsToPath(path, points);
        return path;
    }

    public static void pointsToPath(Path2D.Double path, Collection<Point2d> points) {
        path.reset();
        if (!points.isEmpty()) {
            Iterator<Point2d> it = points.iterator();
            Point2d firstPoint = it.next();
            path.moveTo(firstPoint.x, firstPoint.y);
            while (it.hasNext()) {
                Point2d next = it.next();
                path.lineTo(next.x, next.y);
            }
        }
    }

    public static double triArea(Point2d p1, Point2d p2, Point2d p3) {
        double area = 0.5 * Math.abs(Geometry.cross(p1, p2, p3));
        return area;
    }

    public static double cross(Point2d origin, Point2d p1, Point2d p2) {
        double area = p1.x * origin.y - origin.x * p1.y + (p2.x * p1.y - p1.x * p2.y) + (origin.x * p2.y - p2.x * origin.y);
        return area;
    }

    public static Vector3d cross(Vector3d v1, Vector3d v2) {
        Vector3d result = new Vector3d();
        result.cross(v1, v2);
        return result;
    }

    public static Vector3d crossN(Vector3d v1, Vector3d v2) {
        Vector3d result = new Vector3d();
        result.cross(v1, v2);
        result.normalize();
        return result;
    }

    private static boolean lequal(double v1, double v2, double tol) {
        return v1 - v2 <= tol;
    }

    private static boolean gequal(double v1, double v2, double tol) {
        return v1 - v2 >= -tol;
    }

    public static Vector3d getPlaneVec(Vector3d planeNormal) {
        if (planeNormal.x == 0.0 && (planeNormal.y == 0.0 || planeNormal.z == 0.0)) {
            return new Vector3d(1.0, 0.0, 0.0);
        }
        if (planeNormal.y == 0.0 && planeNormal.z == 0.0) {
            return new Vector3d(0.0, 1.0, 0.0);
        }
        assert (planeNormal.x != 0.0 || planeNormal.y != 0.0);
        double y = planeNormal.x / Math.sqrt(planeNormal.y * planeNormal.y + planeNormal.x * planeNormal.x);
        double x = Math.sqrt(1.0 - y * y);
        return new Vector3d(x, y, 0.0);
    }

    public static Quat4d shortestArc(Vector3d v1, Vector3d v2, Vector3d fallbackAxis) {
        return Geometry.shortestArc(v1, v2, fallbackAxis, 1.0E-5);
    }

    public static Quat4d shortestArc(Vector3d v1, Vector3d v2) {
        return Geometry.shortestArc(v1, v2, null, 1.0E-5);
    }

    public static Quat4d shortestArc(Vector3d v1, Vector3d v2, double epsilon) {
        return Geometry.shortestArc(v1, v2, null, epsilon);
    }

    public static Quat4d shortestArc(Vector3d v1n, Vector3d v2n, Vector3d fallbackAxisN, double epsilon) {
        Vector3d uv1 = v1n;
        Vector3d uv2 = v2n;
        double d = uv1.dot(uv2);
        if (Geometry.lequal(d, -1.0, epsilon)) {
            if (fallbackAxisN == null) {
                fallbackAxisN = Geometry.getPlaneVec(v1n);
            }
            return new Quat4d(fallbackAxisN.x, fallbackAxisN.y, fallbackAxisN.z, 0.0);
        }
        if (Geometry.gequal(d, 1.0, epsilon)) {
            return new Quat4d(0.0, 0.0, 0.0, 1.0);
        }
        Vector3d cross = new Vector3d();
        cross.cross(uv1, uv2);
        double s = Math.sqrt((1.0 + d) * 2.0);
        double invs = 1.0 / s;
        return new Quat4d(cross.x * invs, cross.y * invs, cross.z * invs, s * 0.5);
    }

    public static Matrix4d getPlaneToPlaneXform(Plane3d plane1, Plane3d plane2) {
        Vector3d normal1 = new Vector3d(plane1.x, plane1.y, plane1.z);
        Vector3d normal2 = new Vector3d(plane2.x, plane2.y, plane2.z);
        Quat4d shortestRot = Geometry.shortestArc(normal1, normal2);
        double planeDist1 = -plane1.w;
        double planeDist2 = -plane2.w;
        normal2.scale(planeDist2 - planeDist1);
        Matrix4d mat = new Matrix4d();
        mat.set(shortestRot);
        mat.m03 = normal2.x;
        mat.m13 = normal2.y;
        mat.m23 = normal2.z;
        return mat;
    }

    public static Matrix4d getWorldToLocalXform(Plane3d localPlane) {
        return Util.getWorldToLocalXform(localPlane);
    }

    public static Matrix4d getLocalToWorldXform(Plane3d localPlane) {
        return Util.getLocalToWorldXform(localPlane);
    }

    public static Plane3d getPlane(Matrix4d localToWorldXform) {
        return Util.getPlane(localToWorldXform);
    }

    public static double[] getEdgeSegment(LineSeg edge, double loc1, double loc2, double minEdgeT, double maxEdgeT, double minWidth, boolean slide) {
        double[] t = Util.rectify(loc1, loc2);
        loc1 = t[0];
        loc2 = t[1];
        double edgelen = edge.length();
        double minWidthT = minWidth / edgelen;
        if (loc2 <= minEdgeT || loc1 >= maxEdgeT) {
            return null;
        }
        if (slide) {
            double widtht = loc2 - loc1;
            double maxEdgeWidthT = maxEdgeT - minEdgeT;
            if (widtht > maxEdgeWidthT) {
                widtht = maxEdgeWidthT;
            }
            if (widtht < 1.0E-6 || widtht < minWidthT) {
                return null;
            }
            if (loc2 > maxEdgeT) {
                loc2 = maxEdgeT;
                loc1 = loc2 - widtht;
            } else if (loc1 < minEdgeT) {
                loc1 = minEdgeT;
                loc2 = loc1 + widtht;
            }
            return new double[]{loc1, loc2};
        }
        if ((loc1 = Util.clampT(loc1, minEdgeT, maxEdgeT)) == (loc2 = Util.clampT(loc2, minEdgeT, maxEdgeT))) {
            return null;
        }
        double widtht = loc2 - loc1;
        if (widtht < 1.0E-6 || widtht < minWidthT) {
            return null;
        }
        return new double[]{loc1, loc2};
    }

    public static Point3d[] findConvexHull(Point3d[] input) {
        if (input == null || input.length == 0) {
            return null;
        }
        Mesh m = new Mesh();
        double z = input[0].z;
        for (Point3d p : input) {
            assert (p.z == z);
            m.addPoint(p.x, p.y);
        }
        m.triangulateConvexHull(0, 0.0);
        TriangulatorInfo result = m.getOutput(4);
        HashMap<Integer, Integer> nodeMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < result.edges.length - 1; i += 2) {
            nodeMap.put(result.edges[i], result.edges[i + 1]);
        }
        Point3d[] convexHull = new Point3d[result.edges.length / 2];
        Point2d start = result.points[result.edges[0]];
        int currentID = result.edges[0];
        convexHull[0] = new Point3d(start.x, start.y, z);
        for (int i = 0; i < convexHull.length - 1; ++i) {
            currentID = (Integer)nodeMap.get(currentID);
            Point2d p = result.points[currentID];
            convexHull[i + 1] = new Point3d(p.x, p.y, z);
        }
        return convexHull;
    }

    public static boolean circlePoly(Point3d circleLoc, double circleRad, Point3d[] pol) {
        if (pol == null || pol.length == 0) {
            return false;
        }
        if (Inter3D.pointInPoly(1.0E-6, circleLoc, pol)) {
            return true;
        }
        double radSq = Math.pow(circleRad, 2.0);
        for (int i = 0; i < pol.length; ++i) {
            Point3d p1 = pol[i];
            Point3d p2 = pol[(i + 1) % pol.length];
            if (!(Inter3D.distSqToNearestPtOnLineSeg(p1, p2, circleLoc) <= radSq)) continue;
            return true;
        }
        return false;
    }
}

