/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import java.util.Map;
import org.jscience.physics.units.Unit;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.value.PiecewiseFunction1d;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileRoot;
import ventus.io.contamx.PrjData;

public class WindProfilePrjDataWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.BEFORE_NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        WindProfileRoot root = (WindProfileRoot)md.getComponentData("WindProfile.data");
        for (WindProfile in : root.flatten(WindProfile.class)) {
            PrjData.WindProfile out = new PrjData.WindProfile(in);
            prjData.windProfileList.add(out);
            prjData.nwpf = prjData.windProfileList.size();
            out.nr = prjData.windProfileList.size();
            out.graphLineType = in.get(WindProfile.GRAPH_TYPE).prjLineType;
            out.name = in.getName();
            out.description = in.get(WindProfile.DESC);
            PiecewiseFunction1d func = in.get(WindProfile.FUNC).toPiecewise(Unit.ONE);
            out.npts = func.entries.length;
            for (PiecewiseFunction1d.Entry entry : func.entries) {
                out.degrees.add(entry.x.getValue(Unit.ONE));
                out.coefficient.add(entry.y.getValue(Unit.ONE));
            }
        }
    }
}

