/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import java.util.Collections;
import javax.swing.Icon;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.actions.copypaste.DefaultPasteHandler;
import ventus.feature.Feature;
import ventus.feature.comps.BasicHotkey;
import ventus.feature.comps.DefaultCompositeDataModel;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.comps.IDefaultAction;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.windprofiles.EditWindProfileOp;
import ventus.feature.windprofiles.EventHandlers;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileOISHandler;
import ventus.feature.windprofiles.WindProfilePrjDataWriter;
import ventus.feature.windprofiles.WindProfileRoot;
import ventus.gui.guiUtil;

public class WindProfileFeature {
    public static final String GUID = "WindProfile.data";
    private static final int s_treeRootIndex = 63;
    static final Icon s_icon_windProfile = guiUtil.loadIconSvg(WindProfileRoot.class.getResource("icons/wind-profile.svg"), 16);

    public static Feature create() {
        DefaultCompositeDataModel dataModel = new DefaultCompositeDataModel(() -> new WindProfileRoot(Intl.intl("Wind Profiles")), GUID, 63);
        dataModel.addEntryPoint(EntryPointHelper.rootEP(WindProfileRoot.class, s_icon_windProfile));
        dataModel.addEntryPoint(EntryPointHelper.groupEP(GUID, WindProfileRoot.WindProfileNode.class, s_icon_windProfile, Intl.intl("Wind Profile Group")));
        dataModel.addEntryPoint(EntryPointHelper.objectEP(GUID, WindProfile.class, s_icon_windProfile, Intl.intl("Wind Profile")));
        WindProfilePrjDataWriter dataWriter = new WindProfilePrjDataWriter();
        IContextMenuItem ctxItem = root -> root.getNode("create").add(EditWindProfileOp.UI_HOOK);
        IDefaultAction defAction = () -> Collections.singleton(EditWindProfileOp.UI_HOOK);
        IAppMenuItem menuItem = root -> root.getNode("model").add(30, (Object)EditWindProfileOp.UI_MENUITEM.getMenuItem());
        ISelectionRibbon ribbon = ISelectionRibbon.newDefaultSelectionRibbon(WindProfile.class, EditWindProfileOp.UI_HOOK);
        DefaultPasteHandler windProfilePasteHandler = new DefaultPasteHandler(WindProfileRoot.class);
        return new Feature(dataModel, dataWriter, ctxItem, defAction, menuItem, new BasicHotkey<UIHook>("editWindProfile", ShortcutInfo.Category.CONTEXT, EditWindProfileOp.UI_HOOK, true), new BasicHotkey<UIHook>("editWindProfileMenu", ShortcutInfo.Category.MODEL, EditWindProfileOp.UI_MENUITEM, false), EventHandlers.onSelectionChanged(), windProfilePasteHandler, ribbon, new WindProfileOISHandler());
    }
}

