/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PlotData;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.property.Function1dProp;
import ventus.data.value.IFunction1d;
import ventus.data.value.PiecewiseFunction1d;
import ventus.feature.props.DisplayProp;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropertyDefs;
import ventus.feature.props.TypedProps;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;

public class WindProfile
extends NamedMerlinObj
implements Serializable,
ISurrogate,
IDirectDependent<VentusData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<WindProfile> PROP_TYPES = new PropertyDefs<WindProfile>(PropertyDefs.serializedOnly(obj -> obj.d_properties, obj -> {
        obj.d_properties = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES).attrDefaults(Object.class, attrs -> attrs.attrSurrogateEquals(null));
    public static final DisplayProp<String> DESC = (DisplayProp)DisplayProps.build((Object)"WindProfile.DESC", "", Intl.intl("Description"), Intl.intl("Wind Profile Description")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static final PlotData EMPTY_PROFILE = WindProfile.getEmptyProfile();
    public static final IFunction1d WIND_PROFILE_FUNCTION = PiecewiseFunction1d.newFunction(EMPTY_PROFILE);
    public static final DisplayProp<IFunction1d> FUNC = (DisplayProp)DisplayProps.build((Object)"WindProfile.FUNC", IFunction1d.class, WIND_PROFILE_FUNCTION, Intl.intl("Function"), Intl.intl("Wind Profile Function")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Boolean> IS_DEFAULT = TypedProps.build((Object)"WindProfile.IS_DEFAULT", false).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<CurveType> GRAPH_TYPE = (DisplayProp)DisplayProps.build((Object)"WindProfile.GRAPH_TYPE", CurveType.class, CurveType.LINEAR, Intl.intl("Curve Fit"), Intl.intl("Wind Profile Curve Fit")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final Function1dProp PROP_FUNDAMENTAL = WindProfile.newFundamentalProp("WindProfile.FUNDAMENTAL", Intl.intl("Wind Profile"), Intl.intl("Description"), Intl.intl("Wind Profiles"), WIND_PROFILE_FUNCTION).attrFinish();
    private PropertySet d_properties = new PropertySet();

    private static PropertyDefs.AttributeBuilder<IFunction1d, Function1dProp> newFundamentalProp(String name, String desc, String longDesc, String displayName, IFunction1d defFunction) {
        Function<Component, IFunction1d> f = comp -> defFunction;
        Function1dProp.PredefFunction[] predef = new Function1dProp.PredefFunction[]{new Function1dProp.PredefFunction(Intl.intl("wind profiles"), Intl.intl("Load default profile..."), f)};
        Function1dProp prop = new Function1dProp((Object)name, defFunction, desc, longDesc, displayName, new Function1dProp.Var(Intl.intl("Angle [deg]"), 10, UnitDoubleVR.between(0.0, 360.0, Unit.ONE, true, true)), new Function1dProp.Var(Intl.intl("Coefficient"), 10, UnitDoubleVR.between(-1.0, 1.0, Unit.ONE, true, true)), new UnitDouble[]{new UnitDouble(0.0, Unit.ONE), new UnitDouble(-1.0, Unit.ONE), new UnitDouble(360.0, Unit.ONE), new UnitDouble(1.0, Unit.ONE)}, predef);
        return PROP_TYPES.storeAsPlainOldData(prop);
    }

    public WindProfile(String name, String desc, IFunction1d func) {
        super(name);
        this.set(DESC, desc);
        this.set(FUNC, func);
        this.set(IS_DEFAULT, true);
    }

    public WindProfile(String name) {
        super(name);
        this.set(FUNC, WIND_PROFILE_FUNCTION);
        this.set(IS_DEFAULT, false);
        this.set(GRAPH_TYPE, CurveType.LINEAR);
    }

    public boolean isMatch(WindProfile other, Predicate<? super TypedProp<?>> propFilter) {
        Predicate<TypedProp> test = prop -> !propFilter.test((TypedProp<?>)prop) || Objects.equals(other.get(prop), this.get(prop));
        return test.test(NAME) && test.test(DESC) && test.test(FUNC) && test.test(IS_DEFAULT) && test.test(GRAPH_TYPE);
    }

    protected PropertyDefs<WindProfile> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public WindProfile clone() {
        return (WindProfile)super.clone();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        TypedProp<String> oldNameProp;
        is.defaultReadObject();
        TypedProp<String> oldName = thunderheadeng.util.TypedProps.newProp((Object)"WindProfile.NAME", "", new Object[0]);
        if (this.d_properties.isDefined(oldName)) {
            this.setName(this.d_properties.get(oldName));
            this.d_properties.remove(oldName);
        }
        if (this.d_properties.isDefined(oldNameProp = thunderheadeng.util.TypedProps.newProp((Object)"NamedMerlinObj.NAME", "", new Object[0]))) {
            this.setName(this.d_properties.get(oldNameProp));
            this.d_properties.remove(oldNameProp);
        }
    }

    private static PlotData getEmptyProfile() {
        return new PlotData(Unit.ONE, Unit.ONE, false, new double[]{0.0, 0.7, 90.0, -0.7, 180.0, -0.4, 270.0, -0.7, 360.0, 0.7});
    }

    public static enum CurveType {
        LINEAR(Intl.intl("1-Linear"), Intl.intl("Linear"), 2, 1),
        CUBIC(Intl.intl("2-Cubic"), Intl.intl("Cubic Spline"), 3, 2),
        TRIG(Intl.intl("3-Trigonometric"), Intl.intl("Trigonometric"), 5, 3);

        public final String name;
        public final String desc;
        public final int minPointsReq;
        public final int prjLineType;

        private CurveType(String name, String desc, int p, int type) {
            this.name = name;
            this.desc = desc;
            this.minPointsReq = p;
            this.prjLineType = type;
        }
    }

    @Deprecated
    static enum Types {
        CURVE1(CurveType.LINEAR),
        CURVE2(CurveType.CUBIC),
        CURVE3(CurveType.TRIG);

        CurveType resolveAs;

        private Types(CurveType resolveAs) {
            this.resolveAs = resolveAs;
        }
    }
}

