/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.weather;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import ventus.Intl;
import ventus.feature.weather.ListValueEditor;
import ventus.feature.weather.WeatherProps;
import ventus.unitsystem.UnitSystem;

public class EditWeatherDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final Map<String, EditorPanel> d_tabs = new LinkedHashMap<String, EditorPanel>();

    public EditWeatherDlg(JFrame owner, UnitSystem usys) {
        super((Window)owner, Intl.intl("Weather and Wind"), 9);
        this.d_tabs.put(Intl.intl("Weather"), new WeatherEditor(usys));
        this.d_tabs.put(Intl.intl("Wind"), new WindEditor(usys));
        JTabbedPane jtp = new JTabbedPane();
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            jtp.addTab(entry.getKey(), entry.getValue());
        }
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new BorderLayout());
        dlgPanel.add((Component)jtp, "Center");
    }

    public void load(WeatherProps dm) {
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            entry.getValue().load(dm);
        }
        this.setModified(false);
    }

    public void store(WeatherProps dm) {
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            entry.getValue().store(dm);
        }
    }

    private static class WeatherEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final ListValueEditor ambientTemp;
        private final ListValueEditor windDirection;
        private final ValueField<UnitDouble> absPressure;
        private final guiDoubleField relativeHumidity;
        private final guiDoubleField humidityRatio;
        private final guiDoubleField massFraction;
        private final ValueField<UnitDouble> windSpeed;

        public WeatherEditor(UnitSystem usys) {
            this.ambientTemp = new ListValueEditor(Intl.intl("Ambient Temperature"), usys.getTemperature());
            this.absPressure = ValueFields.udFld(101325.0, DoubleVR.UNBOUNDED, usys.getPressure());
            this.relativeHumidity = new guiDoubleField(0.0);
            this.humidityRatio = new guiDoubleField(0.0);
            this.massFraction = new guiDoubleField(0.0);
            this.humidityRatio.setEditable(false);
            this.massFraction.setEditable(false);
            this.windDirection = new ListValueEditor(Intl.intl("Wind Direction"), usys.getAngle());
            this.windSpeed = ValueFields.udFld(0.0, DoubleVR.UNBOUNDED, usys.getVelocity());
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addTitle(Intl.intl("Steady State Weather Data"));
            gb.addRowSpace(8);
            gb.addRow(Intl.intl("Ambient Temperature:"), this.ambientTemp.field, this.ambientTemp.linkButton);
            gb.addRow(Intl.intl("Absolute Pressure:"), this.absPressure);
            gb.addRow(Intl.intl("Relative Humidity:"), this.relativeHumidity, Intl.intl("RH"));
            gb.addRow(Intl.intl("Humidity Ratio:"), this.humidityRatio, Intl.intl("g(w)/kg (dry)"));
            gb.addRow(Intl.intl("Mass Fraction (H2O):"), this.massFraction, Intl.intl("kg(w)/kg (air)"));
            gb.addRow(Intl.intl("Wind Speed:"), this.windSpeed);
            gb.addRow(Intl.intl("Wind Direction:"), this.windDirection.field, this.windDirection.linkButton);
            gb.finalizeRows();
        }

        @Override
        public void load(WeatherProps dm) {
            this.ambientTemp.setValue(dm.get(WeatherProps.ambientTemp));
            this.absPressure.setValue(dm.get(WeatherProps.absPressure));
            this.relativeHumidity.setValue(dm.get(WeatherProps.relativeHumidity));
            this.humidityRatio.setValue(dm.get(WeatherProps.humidityRatio));
            this.massFraction.setValue(dm.get(WeatherProps.massFraction));
            this.windSpeed.setValue(dm.get(WeatherProps.windSpeed));
            this.windDirection.setValue(dm.get(WeatherProps.windDirection));
        }

        @Override
        public void store(WeatherProps dm) {
            dm.set(WeatherProps.ambientTemp, this.ambientTemp.getValue());
            dm.set(WeatherProps.absPressure, (UnitDouble)this.absPressure.getValue());
            dm.set(WeatherProps.relativeHumidity, (Double)this.relativeHumidity.getValue());
            dm.set(WeatherProps.windSpeed, (UnitDouble)this.windSpeed.getValue());
            dm.set(WeatherProps.windDirection, this.windDirection.getValue());
        }
    }

    private static class WindEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final ValueField<UnitDouble> relativeNorthDegree;
        private final ValueField<UnitDouble> roofWallHeight;
        private final ValueField<Double> localTerrainConst;
        private final ValueField<Double> velocityProfileExpo;
        private final guiDoubleField windSpeedModifier;

        public WindEditor(UnitSystem usys) {
            this.relativeNorthDegree = ValueFields.udFld(0.0, DoubleVR.UNBOUNDED, usys.getAngle());
            this.roofWallHeight = ValueFields.udFld(UnitDouble.convert(10.0, SI.METER, usys.getLength()), DoubleVR.UNBOUNDED, usys.getLength());
            this.localTerrainConst = ValueFields.doubleFld(0.6);
            this.velocityProfileExpo = ValueFields.doubleFld(0.28);
            this.windSpeedModifier = new guiDoubleField(0.0);
            this.windSpeedModifier.setEditable(false);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addTitle(Intl.intl("Wind Speed Modifier Calculation Data"));
            gb.addRowSpace(8);
            gb.addRow(Intl.intl("Relative North:"), this.relativeNorthDegree);
            gb.addRow(Intl.intl("Roof or Wall Height:"), this.roofWallHeight);
            gb.addRow(Intl.intl("Local Terrain Constant:"), this.localTerrainConst);
            gb.addRow(Intl.intl("Velocity Profile Exponent:"), this.velocityProfileExpo);
            gb.addRow(Intl.intl("Wind Speed Modifier:"), this.windSpeedModifier);
            gb.finalizeRows();
            this.roofWallHeight.addActionListener(e -> this.updateWindSpeedMod());
            this.localTerrainConst.addActionListener(e -> this.updateWindSpeedMod());
            this.velocityProfileExpo.addActionListener(e -> this.updateWindSpeedMod());
        }

        private void updateWindSpeedMod() {
            double newmod = Math.pow((Double)this.localTerrainConst.getValue(), 2.0) * Math.pow(((UnitDouble)this.roofWallHeight.getValue()).get(SI.METER) / 10.0, 2.0 * (Double)this.velocityProfileExpo.getValue());
            this.windSpeedModifier.setValue(newmod);
        }

        @Override
        public void load(WeatherProps dm) {
            this.relativeNorthDegree.setValue(dm.get(WeatherProps.relativeNorthDegree));
            this.roofWallHeight.setValue(dm.get(WeatherProps.roofWallHeight));
            this.localTerrainConst.setValue(dm.get(WeatherProps.localTerrainConst));
            this.velocityProfileExpo.setValue(dm.get(WeatherProps.velocityProfileExpo));
            this.windSpeedModifier.setValue(dm.get(WeatherProps.windSpeedModifier));
            this.updateWindSpeedMod();
        }

        @Override
        public void store(WeatherProps dm) {
            dm.set(WeatherProps.relativeNorthDegree, (UnitDouble)this.relativeNorthDegree.getValue());
            dm.set(WeatherProps.roofWallHeight, (UnitDouble)this.roofWallHeight.getValue());
            dm.set(WeatherProps.localTerrainConst, (Double)this.localTerrainConst.getValue());
            dm.set(WeatherProps.velocityProfileExpo, (Double)this.velocityProfileExpo.getValue());
            dm.set(WeatherProps.windSpeedModifier, (Double)this.windSpeedModifier.getValue());
        }
    }

    private static abstract class EditorPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;

        private EditorPanel() {
        }

        public abstract void load(WeatherProps var1);

        public abstract void store(WeatherProps var1);
    }
}

