/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.tags;

import java.util.Arrays;
import java.util.Collection;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.IDefaultAction;
import ventus.feature.tags.ShowTaggedObjects;
import ventus.feature.tags.Tag;

class ActivateTagAction
implements IDefaultAction,
IEventObserver {
    final UIHook activateTags = new UIHook(new ActivateTag(), "");

    @Override
    public Collection<UIHook> getDoubleClickActions() {
        return Arrays.asList(this.activateTags);
    }

    @Override
    public void update(Events events) {
        if (SelectionObserver.isSelectionEvent(events)) {
            VentusData md = VentusApp.getAppData();
            assert (md != null);
            this.updateEnabled(md);
        }
    }

    private void updateEnabled(VentusData md) {
        boolean enabledFlag = md.selection.flatten(Tag.class).isExclusive();
        this.activateTags.setEnabled(enabledFlag);
    }

    private static class ActivateTag
    extends AMerlinOp {
        private ActivateTag() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            IFilteredCollection<Tag> tags = md.selection.flatten(Tag.class);
            LinkedIdentityHashSet<? extends IMerlinObj> objs = ShowTaggedObjects.getObjsAny(md, tags);
            ShowTaggedObjects.showTaggedObjects(app.getActiveFrame(), Intl.intl("Tagged Objects"), md, objs);
        }
    }
}

