/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.actions.copypaste.DefaultPasteHandler;
import ventus.data.IMerlinObj;
import ventus.data.schematics.SimError;
import ventus.feature.Feature;
import ventus.feature.comps.DefaultCompositeDataModel;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.sourcesink.EditSourceSinkElementMgrOp;
import ventus.feature.sourcesink.EditSourceSinkElementOp;
import ventus.feature.sourcesink.NewSourceSink;
import ventus.feature.sourcesink.SourceSink;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.sourcesink.SourceSinkElementData;
import ventus.feature.sourcesink.SourceSinkElementOISHandler;
import ventus.feature.sourcesink.SourceSinkElementPrjWriter;
import ventus.feature.sourcesink.SourceSinkElementRoot;
import ventus.feature.sourcesink.SourceSinkOISHandler;
import ventus.feature.sourcesink.SourceSinkPrjWriter;
import ventus.feature.sourcesink.SourceSinkRibbon;
import ventus.feature.sourcesink.SourceSinkRoot;
import ventus.feature.sourcesink.SourceSinkSceneItem;
import ventus.gui.guiUtil;

public class SourceSinkFeature {
    public static final String GUID = "SourceSink.data";
    public static final int SEQ_IX = 57;
    public static final ImageIcon ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(SourceSink.class, "icons/source-sink.svg"), 16);

    public static Feature create() {
        SourceSinkElementData elementData = new SourceSinkElementData();
        SourceSinkElementOISHandler elementOIS = new SourceSinkElementOISHandler();
        SourceSinkElementPrjWriter elementPrjWriter = new SourceSinkElementPrjWriter();
        EditSourceSinkElementOp editElementOp = new EditSourceSinkElementOp();
        EditSourceSinkElementMgrOp editElementMgrOp = new EditSourceSinkElementMgrOp();
        ISelectionRibbon elementRibbon = ISelectionRibbon.newDefaultSelectionRibbon(SourceSinkElement.class, editElementOp.uiHook);
        DefaultPasteHandler elementPasteHandler = new DefaultPasteHandler(SourceSinkElementRoot.class);
        DefaultCompositeDataModel sourceSinkData = new DefaultCompositeDataModel(SourceSinkRoot::new, GUID, 57);
        sourceSinkData.addEntryPoint(EntryPointHelper.rootEP(SourceSinkRoot.class, ICON));
        sourceSinkData.addEntryPoint(EntryPointHelper.groupEP(GUID, SourceSinkRoot.SourceSinkNode.class, ICON, Intl.intl("Source/Sink Group")));
        sourceSinkData.addEntryPoint(EntryPointHelper.objectEP(GUID, SourceSink.class, ICON, Intl.intl("Source/Sink")));
        EntryPointHelper<SourceSink> fpHelper = EntryPointHelper.helperEP(SourceSink.class);
        fpHelper.getErrors = (vd, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.get(SourceSink.ROOM) == null) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s is not connected to any zones."), obj.getName()), Intl.intl("Delete Source/Sink or re-attach to a surface."), (IMerlinObj)obj));
            }
            if (obj.get(SourceSink.ELEMENT) == null) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s does not have a Source/Sink Element."), obj.getName()), Intl.intl("Delete Source/Sink or set its element."), (IMerlinObj)obj));
            }
            return errors;
        };
        fpHelper.register();
        SourceSinkOISHandler sourceSinkOIS = new SourceSinkOISHandler();
        SourceSinkPrjWriter sourceSinkPrjWriter = new SourceSinkPrjWriter();
        SourceSinkRibbon sourceSinkRibbon = new SourceSinkRibbon();
        SourceSinkSceneItem sourceSinkSceneItem = new SourceSinkSceneItem();
        NewSourceSink newSourceSinkTool = new NewSourceSink();
        DefaultPasteHandler sourceSinkPasteHandler = new DefaultPasteHandler(SourceSinkRoot.class);
        return new Feature(elementData, elementOIS, elementPrjWriter, editElementOp, editElementMgrOp, elementRibbon, elementPasteHandler, sourceSinkData, sourceSinkOIS, sourceSinkPrjWriter, sourceSinkRibbon, sourceSinkSceneItem, newSourceSinkTool, sourceSinkPasteHandler);
    }
}

