/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import thunderheadeng.geometry.Ray3d;
import thunderheadeng.geometry.Util3D;
import ventus.feature.flowpaths.FlowPath;
import ventus.io.contamx.PrjData;

class OutputDataReaderVis {
    OutputDataReaderVis() {
    }

    public static List<LineSegData> getLineSegsResults(PrjData inputData, File prjFile, String extn) {
        ArrayList<LineSegData> lineSegs = new ArrayList<LineSegData>();
        String baseName = FilenameUtils.getBaseName(prjFile.getPath());
        File f = new File(prjFile.getParentFile(), baseName + extn);
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + f.getPath());){
            Statement stmt = connection.createStatement();
            stmt.setQueryTimeout(1);
            for (PrjData.AirFlowPath afp : inputData.airFlowPathList) {
                LineSegData data = OutputDataReaderVis.getLineSegData(afp, stmt);
                if (data == null) continue;
                lineSegs.add(data);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (lineSegs.isEmpty()) {
            return Collections.emptyList();
        }
        return OutputDataReaderVis.normalize(lineSegs);
    }

    private static List<LineSegData> normalize(List<LineSegData> unscaled) {
        double dpMax = -1.7976931348623157E308;
        double flow0Max = -1.7976931348623157E308;
        for (LineSegData lineSeg : unscaled) {
            for (double dp : lineSeg.dps) {
                dpMax = Math.max(dpMax, Math.abs(dp));
            }
            for (double flow0 : lineSeg.flow0s) {
                flow0Max = Math.max(flow0Max, Math.abs(flow0));
            }
        }
        double dpScale = dpMax != 0.0 ? 1.0 / dpMax : 1.0;
        double flow0Scale = flow0Max != 0.0 ? 1.0 / flow0Max : 1.0;
        ArrayList<LineSegData> scaled = new ArrayList<LineSegData>(unscaled.size());
        for (LineSegData lineSegData : unscaled) {
            scaled.add(new LineSegData(lineSegData, dpScale, flow0Scale));
        }
        return scaled;
    }

    private static LineSegData getLineSegData(PrjData.AirFlowPath afp, Statement stmt) throws SQLException {
        Object object = afp.refObj;
        if (object instanceof FlowPath) {
            FlowPath fp = (FlowPath)object;
            Ray3d baseGeom = OutputDataReaderVis.getResultsPathBaseGeom(fp);
            String desc = fp.getName();
            String query = String.format("SELECT T.Time, LP.dP, LP.Flow0\nFROM LINKPATHDATA AS LP\nLEFT JOIN TIME AS T ON LP.TimeID = T.TimeID\nWHERE LP.PathNumber == %1$d;\n", afp.nr);
            ArrayList<Double> times = new ArrayList<Double>();
            ArrayList<Double> dps = new ArrayList<Double>();
            ArrayList<Double> flow0s = new ArrayList<Double>();
            try (ResultSet rs = stmt.executeQuery(query);){
                while (rs.next()) {
                    times.add(rs.getDouble(1));
                    dps.add(rs.getDouble(2));
                    flow0s.add(rs.getDouble(3));
                }
            }
            return new LineSegData(afp, desc, baseGeom, ArrayUtils.toPrimitive(times.toArray(new Double[0])), ArrayUtils.toPrimitive(dps.toArray(new Double[0])), ArrayUtils.toPrimitive(flow0s.toArray(new Double[0])));
        }
        return null;
    }

    private static Ray3d getResultsPathBaseGeom(FlowPath fp) {
        Vector3d endNorm;
        Point3d endPt;
        Vector3d startNorm;
        Point3d startPt;
        if (fp.isExterior() && fp.getStartZone() != null) {
            startPt = new Point3d(fp.get(FlowPath.START_LOCATION));
            startNorm = new Vector3d(fp.get(FlowPath.START_NORMAL));
            endPt = new Point3d(fp.get(FlowPath.START_LOCATION));
            endNorm = Util3D.negate(fp.get(FlowPath.START_NORMAL));
        } else if (fp.isExterior() && fp.getEndZone() != null) {
            startPt = new Point3d(fp.get(FlowPath.END_LOCATION));
            startNorm = Util3D.negate(fp.get(FlowPath.END_NORMAL));
            endPt = new Point3d(fp.get(FlowPath.END_LOCATION));
            endNorm = new Vector3d(fp.get(FlowPath.END_NORMAL));
        } else {
            assert (!fp.isExterior());
            startPt = new Point3d(fp.get(FlowPath.START_LOCATION));
            startNorm = new Vector3d(fp.get(FlowPath.START_NORMAL));
            endPt = new Point3d(fp.get(FlowPath.END_LOCATION));
            endNorm = new Vector3d(fp.get(FlowPath.END_NORMAL));
        }
        boolean flipDirection = fp.get(FlowPath.DIRECTION);
        if (!flipDirection) {
            return new Ray3d(endPt, endNorm, 1.0);
        }
        return new Ray3d(startPt, startNorm, 1.0);
    }

    public static class LineSegData {
        public final PrjData.AirFlowPath refObj;
        public final String refObjDesc;
        public final Ray3d baseGeom;
        public final double[] times;
        public final double[] dps;
        public final double[] flow0s;
        public final double scaleFactorDp;
        public final double scaleFactorFlow0;

        public LineSegData(PrjData.AirFlowPath refObj, String refObjDesc, Ray3d baseGeom, double[] times, double[] dps, double[] flow0s) {
            this.refObj = refObj;
            this.refObjDesc = refObjDesc;
            this.baseGeom = baseGeom;
            this.times = times;
            this.dps = dps;
            this.flow0s = flow0s;
            this.scaleFactorDp = 1.0;
            this.scaleFactorFlow0 = 1.0;
        }

        public LineSegData(LineSegData original, double dpScale, double flow0Scale) {
            this.refObj = original.refObj;
            this.refObjDesc = original.refObjDesc;
            this.baseGeom = original.baseGeom;
            this.times = original.times;
            this.dps = original.dps;
            this.flow0s = original.flow0s;
            this.scaleFactorDp = dpScale;
            this.scaleFactorFlow0 = flow0Scale;
        }
    }
}

