/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.Desktop;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.comps.IDefaultAction;
import ventus.feature.results.DataNode;
import ventus.feature.results.DataTable;
import ventus.feature.results.NodeProps;
import ventus.unitsystem.UnitSystem;

class OpenFileAction
implements IAppMenuItem,
IContextMenuItem,
IDefaultAction,
IEventObserver {
    private final UIHook open = new UIHook(new OpenResult(OpenFileAction::getDataNodeFromSelection), Intl.intl("Open File"));
    private final UIHook showNodeZoneFlowsData = new UIHook(new OpenResult(OpenFileAction::getNodeZoneFlowsData), Intl.intl("Show Node-Zone Flows"));
    private final UIHook showLinkPathFlowsData = new UIHook(new OpenResult(OpenFileAction::getLinkPathFlowsData), Intl.intl("Show Link-Path Flows"));

    private static DataNode getDataNodeFromSelection(VentusApp app, VentusData md) {
        Set dataNodes = md.selection.getSelected(DataNode.class);
        if (dataNodes.iterator().hasNext()) {
            return (DataNode)dataNodes.iterator().next();
        }
        return null;
    }

    private static DataNode getNodeZoneFlowsData(VentusApp app, VentusData data) {
        DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)data.getComponentData("results.data");
        return resultsRoot.nodeZoneFlows;
    }

    private static DataNode getLinkPathFlowsData(VentusApp app, VentusData data) {
        DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)data.getComponentData("results.data");
        return resultsRoot.linkPathData;
    }

    private static void showHtmlResult(String title, String head, String body) {
        try {
            InputStream templateFile = OpenFileAction.class.getResourceAsStream("template.html");
            String template = IOUtils.toString(templateFile, StandardCharsets.UTF_8).replaceAll("<!--title-->", Matcher.quoteReplacement(title)).replaceAll("<!--head-->", Matcher.quoteReplacement(head)).replaceAll("<!--body-->", Matcher.quoteReplacement(body));
            Path tmpPath = Files.createTempFile("ventus", ".html", new FileAttribute[0]);
            FileUtils.writeStringToFile(tmpPath.toFile(), template, StandardCharsets.UTF_8);
            Desktop.getDesktop().open(tmpPath.toFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(Events events) {
        IEventRecord<IDomainObject> changelog = events.getEvents(IDomainObject.class, new Class[0]);
        if (changelog.containsChange(VentusData.SELECTION_CHANGED) || changelog.containsChange(VentusData.MODEL_RESET) || changelog.containsChange(VentusData.MODEL_LOADED)) {
            VentusData md = VentusApp.getAppData();
            assert (md != null);
            this.updateEnabled(md);
        }
    }

    private void updateEnabled(VentusData md) {
        boolean enabledFlag = false;
        enabledFlag = md.selection.isSingleExclusive(DataNode.TextData.class) || md.selection.isSingleExclusive(DataNode.MergedData.class);
        this.open.setEnabled(enabledFlag);
    }

    @Override
    public Collection<UIHook> getDoubleClickActions() {
        return Arrays.asList(this.open);
    }

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        root.getNode("edit").add(this.open);
    }

    @Override
    public void addMenuItems(GroupedSequence root) {
        root.getNode("results").add(60, (Object)this.showNodeZoneFlowsData);
        root.getNode("results").add(61, (Object)this.showLinkPathFlowsData);
    }

    public static class OpenResult
    extends AMerlinOp {
        private final BiFunction<VentusApp, VentusData, DataNode> getDataNode;

        public OpenResult(BiFunction<VentusApp, VentusData, DataNode> getDataNode) {
            this.getDataNode = getDataNode;
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            DataNode obj = this.getDataNode.apply(app, md);
            if (obj == null) {
                String msg = Intl.intl("Unable to view results data. Have you run the simulation?");
                JOptionPane.showMessageDialog(app.getMainFrame(), msg);
            }
            if (obj instanceof DataNode.TextData) {
                DataNode.TextData node = (DataNode.TextData)obj;
                String content = node.get(NodeProps.STR_CONTENT);
                OpenFileAction.showHtmlResult(node.getName(), "", String.format("<pre>%s</pre>", StringEscapeUtils.escapeHtml4(content)));
            } else if (obj instanceof DataNode.MergedData) {
                UnitSystem usys = app.getUnitSystem();
                DataNode.MergedData node = (DataNode.MergedData)obj;
                DataTable rawDataTable = node.getData();
                DataTable xformData = DataTable.convertColUnits(rawDataTable, new DataTable.ColTransform("dP", String.format("dP (%s)", usys.getPressure().toString()), SI.PASCAL, usys.getPressure()), new DataTable.ColTransform("Flow0", String.format("Flow0 (%s)", usys.getDesignFlowRate().toString()), SI.KILO(SI.GRAM).divide(SI.SECOND), usys.getDesignFlowRate()), new DataTable.ColTransform("Flow1", String.format("Flow1 (%s)", usys.getDesignFlowRate().toString()), SI.KILO(SI.GRAM).divide(SI.SECOND), usys.getDesignFlowRate()), new DataTable.ColTransform("Temperature", String.format("Temperature (%s)", usys.getTemperature().toString()), SI.KELVIN, usys.getTemperature()), new DataTable.ColTransform("Pressure", String.format("dP (%s)", usys.getPressure().toString()), SI.PASCAL, usys.getPressure()), new DataTable.ColTransform("Density", "Density (kg/m3)", val -> val));
                String content = xformData.toCsvString();
                OpenFileAction.showHtmlResult(node.getName(), "", String.format("<pre>%s</pre>", content));
            }
        }
    }
}

