/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import thunderheadeng.animate.DefaultFrameSrc;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.animate.IFrameSrc;
import thunderheadeng.animate.InterpInfo;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.feature.comps.IFeatureAnimator;
import ventus.feature.results.DataNode;

public class DataNodeAnimator
implements IFeatureAnimator,
IEventObserver,
IAnimator {
    private IFrameSrc<DataNodeFrame> d_frameSrc = new DefaultFrameSrc<DataNodeFrame>();
    private final Set<DataNode.VisLeaf> d_dataLeaves = new LinkedIdentityHashSet<DataNode.VisLeaf>();

    @Override
    public void update(Events events) {
        IEventRecord<DataNode.VisLeaf> leafRecords = events.getEvents(DataNode.VisLeaf.class, new Class[0]);
        if (leafRecords.hasAddedObjs()) {
            Collection<DataNode.VisLeaf> visLeaves = ((DataNode.ResultsRoot)VentusApp.getAppData().getComponentData("results.data")).flatten(DataNode.VisLeaf.class);
            this.d_dataLeaves.addAll(visLeaves);
            this.d_frameSrc = this.createFrameSrc(visLeaves);
            EventQueue.invokeLater(() -> events.changed(VentusApp.getAppData(), ANIMATION_CHANGED));
        }
        if (events.getEvents(DataNode.VisLeaf.class, new Class[0]).hasRemovedObjs()) {
            this.d_dataLeaves.removeAll(leafRecords.getRemovedObjs());
            EventQueue.invokeLater(() -> events.changed(VentusApp.getAppData(), ANIMATION_CHANGED));
        }
    }

    private IFrameSrc<DataNodeFrame> createFrameSrc(Collection<DataNode.VisLeaf> leaves) {
        DefaultFrameSrc<DataNodeFrame> frameSrc = new DefaultFrameSrc<DataNodeFrame>();
        for (DataNode.VisLeaf leaf : leaves) {
            int i = 0;
            while (i < leaf.getTimes().length) {
                int currFrame = i++;
                frameSrc.computeFrame(leaf.getTimes()[currFrame], (time, oldFrame) -> {
                    DataNodeFrame frame = oldFrame == null ? new DataNodeFrame() : oldFrame;
                    frame.add(leaf, new Pair<Double, Double>(leaf.getDifferentialPressures()[currFrame], leaf.getPrimaryFlows()[currFrame]));
                    return frame;
                });
            }
        }
        return frameSrc;
    }

    @Override
    public boolean update(IAnimSession session) {
        VentusApp.getAppData().pauseUpdates();
        double time = session.get(IAnimSession.TIME);
        InterpInfo<DataNodeFrame> ii = this.d_frameSrc.getFrames(time);
        for (DataNode.VisLeaf leaf : this.d_dataLeaves) {
            Pair<Double, Double> frame1Data = ii.frame1().getData(leaf);
            Pair<Double, Double> frame2Data = ii.frame2().getData(leaf);
            leaf.setAnimationData((Double)frame1Data.v1, theUtil.lerp((Double)frame1Data.v1, (Double)frame2Data.v1, ii.interpT()), (Double)frame1Data.v2, theUtil.lerp((Double)frame1Data.v2, (Double)frame2Data.v2, ii.interpT()));
        }
        VentusApp.getAppData().resumeUpdates();
        return true;
    }

    @Override
    public Pair<Double, Double> getTimeRange() {
        if (this.d_dataLeaves.isEmpty()) {
            return new Pair<Double, Double>(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        return this.d_frameSrc.getTimeRange();
    }

    private static class DataNodeFrame {
        private final Map<DataNode.VisLeaf, Pair<Double, Double>> d_vals = new IdentityHashMap<DataNode.VisLeaf, Pair<Double, Double>>();

        private DataNodeFrame() {
        }

        public Pair<Double, Double> getData(DataNode.VisLeaf leaf) {
            return this.d_vals.get(leaf);
        }

        public void add(DataNode.VisLeaf leaf, Pair<Double, Double> val) {
            this.d_vals.put(leaf, val);
        }
    }
}

