/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.props;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.PropertyValues;

public final class PropertyDefs<ObjT extends IMerlinObj>
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(PropertyDefs.class.getSimpleName());
    private static final List<Attribute<?>> ALL_ATTRS = new ArrayList();
    private static final AttributeDefs ATTRIBUTES_DEFS = new AttributeDefs();
    private IStorage<? super ObjT> d_storage;
    private Map<TypedProp<?>, PropAttributes<? super ObjT, ?, ? extends TypedProp<?>>> d_props = new LinkedIdentityHashMap();
    private Map<Class, DefaultAttributes<?>> d_defaultAttrs = new HashMap();
    private Map<TypedProp<?>, List<TypedProp<?>>> d_linkedProps = new IdentityHashMap();

    public static <ObjT extends IMerlinObj> IStorage<ObjT> serializedOnly(Function<? super ObjT, IPropertySet> getSerializedValues, Consumer<? super ObjT> initStorage) {
        return new Storage<ObjT>(getSerializedValues, obj -> null, initStorage);
    }

    public static <ObjT extends IMerlinObj> IStorage<ObjT> transientOnly(Function<? super ObjT, IPropertySet> getTransientValues, Consumer<? super ObjT> initStorage) {
        return new Storage<ObjT>(obj -> null, getTransientValues, initStorage);
    }

    public static <ObjT extends IMerlinObj> IStorage<ObjT> storage(Function<ObjT, PropertyValues> getValues, BiConsumer<ObjT, PropertyValues> setValues) {
        return PropertyValues.storage(getValues, setValues);
    }

    public static <ObjT extends IMerlinObj> IStorage<ObjT> none() {
        return PropertyDefs.legacy(null);
    }

    public static <ObjT extends IMerlinObj> IStorage<ObjT> legacy(Consumer<? super ObjT> initLegacyValues) {
        return new Storage<ObjT>(obj -> null, obj -> null, initLegacyValues != null ? initLegacyValues : obj -> {});
    }

    public PropertyDefs(IStorage<? super ObjT> storage) {
        this.d_storage = storage;
    }

    public PropertyDefs(PropertyDefs<? super ObjT> inherited, Consumer<ObjT> initLocalStorage) {
        this(initLocalStorage != null ? PropertyDefs.combineStorage(Stream.of(inherited.getStorage(), PropertyDefs.legacy(initLocalStorage))) : inherited.getStorage());
        this.copyFrom(inherited);
    }

    public PropertyDefs(IStorage<? super ObjT> storage, PropertyDefs<? super ObjT> ... inherited) {
        this(PropertyDefs.combineStorage(Stream.concat(Stream.of(storage), Stream.of(inherited).map(defs -> defs.getStorage()))));
        Stream.of(inherited).forEach(this::copyFrom);
    }

    private static <ObjT extends IMerlinObj> IStorage<? super ObjT> combineStorage(Stream<IStorage<? super ObjT>> storages) {
        return storages.reduce(CompositeStorage::new).orElse(PropertyDefs.legacy(null));
    }

    public PropertyDefs<ObjT> copyFrom(PropertyDefs<? super ObjT> props) {
        for (Map.Entry<TypedProp<?>, PropAttributes<ObjT, ?, TypedProp<?>>> entry : props.d_props.entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public IStorage<? super ObjT> getStorage() {
        return this.d_storage;
    }

    public PropertyDefs<ObjT> clone() {
        try {
            PropertyDefs clone = (PropertyDefs)super.clone();
            clone.d_props = new LinkedIdentityHashMap(this.d_props);
            clone.d_defaultAttrs = new HashMap(this.d_defaultAttrs);
            clone.d_defaultAttrs.replaceAll((type, defAttrs) -> defAttrs.clone());
            clone.d_linkedProps = new IdentityHashMap(this.d_linkedProps);
            clone.d_linkedProps.replaceAll((prop, linked) -> new ArrayList(linked));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return this;
        }
    }

    public <T, PropT extends TypedProp<T>> PropT copyFrom(PropertyDefs<? super ObjT> props, PropT prop) {
        return this.copyFrom(props, prop, true);
    }

    private <T, PropT extends TypedProp<T>> PropT copyFrom(PropertyDefs<? super ObjT> props, PropT prop, boolean overwriteIfExists) {
        if (!overwriteIfExists && this.d_props.containsKey(prop)) {
            return prop;
        }
        PropAttributes<ObjT, ?, TypedProp<?>> info = props.d_props.get(prop);
        assert (info != null) : String.format("Trying to copy attributes for property, %s, from another set that doesn't define the property", prop.key);
        if (info == null) {
            throw new IllegalArgumentException();
        }
        for (TypedProp linkedProp : (Set)info.get(a -> a.linkedProps)) {
            this.copyFrom(props, linkedProp, false);
        }
        this.addProperty(prop, info);
        return prop;
    }

    private <ValT, PropT extends TypedProp<ValT>> void addProperty(PropT prop, PropAttributes<? super ObjT, ValT, PropT> attrs) {
        this.d_props.put(prop, attrs);
        this.linkProperties(prop, prop);
    }

    private void linkProperties(TypedProp<?> target, TypedProp<?> prop) {
        PropAttributes<ObjT, ?, TypedProp<?>> attrs = this.d_props.get(prop);
        if (attrs == null) {
            return;
        }
        for (TypedProp linkedProp : (Set)attrs.get(a -> a.linkedProps)) {
            this.d_linkedProps.computeIfAbsent(linkedProp, p -> new ArrayList()).add(target);
        }
    }

    public <T, PropT extends TypedProp<T>> AttributeBuilder<T, PropT> storeAsPlainOldData(PropT prop) {
        return this.newProp(prop);
    }

    public <T, PropT extends TypedProp<T>> AttributeBuilder<T, PropT> storeAsTopology(PropT prop) {
        return this.newProp(prop).attrMarkAsTopology();
    }

    public <T, PropT extends TypedProp<T>> AttributeBuilder<T, PropT> storeAsWrapper(PropT prop) {
        return this.newProp(prop).attrMarkAsWrapper();
    }

    public <T, PropT extends TypedProp<T>> AttributeBuilder<T, PropT> storeAsReadOnly(PropT prop) {
        return this.newProp(prop).attrMarkReadOnly();
    }

    public <T> boolean has(TypedProp<T> key) {
        return this.d_props.containsKey(key);
    }

    public <T, PropT extends TypedProp<T>> void insertUndoEntry_propRestore(VentusData vd, ObjT src, PropT prop) {
        PropAttributes<ObjT, ?, TypedProp<?>> info = this.d_props.get(prop);
        if (info != null) {
            ((IRestoreProp)info.get(defs -> defs.restoreProp)).insertUndoEntry(vd, src, prop);
        } else {
            Undo.insertUndoEntry_propRestore(vd, src, prop);
        }
    }

    public <T, PropT extends TypedProp<T>> PropT get(PropT key) {
        if (!this.has(key)) {
            return null;
        }
        return key;
    }

    public Set<TypedProp<?>> props() {
        return this.d_props.keySet();
    }

    public <T, PropT extends TypedProp<T>> boolean setValue(ObjT obj, PropT prop, T value) {
        PropAttributes<ObjT, ?, TypedProp<?>> info = this.d_props.get(prop);
        if (info == null) {
            return false;
        }
        if (info.test(Options.SKIP_SET)) {
            LOGGER.log(Level.WARNING, "Trying to set a read-only value: " + prop.key.toString());
            return false;
        }
        TriConsumer setter = (TriConsumer)info.get(a -> a.setter);
        if (setter != null) {
            setter.accept(prop, obj, value);
            return true;
        }
        IPropertySet props = this.getValues(info, obj);
        if (props == null) {
            return false;
        }
        this.compareAndSet(obj, props, prop, info, value);
        return true;
    }

    private <T, PropT extends TypedProp<T>> IPropertySet getValues(PropAttributes<ObjT, T, PropT> info, ObjT obj) {
        return this.d_storage.getValues(!info.isTransient(), obj);
    }

    public <T, PropT extends TypedProp<T>> PropValue<T> getValue(ObjT obj, PropT prop) {
        PropAttributes<ObjT, ?, TypedProp<?>> info = this.d_props.get(prop);
        if (info == null) {
            return PropValue.unsupported();
        }
        BiFunction getter = (BiFunction)info.get(a -> a.getter);
        if (getter != null) {
            return PropValue.of(getter.apply(prop, obj));
        }
        IPropertySet props = this.getValues(info, obj);
        if (props == null) {
            return PropValue.unsupported();
        }
        return PropValue.of(props.get(prop));
    }

    public void forEach(Consumer<? super TypedProp<?>> consumer) {
        this.d_props.keySet().forEach(consumer);
    }

    private <ValT, PropT extends TypedProp<ValT>> boolean compareAndSet(ObjT obj, IPropertySet props, PropT prop, PropAttributes<ObjT, ValT, PropT> attrs, ValT value) {
        Object existing = props.get(prop);
        if (!Objects.equals(existing, value)) {
            props.setIfNotDefault(prop, value);
            ((BiConsumer)attrs.get(a -> a.fireEvents)).accept(prop, obj);
            return true;
        }
        return false;
    }

    public void changedEvt(ObjT src, Object[] changes) {
        src.pauseUpdates();
        for (Object change : changes) {
            TypedProp prop;
            List<TypedProp<?>> linkedProps;
            if (!(change instanceof TypedProp) || (linkedProps = this.d_linkedProps.get(prop = (TypedProp)change)) == null) continue;
            for (TypedProp<?> linkedProp : linkedProps) {
                PropAttributes<ObjT, ?, TypedProp<?>> attrs = this.d_props.get(linkedProp);
                assert (attrs != null);
                if (attrs == null) continue;
                BiConsumer fireEvts = (BiConsumer)attrs.get(a -> a.fireEvents);
                fireEvts.accept(linkedProp, src);
            }
        }
        src.resumeUpdates();
    }

    public <T, PropT extends TypedProp<T>> boolean compareAndSetDirect(ObjT obj, PropT prop, T value) {
        PropAttributes<? super ObjT, ?, ? extends TypedProp<?>> info = this.d_props.get(prop);
        if (info == null) {
            return false;
        }
        IPropertySet props = this.getValues(info, obj);
        assert (props != null);
        return this.compareAndSet(obj, props, prop, info, value);
    }

    public void restoreFrom(ObjT from, ObjT to) {
        to.pauseUpdates();
        this.d_props.entrySet().stream().filter(e -> !((PropAttributes)e.getValue()).testAny(Options.SKIP_RESTORE, Options.SKIP_SET)).map(e -> (TypedProp)e.getKey()).forEach((? super T e) -> {
            PropValue newVal = this.getValue(from, e);
            assert (newVal.isUniform());
            this.setValue(to, e, newVal.get());
        });
        to.resumeUpdates();
    }

    public void takeDepSnapshot(ObjT obj, DepList<VentusData> deps) {
        this.d_props.entrySet().stream().filter(e -> ((PropAttributes)e.getValue()).get(a -> a.depCallback) != null).forEach((? super T e) -> {
            PropValue val = this.getValue(obj, (TypedProp)e.getKey());
            if (val.isUniform() && val.get() != null) {
                Object v = val.get();
                PropAttributes info = (PropAttributes)e.getValue();
                deps.add(obj, v, (DepCallback)info.get(a -> a.depCallback));
            }
        });
    }

    public boolean surrogateEquals(ObjT obj1, ObjT obj2, HashSet<UnorderedPair<Object, Object>> comparedList) {
        for (Map.Entry<TypedProp<?>, PropAttributes<ObjT, ?, TypedProp<?>>> entry : this.d_props.entrySet()) {
            TypedProp<?> prop = entry.getKey();
            PropAttributes<ObjT, ?, TypedProp<?>> attrs = entry.getValue();
            ISurrogateEquals surrogateEq = (ISurrogateEquals)attrs.get(a -> a.surrogateEquals);
            if (surrogateEq == null) continue;
            PropValue val1 = this.getValue(obj1, prop);
            assert (val1.isUniform());
            PropValue val2 = this.getValue(obj2, prop);
            assert (val2.isUniform());
            if (surrogateEq.test(obj1, val1.get(), obj2, val2.get(), comparedList)) continue;
            return false;
        }
        return true;
    }

    public void delayWriteObj(ObjectOutputStream out, ObjT src) throws IOException {
        PropertySet toSerialize = new PropertySet();
        this.d_props.entrySet().stream().filter(entry -> ((PropAttributes)entry.getValue()).get(a -> a.serialize) == Serialize.DELAY).forEach((? super T entry) -> {
            PropValue val = this.getValue(src, (TypedProp)entry.getKey());
            assert (val.isUniform());
            toSerialize.set((TypedProp)entry.getKey(), val.get());
        });
        if (toSerialize.isEmpty()) {
            out.writeObject(null);
        } else {
            out.writeObject(toSerialize);
        }
    }

    public void delayReadObj(ObjectInputStream in, ObjT src) throws ClassNotFoundException, IOException {
        PropertySet stored = (PropertySet)in.readObject();
        if (stored == null) {
            return;
        }
        this.d_props.entrySet().stream().filter(entry -> ((PropAttributes)entry.getValue()).get(a -> a.serialize) == Serialize.DELAY).forEach((? super T entry) -> {
            Object val = stored.get((IPropertySet.Prop)entry.getKey());
            this.setValue(src, (TypedProp)entry.getKey(), val);
        });
    }

    public static <ObjT, T> boolean defaultSurrogateEquals(ObjT obj1, T v1, ObjT obj2, T v2, HashSet<UnorderedPair<Object, Object>> comparedList) {
        if (v1 instanceof Set) {
            Set set1 = (Set)v1;
            if (v2 instanceof Set) {
                Set set2 = (Set)v2;
                return comparedList == null ? theUtil.surrogateSetsEqual(set1, set2) : theUtil.surrogateSetsEqual(set1, set2, comparedList);
            }
        }
        if (v1 instanceof Map) {
            Map map1 = (Map)v1;
            if (v2 instanceof Map) {
                Map map2 = (Map)v2;
                return comparedList == null ? theUtil.surrogateMapsEqual(map1, map2, false) : theUtil.surrogateMapsEqual(map1, map2, comparedList, false);
            }
        }
        if (v1 instanceof List) {
            List l1 = (List)v1;
            if (v2 instanceof List) {
                List l2 = (List)v2;
                return comparedList == null ? theUtil.surrogateListsEqual(l1, l2) : theUtil.surrogateListsEqual(l1, l2, comparedList);
            }
        }
        return comparedList == null ? theUtil.equal(v1, v2) : theUtil.equal(v1, v2, comparedList);
    }

    public ObjT cloneValues(ObjT srcObj, ObjT clonedObj) {
        this.d_storage.initStorage(clonedObj);
        for (Map.Entry<TypedProp<?>, PropAttributes<ObjT, ?, TypedProp<?>>> entry : this.d_props.entrySet()) {
            ICloneValue cloneValue;
            PropAttributes<ObjT, ?, TypedProp<?>> attrs = entry.getValue();
            if (attrs.testAny(Options.SKIP_SET) || (cloneValue = (ICloneValue)attrs.get(a -> a.cloneValue)) == null) continue;
            PropValue val = this.getValue(srcObj, entry.getKey());
            assert (val.isUniform());
            Object clonedVal = cloneValue.clone(srcObj, val.get());
            this.setValue(clonedObj, entry.getKey(), clonedVal);
        }
        return clonedObj;
    }

    public ObjT getRestoreObj(ObjT srcObj, ObjT restoreObj) {
        this.d_storage.initStorage(restoreObj);
        for (Map.Entry<TypedProp<?>, PropAttributes<ObjT, ?, TypedProp<?>>> entry : this.d_props.entrySet()) {
            ICloneValue getRestoreValue;
            PropAttributes<ObjT, ?, TypedProp<?>> attrs = entry.getValue();
            if (attrs.testAny(Options.SKIP_SET) || (getRestoreValue = (ICloneValue)attrs.get(a -> a.getRestoreValue)) == null) continue;
            PropValue val = this.getValue(srcObj, entry.getKey());
            assert (val.isUniform());
            Object restoreVal = getRestoreValue.clone(srcObj, val.get());
            this.setValue(restoreObj, entry.getKey(), restoreVal);
        }
        return restoreObj;
    }

    public <ValT> PropertyDefs<ObjT> attrDefaults(Class<ValT> valType, Consumer<? super DefaultAttributes<ValT>> modify) {
        DefaultAttributes defaults = this.d_defaultAttrs.computeIfAbsent(valType, type -> new DefaultAttributes(this, type));
        modify.accept(defaults);
        return this;
    }

    public <T, PropT extends TypedProp<T>> AttributeBuilder<T, PropT> newProp(PropT prop) {
        PropertySet defAttrs = new PropertySet();
        theUtil.findObjectsForClass2(this.d_defaultAttrs, prop.type, defs -> defs.collectDefined(prop.type, defAttrs));
        return new AttributeBuilder(this, prop, defAttrs);
    }

    public record Storage<ObjT extends IMerlinObj>(Function<? super ObjT, IPropertySet> getSerializedValues, Function<? super ObjT, IPropertySet> getTransientValues, Consumer<? super ObjT> initStorage) implements IStorage<ObjT>
    {
        public Storage {
            Objects.requireNonNull(getSerializedValues);
            Objects.requireNonNull(getTransientValues);
            Objects.requireNonNull(initStorage);
        }

        @Override
        public IPropertySet getSerializedValues(ObjT obj) {
            return this.getSerializedValues.apply(obj);
        }

        @Override
        public IPropertySet getTransientValues(ObjT obj) {
            return this.getTransientValues.apply(obj);
        }

        @Override
        public void initStorage(ObjT obj) {
            this.initStorage.accept(obj);
        }
    }

    public static interface IStorage<ObjT extends IMerlinObj> {
        public void initStorage(ObjT var1);

        public IPropertySet getSerializedValues(ObjT var1);

        public IPropertySet getTransientValues(ObjT var1);

        default public <T, PropT extends TypedProp<T>> IPropertySet getValues(boolean serialized, ObjT obj) {
            return serialized ? this.getSerializedValues(obj) : this.getTransientValues(obj);
        }
    }

    private static class PropAttributes<ObjT extends IMerlinObj, ValT, PropT extends TypedProp<ValT>> {
        protected final PropertySet attrs;

        public PropAttributes(PropertySet attrs) {
            this.attrs = attrs;
        }

        public AttributeDefs<ObjT, ValT, PropT> defined() {
            return ATTRIBUTES_DEFS;
        }

        public boolean test(Options option) {
            return this.attrs.get(this.defined().options).contains((Object)option);
        }

        public boolean testAny(Options ... options) {
            EnumSet<Options> opts = this.attrs.get(this.defined().options);
            return Stream.of(options).anyMatch(o -> opts.contains(o));
        }

        public <T> T get(Function<? super AttributeDefs<ObjT, ValT, PropT>, Attribute<T>> getAttr) {
            return this.get(getAttr.apply(this.defined()));
        }

        public <T> T get(Attribute<T> attr) {
            return this.attrs.get(attr);
        }

        public boolean isTransient() {
            return this.attrs.get(this.defined().serialize).isTransient;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            AttributeDefs<ObjT, ValT, PropT> dattrs = this.defined();
            if (this.attrs.get(dattrs.getter) != null) {
                sb.append("getter");
            }
            if (this.attrs.get(dattrs.setter) != null) {
                if (sb.length() != 0) {
                    sb.append("\\");
                }
                sb.append("setter");
            }
            if (sb.length() == 0) {
                return "none";
            }
            return sb.toString();
        }
    }

    public static class AttributeBuilder<ValT, PropT extends TypedProp<ValT>>
    implements Cloneable {
        protected final PropT prop;
        protected PropertySet attrs;
        final /* synthetic */ PropertyDefs this$0;

        public AttributeBuilder(PropT prop) {
            this(this$0, (TypedProp)prop, new PropertySet());
        }

        protected AttributeBuilder(PropT prop, PropertySet attrs) {
            this.this$0 = this$0;
            this.prop = prop;
            this.attrs = attrs;
        }

        protected AttributeBuilder<ValT, PropT> clone() {
            try {
                AttributeBuilder result = (AttributeBuilder)super.clone();
                result.attrs = this.attrs.clone();
                return result;
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        private AttributeDefs<ObjT, ValT, PropT> defined() {
            return ATTRIBUTES_DEFS;
        }

        public AttributeBuilder<ValT, PropT> attrSetter(TriConsumer<PropT, ObjT, ? super ValT> setter) {
            this.attrs.set(this.defined().setter, setter);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrSetter(BiConsumer<ObjT, ? super ValT> setter) {
            return this.attrSetter((PropT prop, ObjT obj, ? super ValT val) -> setter.accept((Object)obj, (Object)val));
        }

        public AttributeBuilder<ValT, PropT> attrGetter(BiFunction<PropT, ObjT, ValT> getter, TypedProp<?> affectingProp, TypedProp<?> ... additionalAffectingProps) {
            this.attrs.set(this.defined().getter, getter);
            if (affectingProp != null || additionalAffectingProps.length > 0) {
                Set<TypedProp<?>> linkedProps = this.attrs.get(this.defined().linkedProps);
                if (linkedProps.isEmpty()) {
                    linkedProps = new LinkedIdentityHashSet();
                    this.attrs.set(this.defined().linkedProps, linkedProps);
                }
                if (affectingProp != null) {
                    linkedProps.add(affectingProp);
                }
                linkedProps.addAll(Arrays.asList(additionalAffectingProps));
            }
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrGetter(Function<ObjT, ValT> getter, TypedProp<?> affectingProp, TypedProp<?> ... additionalAffectingProps) {
            return this.attrGetter((PropT prop, ObjT obj) -> getter.apply(obj), affectingProp, additionalAffectingProps);
        }

        protected AttributeBuilder<ValT, PropT> attrOptions(Options ... options) {
            this.attrs.set(this.defined().options, theUtil.toEnumSet(Options.class, (Enum[])options));
            return this;
        }

        protected AttributeBuilder<ValT, PropT> attrAddOptions(Options ... options) {
            EnumSet<Options> opts = EnumSet.copyOf(this.attrs.get(this.defined().options));
            opts.addAll(theUtil.toEnumSet(Options.class, (Enum[])options));
            this.attrs.set(this.defined().options, opts);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrUndoPropRestore(IRestoreProp<ObjT, ValT, PropT> restore) {
            this.attrs.set(this.defined().restoreProp, restore);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrUndoPropRestore(TypedProp<?> ... props) {
            this.attrUndoPropRestore((VentusData md, ObjT obj, PropT thisProp) -> Stream.of(props).forEach(p -> Undo.insertUndoEntry_propRestore(md, obj, p)));
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrSerialize(Serialize mode) {
            this.attrs.set(this.defined().serialize, mode);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrMarkReadOnly() {
            this.attrAddOptions(Options.SKIP_RESTORE, Options.SKIP_SET);
            this.attrCloneAndRestoreValue(null);
            this.attrSurrogateEquals(null);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrMarkAsTopology() {
            this.attrAddOptions(Options.SKIP_RESTORE);
            this.attrCloneAndRestoreValue(null);
            this.attrSerialize(Serialize.DELAY);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrMarkAsWrapper() {
            this.attrAddOptions(Options.SKIP_RESTORE);
            this.attrCloneAndRestoreValue(null);
            this.attrSurrogateEquals(null);
            this.attrUndoPropRestore((VentusData md, ObjT obj, PropT prop) -> Undo.insertUndoEntry_restore(md, obj));
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrMarkTransient() {
            this.attrSerialize(Serialize.NEVER);
            return this;
        }

        public <RefT> AttributeBuilder<ValT, PropT> attrDependency(Function<TypedProp<ValT>, DepCallback<VentusData, ObjT, ValT, ? extends RefT>> getCallback) {
            this.attrs.set(this.defined().depCallback, getCallback.apply((TypedProp<ValT>)this.prop));
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrSurrogateEquals(ISurrogateEquals<ObjT, ? super ValT> equals) {
            this.attrs.set(this.defined().surrogateEquals, equals);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrCloneValue(ICloneValue<ObjT, ValT> clone) {
            this.attrs.set(this.defined().cloneValue, clone);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrRestoreValue(ICloneValue<ObjT, ValT> getRestoreVal) {
            this.attrs.set(this.defined().getRestoreValue, getRestoreVal);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrCloneAndRestoreValue(ICloneValue<ObjT, ValT> function) {
            this.attrCloneValue(function);
            this.attrRestoreValue(function);
            return this;
        }

        public AttributeBuilder<ValT, PropT> attrFireEvents(BiConsumer<PropT, ObjT> fireEvents) {
            this.attrs.set(this.defined().fireEvents, fireEvents);
            return this;
        }

        public PropT attrFinish() {
            AttributeDefs dattrs = this.defined();
            if (this.attrs.get(dattrs.getter) == null && this.attrs.get(dattrs.setter) == null && IMerlinObj.class.isAssignableFrom(((TypedProp)this.prop).type) && this.attrs.get(dattrs.depCallback) == null) {
                LOGGER.log(Level.WARNING, () -> String.format("High-level object property added to %s without specifying a dependency. If this isn't a topological property, double-check that you aren't missing a call to attrDependency. Property: id=%s, type=%s", this.this$0.getClass().getSimpleName(), ((TypedProp)this.prop).key, ((TypedProp)this.prop).type.getSimpleName()));
            }
            this.this$0.addProperty(this.prop, new PropAttributes(this.attrs));
            return this.prop;
        }
    }

    public static interface IRestoreProp<ObjT extends IMerlinObj, ValT, PropT extends TypedProp<ValT>> {
        public void insertUndoEntry(VentusData var1, ObjT var2, PropT var3);
    }

    private static enum Options {
        SKIP_RESTORE,
        SKIP_SET;

    }

    public static interface ISurrogateEquals<ObjT, T> {
        public boolean test(ObjT var1, T var2, ObjT var3, T var4, HashSet<UnorderedPair<Object, Object>> var5);
    }

    public static interface ICloneValue<ObjT, T> {
        public T clone(ObjT var1, T var2);
    }

    public class DefaultAttributes<ValT>
    extends AttributeBuilder<ValT, TypedProp<ValT>> {
        public DefaultAttributes(PropertyDefs this$0, Class<ValT> type) {
            super(this$0, new TypedProp<ValT>("", type, Set.of()));
        }

        @Override
        protected DefaultAttributes<ValT> clone() {
            return (DefaultAttributes)super.clone();
        }

        @Override
        @Deprecated
        public TypedProp<ValT> attrFinish() {
            return null;
        }

        @Override
        public AttributeBuilder<ValT, TypedProp<ValT>> attrGetter(BiFunction<TypedProp<ValT>, ObjT, ValT> getter, TypedProp<?> affectingProp, TypedProp<?> ... additionalAffectingProps) {
            return super.attrGetter(getter, affectingProp, additionalAffectingProps);
        }

        @Override
        public AttributeBuilder<ValT, TypedProp<ValT>> attrGetter(Function<ObjT, ValT> getter, TypedProp<?> affectingProp, TypedProp<?> ... additionalAffectingProps) {
            return super.attrGetter(getter, affectingProp, additionalAffectingProps);
        }

        @Override
        public AttributeBuilder<ValT, TypedProp<ValT>> attrCloneValue(ICloneValue<ObjT, ValT> clone) {
            return super.attrCloneValue(clone);
        }

        protected <DestValT> void collectDefined(Class<DestValT> destValType, PropertySet dest) {
            boolean isValTypeMatch = destValType.equals(this.prop.type);
            for (Attribute<?> prop : ALL_ATTRS) {
                if (!isValTypeMatch && prop.requiresExactValMatch || !this.attrs.isDefined(prop) || dest.isDefined(prop)) continue;
                dest.set(prop, this.attrs.get(prop));
            }
        }
    }

    private static class AttributeDefs<ObjT extends IMerlinObj, ValT, PropT extends TypedProp<ValT>> {
        protected final Attribute<TriConsumer<PropT, ObjT, ? super ValT>> setter = new Attribute<Object>("setter", null, false);
        protected final Attribute<BiFunction<PropT, ObjT, ValT>> getter = new Attribute<Object>("getter", null, true);
        protected final Attribute<EnumSet<Options>> options = new Attribute<EnumSet<Options>>("options", EnumSet.noneOf(Options.class), false);
        protected final Attribute<DepCallback<VentusData, ObjT, ?, ?>> depCallback = new Attribute<Object>("depCallback", null, false);
        protected final Attribute<ISurrogateEquals<ObjT, ? super ValT>> surrogateEquals = new Attribute<ISurrogateEquals<IMerlinObj, Object>>("surrogateEquals", PropertyDefs::defaultSurrogateEquals, false);
        protected final Attribute<ICloneValue<ObjT, ValT>> cloneValue = new Attribute<ICloneValue<IMerlinObj, Object>>("cloneValue", (o, v) -> v, true);
        protected final Attribute<ICloneValue<ObjT, ValT>> getRestoreValue = new Attribute<ICloneValue<IMerlinObj, Object>>("getRestoreValue", (o, v) -> v, true);
        protected final Attribute<Serialize> serialize = new Attribute<Serialize>("serialize", Serialize.ALWAYS, false);
        protected final Attribute<BiConsumer<PropT, ObjT>> fireEvents = new Attribute<BiConsumer<TypedProp, IMerlinObj>>("fireEvents", (p, o) -> o.changedEvt(p), false);
        protected final Attribute<Set<TypedProp<?>>> linkedProps = new Attribute("linkedProps", Collections.emptySet(), false);
        protected final Attribute<IRestoreProp<ObjT, ValT, PropT>> restoreProp = new Attribute("restoreProp", (vd, obj, prop) -> Undo.insertUndoEntry_propRestore(vd, obj, prop), false);

        private AttributeDefs() {
        }
    }

    private static class Attribute<ValT>
    extends IPropertySet.Prop<ValT> {
        protected final boolean requiresExactValMatch;

        protected Attribute(Object key, ValT defVal, boolean requiresExactValMatch) {
            super(key, defVal);
            this.requiresExactValMatch = requiresExactValMatch;
            ALL_ATTRS.add(this);
        }
    }

    public static enum Serialize {
        ALWAYS(false),
        NEVER(true),
        DELAY(true);

        private final boolean isTransient;

        private Serialize(boolean isTransient) {
            this.isTransient = isTransient;
        }
    }

    private static class CompositeStorage<ObjT extends IMerlinObj>
    implements IStorage<ObjT> {
        public final IStorage<? super ObjT> primary;
        public final IStorage<? super ObjT> second;

        public CompositeStorage(IStorage<? super ObjT> primary, IStorage<? super ObjT> secondary) {
            this.primary = primary;
            this.second = secondary;
        }

        @Override
        public IPropertySet getSerializedValues(ObjT obj) {
            return this.primary.getSerializedValues(obj);
        }

        @Override
        public IPropertySet getTransientValues(ObjT obj) {
            return this.primary.getTransientValues(obj);
        }

        @Override
        public void initStorage(ObjT obj) {
            this.primary.initStorage(obj);
            this.second.initStorage(obj);
        }
    }
}

