/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.plot;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import thunderheadeng.util.Pair;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.plot.Plot2dDlg;
import ventus.feature.plot.PlotModeDesc;
import ventus.feature.results.DataNode;

public class ShowTimeHistoryPlotOp
extends AMerlinOp {
    private final PlotModeDesc d_mode;
    private final boolean d_context;

    ShowTimeHistoryPlotOp(PlotModeDesc mode, boolean context) {
        this.d_mode = mode;
        this.d_context = context;
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        if (this.d_context) {
            Set selectedObjs = vd.selection.getDeepSelected(SchematicRoom.class, FlowPath.class, DataNode.ZoneVisLeaf.class, DataNode.VisLeaf.class);
            Collection<DataNode.SimulationRoot> roots = ((DataNode.ResultsRoot)vd.getComponentData("results.data")).flatten(DataNode.SimulationRoot.class);
            Set<Pair<DataNode.SimulationRoot, IMerlinObj>> product = selectedObjs.stream().flatMap(obj -> roots.stream().map(root -> new Pair<DataNode.SimulationRoot, IMerlinObj>((DataNode.SimulationRoot)root, (IMerlinObj)obj))).collect(Collectors.toSet());
            ShowTimeHistoryPlotOp.showPlot(app, vd, this.d_mode, product);
        } else {
            ShowTimeHistoryPlotOp.showPlot(app, vd, this.d_mode, Set.of());
        }
    }

    public static void showPlot(VentusApp app, VentusData vd, PlotModeDesc mode, Set<Pair<DataNode.SimulationRoot, IMerlinObj>> selected) {
        JFrame mainFrame = app.getMainFrame();
        Plot2dDlg dlg = new Plot2dDlg(vd);
        app.addFrame(dlg);
        dlg.setSize(mainFrame.getWidth() * 2 / 3, mainFrame.getHeight() * 2 / 3);
        dlg.setLocationRelativeTo(app.getMainFrame());
        dlg.open(mode, selected);
    }
}

