/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathBuilder;
import ventus.feature.windprofiles.WindProfile;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;

public class NewFlowPathPanel
extends APropEditPanel<FlowPathBuilder> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_name;
    private final ColorButton d_color;
    private final guiComboBox<FlowElement> d_flowElement;
    private final guiComboBox<WindProfile> d_windProfile;
    private final MerlinUDF d_startLocationX;
    private final MerlinUDF d_startLocationY;
    private final MerlinUDF d_startLocationZ;
    private final MerlinUDF d_endLocationX;
    private final MerlinUDF d_endLocationY;
    private final MerlinUDF d_endLocationZ;
    private final MerlinUDF d_elevation;
    private final MerlinUDF d_windPressure;
    private final MerlinUDF d_azimuth;
    private final HTMLBtn d_startZone;
    private final HTMLBtn d_direction;
    private final HTMLBtn d_endZone;
    private final guiDoubleField d_multiplier;
    private final guiRadioButton d_constantWindPressure;
    private final guiRadioButton d_variableWindPressure;
    private final guiCheckBox d_overwriteColor;
    private final FlowPathBuilder.Mode d_mode;
    private final ArrayList<guiPanel> d_sections = new ArrayList();
    private static final String RIGHT_ARROW = "&rarr;";
    private static final String LEFT_ARROW = "&larr;";

    public NewFlowPathPanel(VentusData vd, FlowPathBuilder.Mode mode) {
        super(FlowPath.NAME, FlowPath.FLOW_ELEMENT, FlowPath.OVERWRITE_COLOR, FlowPath.COLOR, FlowPath.OVERWRITE_MULTIPLIER, FlowPath.CONSTANT_WIND_PRESSURE, FlowPath.WIND_PRESSURE, FlowPath.WIND_PROFILE, FlowPath.AZIMUTH, FlowPath.START_ZONE, FlowPath.END_ZONE, FlowPath.DIRECTION, FlowPath.START_LOCATION, FlowPath.END_LOCATION, FlowPath.TAGS, FlowPathBuilder.OVERWRITE_ELEVATION, FlowPathBuilder.RELATIVE_ELEVATION);
        this.d_mode = mode;
        this.d_name = this.initValueField(new guiTextField(), new IPropEditCommand[0]);
        this.d_color = guiUtil.newColorButton();
        this.d_color.addObserver((o, arg) -> ((FlowPathBuilder)this.props()).set(FlowPath.COLOR, this.d_color.getColor()));
        this.d_flowElement = this.initComboBox(new MerlinComboBox(vd, FlowElement.class, (IMerlinObj[])new FlowElement[0]));
        this.d_windProfile = this.initComboBox(new MerlinComboBox(vd, WindProfile.class, (IMerlinObj[])new WindProfile[0]));
        this.d_startLocationX = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_startLocationY = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_startLocationZ = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_endLocationX = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_endLocationY = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_endLocationZ = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_elevation = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        this.d_windPressure = this.initValueField(new MerlinUDF(15), new IPropEditCommand[0]);
        this.d_azimuth = this.initValueField(new MerlinUDF(5), new IPropEditCommand[0]);
        this.d_startZone = new HTMLBtn("");
        this.d_direction = new HTMLBtn(RIGHT_ARROW);
        this.d_endZone = new HTMLBtn("");
        this.d_multiplier = this.initValueField(new guiDoubleField(), new IPropEditCommand[0]);
        this.d_constantWindPressure = this.initButton(new guiRadioButton(Intl.intl("Constant:")), new IPropEditCommand[0]);
        this.d_variableWindPressure = this.initButton(new guiRadioButton(Intl.intl("Variable:")), new IPropEditCommand[0]);
        this.d_overwriteColor = this.initButton(new guiCheckBox(Intl.intl("Color:")), new IPropEditCommand[0]);
        this.d_direction.addActionListener(e -> {
            this.formatDirection(!this.parseDirection());
            this.updateToProps((FlowPathBuilder)this.props());
        });
        new guiButtonGroup(this.d_constantWindPressure, this.d_variableWindPressure);
        LinkStatus.link((AbstractButton)this.d_constantWindPressure, this.d_windPressure);
        LinkStatus.link((AbstractButton)this.d_variableWindPressure, this.d_windProfile);
        LinkStatus.link((AbstractButton)this.d_overwriteColor, this.d_color);
        this.d_name.setToolTipText(Intl.intl("Name"));
        this.d_azimuth.setEditable(false);
        this.d_startLocationX.setEditable(false);
        this.d_startLocationY.setEditable(false);
        this.d_startLocationZ.setEditable(false);
        this.d_endLocationX.setEditable(false);
        this.d_endLocationY.setEditable(false);
        this.d_endLocationZ.setEditable(false);
        this.buildEditorPanel();
        this.finalizeSections();
    }

    private void buildEditorPanel() {
        guiPanel sect1 = this.newSection(this.d_sections);
        sect1.add((Component)this.d_name, "width 135px");
        guiPanel sect2 = this.newSection(this.d_sections);
        guiLabel sect2Title = new guiLabel(Intl.intl("Properties"));
        sect2Title.setFont(sect2Title.getFont().deriveFont(1));
        sect2.add((Component)sect2Title, "wrap");
        sect2.add((Component)new guiLabel(Intl.intl("Element:")), "aligny center");
        sect2.add(this.d_flowElement, "wmax 180px, wrap");
        sect2.add((Component)this.d_overwriteColor, "aligny center");
        sect2.add((Component)this.d_color, "width 75px");
        guiPanel sect4 = this.newSection(this.d_sections);
        guiLabel windPressureTitle = new guiLabel(Intl.intl("Wind Pressure"));
        windPressureTitle.setFont(windPressureTitle.getFont().deriveFont(1));
        sect4.add((Component)windPressureTitle, "wrap");
        guiPanel windPressureSect = this.newSection();
        windPressureSect.add(this.d_constantWindPressure);
        windPressureSect.add((Component)this.d_windPressure, "wrap");
        windPressureSect.add(this.d_variableWindPressure);
        windPressureSect.add(this.d_windProfile, "growx");
        sect4.add((Component)windPressureSect, "gapbefore 20px");
        guiPanel sect5 = this.newSection(this.d_sections);
        guiLabel flowDirectionTitle = new guiLabel(Intl.intl("Flow Direction"));
        flowDirectionTitle.setFont(flowDirectionTitle.getFont().deriveFont(1));
        sect5.add((Component)flowDirectionTitle, "wrap");
        guiPanel flowDirectionSect = this.newSection();
        flowDirectionSect.add(new guiLabel(Intl.intl("Azimuth:")));
        flowDirectionSect.add((Component)this.d_azimuth, "wrap");
        flowDirectionSect.add(new guiLabel(Intl.intl("Zones:")));
        guiPanel zonesSect = this.newSection();
        zonesSect.add(this.d_startZone);
        zonesSect.add(this.d_direction);
        zonesSect.add(this.d_endZone);
        flowDirectionSect.add(zonesSect);
        sect5.add((Component)flowDirectionSect, "gapbefore 20px");
        guiPanel sect6 = this.newSection(this.d_sections);
        if (this.isOnePoint()) {
            sect6.add(new guiLabel(Intl.intl("X:")));
            sect6.add((Component)this.d_startLocationX, "wrap");
            sect6.add(new guiLabel(Intl.intl("Y:")));
            sect6.add((Component)this.d_startLocationY, "wrap");
            sect6.add(new guiLabel(Intl.intl("Z:")));
            sect6.add((Component)this.d_startLocationZ, "wrap");
        } else {
            sect6.add(new guiLabel(Intl.intl("X1:")));
            sect6.add(this.d_startLocationX);
            sect6.add(new guiLabel(Intl.intl("X2:")));
            sect6.add((Component)this.d_endLocationX, "wrap");
            sect6.add(new guiLabel(Intl.intl("Y1:")));
            sect6.add(this.d_startLocationY);
            sect6.add(new guiLabel(Intl.intl("Y2:")));
            sect6.add((Component)this.d_endLocationY, "wrap");
            sect6.add(new guiLabel(Intl.intl("Z1:")));
            sect6.add(this.d_startLocationZ);
            sect6.add(new guiLabel(Intl.intl("Z2:")));
            sect6.add((Component)this.d_endLocationZ, "wrap");
        }
    }

    private void formatDirection(boolean dir) {
        this.d_direction.setText(!dir ? LEFT_ARROW : RIGHT_ARROW);
    }

    private boolean parseDirection() {
        return this.d_direction.getText().contains(RIGHT_ARROW);
    }

    private void finalizeSections() {
        int i = 0;
        for (guiPanel section : this.d_sections) {
            this.addSection(section);
            if (i < this.d_sections.size() - 1) {
                this.addSeparator();
            }
            ++i;
        }
    }

    private guiPanel newSection() {
        return new guiPanel(new MigLayout("insets 0, align center"));
    }

    private guiPanel newSection(ArrayList<guiPanel> sections) {
        guiPanel panel = this.newSection();
        sections.add(panel);
        return panel;
    }

    public boolean isOnePoint() {
        return this.d_mode == FlowPathBuilder.Mode.ONE_POINT;
    }

    @Override
    protected void updateFromProps(FlowPathBuilder props) {
        this.d_name.setText((String)props.get(FlowPath.NAME));
        this.d_flowElement.setSelectedItem(props.get(FlowPath.FLOW_ELEMENT));
        this.d_overwriteColor.setSelected(props.get(FlowPath.OVERWRITE_COLOR));
        this.d_color.setColor(props.get(FlowPath.COLOR));
        this.d_constantWindPressure.setSelected(props.get(FlowPath.CONSTANT_WIND_PRESSURE));
        this.d_windPressure.setValue(props.get(FlowPath.WIND_PRESSURE));
        this.d_windProfile.setSelectedItem(props.get(FlowPath.WIND_PROFILE));
        this.d_azimuth.setValue(props.get(FlowPath.AZIMUTH));
        ISchematicRoom start = props.get(FlowPath.START_ZONE);
        ISchematicRoom end = props.get(FlowPath.END_ZONE);
        this.d_startZone.setText(start.getName());
        this.d_endZone.setText(end.getName());
        this.d_startLocationX.setValue(new UnitDouble(props.get(FlowPath.START_LOCATION).x, SI.METER));
        this.d_startLocationY.setValue(new UnitDouble(props.get(FlowPath.START_LOCATION).y, SI.METER));
        this.d_startLocationZ.setValue(new UnitDouble(props.get(FlowPath.START_LOCATION).z, SI.METER));
        this.d_endLocationX.setValue(new UnitDouble(props.get(FlowPath.END_LOCATION).x, SI.METER));
        this.d_endLocationY.setValue(new UnitDouble(props.get(FlowPath.END_LOCATION).y, SI.METER));
        this.d_endLocationZ.setValue(new UnitDouble(props.get(FlowPath.END_LOCATION).z, SI.METER));
        this.formatDirection(props.get(FlowPath.DIRECTION));
    }

    @Override
    protected void updateToProps(FlowPathBuilder props) {
        props.pause();
        props.set(FlowPath.NAME, this.d_name.getValue());
        props.set(FlowPath.FLOW_ELEMENT, this.d_flowElement.getSelectedItem());
        props.set(FlowPath.OVERWRITE_COLOR, this.d_overwriteColor.isSelected());
        props.set(FlowPath.COLOR, this.d_color.getColor());
        props.set(FlowPath.CONSTANT_WIND_PRESSURE, this.d_constantWindPressure.isSelected());
        props.set(FlowPath.WIND_PRESSURE, (UnitDouble)this.d_windPressure.getValue());
        props.set(FlowPath.WIND_PROFILE, this.d_windProfile.getSelectedItem());
        props.set(FlowPath.DIRECTION, this.parseDirection());
        props.resume();
    }
}

