/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.MerlinOpImpl;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.comps.SelectionRibbonHelper;
import ventus.feature.flowpaths.EditFlowElementsMgrOp;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.windprofiles.WindProfile;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.UnitUpdator;
import ventus.gui.guiUtil;
import ventus.gui.value.ScheduleField;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.unitsystem.UnitSystem;
import ventus.util.MerlinUtil;

public class FlowPathRibbon
implements ISelectionRibbon {
    private guiComboBox<FlowElement> d_flowElementComboBox;
    private HTMLBtn d_flowElementEditBtn;
    private guiComboBox<WindProfile> d_windProfileComboBox;
    private final List<SelectionEditorPanel.EditorPanel> d_sections = new ArrayList<SelectionEditorPanel.EditorPanel>();
    private ColorButton d_color;
    private ScheduleField d_scheduleMultiplierFld;

    private void createSections() {
        this.d_flowElementComboBox = new MerlinComboBox(VentusApp.getAppData(), FlowElement.class, (IMerlinObj[])new FlowElement[0]);
        PropConnections.ComboPropConn<FlowElement> elementConn = new PropConnections.ComboPropConn<FlowElement>(new CompElementActions.DefProp(FlowPath.FLOW_ELEMENT), this.d_flowElementComboBox);
        this.d_flowElementEditBtn = new HTMLBtn(Intl.intl("Edit..."));
        EditPropFlowElement editElementConn = new EditPropFlowElement(FlowPath.FLOW_ELEMENT, this.d_flowElementEditBtn);
        HTMLBtn zone1Button = new HTMLBtn("");
        ZonePropConn zone1Conn = new ZonePropConn(FlowPath.START_ZONE, zone1Button);
        HTMLBtn zone2Button = new HTMLBtn("");
        ZonePropConn zone2Conn = new ZonePropConn(FlowPath.END_ZONE, zone2Button);
        HTMLBtn directionButton = new HTMLBtn("&larr;");
        DirectionPropConn directionConn = new DirectionPropConn(FlowPath.DIRECTION, directionButton);
        PropConnections.BoolPropConnection overwriteMultConn = SelectionRibbonHelper.boolConn(FlowPath.OVERWRITE_MULTIPLIER, Intl.intl("Multiplier:"));
        guiMultiStateCheckBox overwriteMultCheck = (guiMultiStateCheckBox)overwriteMultConn.getControl();
        PropConnections.UDPropConnection multiplierConn = FlowPathRibbon.multiplierConn();
        MerlinUDF multiplierField = (MerlinUDF)multiplierConn.getControl();
        guiLabel baseAreaLabel = new guiLabel("");
        MerlinUDF baseAreaValue = new MerlinUDF(Unit.ONE);
        UnitUpdator.addComp(baseAreaValue);
        baseAreaValue.setEditable(false);
        guiRadioButton constantWindPressureRadio = new guiRadioButton(Intl.intl("Constant:"));
        PropConnections.UDPropConnection windPressureConn = SelectionRibbonHelper.udConn(FlowPath.WIND_PRESSURE, 15);
        MerlinUDF windPressureField = (MerlinUDF)windPressureConn.getControl();
        guiRadioButton variableWindPressureRadio = new guiRadioButton(Intl.intl("Variable:"));
        this.d_windProfileComboBox = new MerlinComboBox(VentusApp.getAppData(), WindProfile.class, (IMerlinObj[])new WindProfile[0]);
        PropConnections.ComboPropConn<WindProfile> windProfileConn = new PropConnections.ComboPropConn<WindProfile>(new CompElementActions.DefProp(FlowPath.WIND_PROFILE), this.d_windProfileComboBox);
        PropConnections.UDPropConnection relHtConn = SelectionRibbonHelper.udConn(FlowPath.RELATIVE_ELEVATION, 0);
        new guiButtonGroup(constantWindPressureRadio, variableWindPressureRadio);
        LinkStatus.link((AbstractButton)overwriteMultCheck, multiplierField);
        LinkStatus.link((AbstractButton)constantWindPressureRadio, windPressureField);
        LinkStatus.link((AbstractButton)variableWindPressureRadio, this.d_windProfileComboBox);
        this.d_color = guiUtil.newColorButton();
        PropConnections.ColorConn colorConn = new PropConnections.ColorConn(this.d_color, FlowPath.COLOR);
        PropConnections.BoolPropConnection overwriteColorConn = SelectionRibbonHelper.boolConn(FlowPath.OVERWRITE_COLOR, Intl.intl("Color:"));
        guiMultiStateCheckBox d_overwriteColor = (guiMultiStateCheckBox)overwriteColorConn.getControl();
        LinkStatus.link((AbstractButton)d_overwriteColor, this.d_color);
        PropConnections.ScheduleProp scheduleMultiplierConn = SelectionRibbonHelper.scheduleConn(FlowPath.SCHEDULE_MULTIPLIER, FlowPath.SCHEDULE_MULTIPLIER.name, 10, UnitDoubleVR.ge(0.0, Unit.ONE));
        this.d_scheduleMultiplierFld = (ScheduleField)scheduleMultiplierConn.getControl();
        SelectionEditorPanel.EditorPanel section1 = this.newSection(this.d_sections);
        section1.addConnection(elementConn);
        section1.addConnection(editElementConn);
        section1.addConnection(colorConn);
        section1.addConnection(overwriteColorConn);
        section1.add((Component)this.createTitleLabel(Intl.intl("Properties")), "wrap");
        SelectionEditorPanel.EditorPanel flowCalcSect = this.newSection();
        flowCalcSect.add(new guiLabel(Intl.intl("Element:")));
        flowCalcSect.add(this.d_flowElementComboBox, "wmax 180px");
        flowCalcSect.add((Component)this.d_flowElementEditBtn, "wrap");
        flowCalcSect.add(d_overwriteColor);
        flowCalcSect.add((Component)this.d_color, "wrap");
        section1.add((Component)flowCalcSect, "gapbefore 20px, span");
        SelectionEditorPanel.EditorPanel section2 = this.newSection(this.d_sections);
        section2.addConnection(overwriteMultConn);
        section2.addConnection(multiplierConn);
        section2.add((Component)this.createTitleLabel(Intl.intl("Leakage Area")), "wrap");
        SelectionEditorPanel.EditorPanel leakageAreaSect = this.newSection();
        leakageAreaSect.add(baseAreaLabel);
        leakageAreaSect.add((Component)baseAreaValue, "wrap");
        leakageAreaSect.add(overwriteMultCheck);
        leakageAreaSect.add(multiplierField);
        section2.add((Component)leakageAreaSect, "gapbefore 20px");
        SelectionEditorPanel.EditorPanel section3 = this.newSection(this.d_sections);
        section3.addConnection(new WindPanelPropConn(section3));
        section3.addConnection(new BoolRadioPropConn(FlowPath.CONSTANT_WIND_PRESSURE, constantWindPressureRadio, true));
        section3.addConnection(new BoolRadioPropConn(FlowPath.CONSTANT_WIND_PRESSURE, variableWindPressureRadio, false));
        section3.addConnection(windPressureConn);
        section3.addConnection(windProfileConn);
        guiLabel windPressureTitle = new guiLabel(Intl.intl("Wind Pressure"));
        windPressureTitle.setFont(windPressureTitle.getFont().deriveFont(1));
        SelectionEditorPanel.EditorPanel windPressureSect = this.newSection();
        section3.add((Component)this.createTitleLabel(Intl.intl("Wind Pressure")), "wrap");
        windPressureSect.add(constantWindPressureRadio);
        windPressureSect.add((Component)windPressureField, "wrap");
        windPressureSect.add(variableWindPressureRadio);
        windPressureSect.add(this.d_windProfileComboBox, "growx");
        section3.add((Component)windPressureSect, "gapbefore 20px");
        SelectionEditorPanel.EditorPanel section4 = this.newSection(this.d_sections);
        section4.addConnection(relHtConn);
        section4.addConnection(zone1Conn);
        section4.addConnection(zone2Conn);
        section4.addConnection(directionConn);
        guiLabel relElevLabel = new guiLabel(Intl.intl("Rel. Height:"));
        relElevLabel.setToolTipText(Intl.intl("Elevation relative to floor level."));
        guiLabel powFlowDirLabel = new guiLabel(Intl.intl("Direction:"));
        powFlowDirLabel.setToolTipText(Intl.intl("Direction of positive flow in results."));
        section4.add((Component)this.createTitleLabel(Intl.intl("Geometry")), "wrap");
        section4.add((Component)relElevLabel, "gapbefore 20px");
        section4.add((Component)relHtConn.getControl(), "wrap");
        section4.add((Component)powFlowDirLabel, "gapbefore 20px");
        guiPanel zoneSect = new guiPanel(new MigLayout("insets 0, align center"));
        zoneSect.add(zone1Button);
        zoneSect.add(directionButton);
        zoneSect.add(zone2Button);
        section4.add(zoneSect);
        SelectionEditorPanel.EditorPanel section5 = this.newSection(this.d_sections);
        section5.addConnection(scheduleMultiplierConn);
        section5.add((Component)this.createTitleLabel(Intl.intl("Schedule")), "wrap");
        section5.add((Component)guiUtil.lblProp(FlowPath.SCHEDULE_MULTIPLIER), "gapbefore 20px");
        section5.add((Component)this.d_scheduleMultiplierFld, "wrap");
        Consumer<FlowElement> onFeChange = fe -> {
            String overwriteCtrlText;
            String baseAreaLabelText;
            UnitDouble baseAreaValueValue;
            Unit baseAreaValueUnit;
            if (fe == null) {
                return;
            }
            FlowElement.PowerlawModel model = fe.get(FlowElement.POWERLAW_MODEL);
            UnitSystem us = VentusApp.getApp().getUnitSystem();
            if (model == FlowElement.PowerlawModel.LEAKAGE_AREA) {
                FlowElement.LeakageAreaType laType = fe.get(FlowElement.LEAKAGE_AREA_TYPE);
                FlowElement.LeakageAreaTypeInfo laTypeInfo = new FlowElement.LeakageAreaTypeInfo(laType);
                baseAreaValueUnit = us.getUnit(laTypeInfo.unit);
                baseAreaValueValue = fe.get(laTypeInfo.prop);
                baseAreaLabelText = laTypeInfo.get(() -> Intl.intl("Area:"), () -> Intl.intl("Height:"), () -> Intl.intl("Item:"));
                overwriteCtrlText = laTypeInfo.get(() -> Intl.intl("Items:"), () -> Intl.intl("Length:"), () -> Intl.intl("Area:"));
            } else {
                baseAreaLabelText = Intl.intl("Area:");
                overwriteCtrlText = Intl.intl("Items:");
                baseAreaValueUnit = us.getArea();
                baseAreaValueValue = fe.get(FlowElement.CROSS_SECTIONAL_AREA);
            }
            baseAreaLabel.setText(baseAreaLabelText);
            ((guiMultiStateCheckBox)overwriteMultConn.getControl()).setText(overwriteCtrlText);
            baseAreaValue.setDisplayUnit(baseAreaValueUnit);
            baseAreaValue.setValue(baseAreaValueValue);
        };
        section1.addConnection(SelectionRibbonHelper.getPropConnListener(evt -> onFeChange.accept(this.d_flowElementComboBox.getSelectedItem())));
        this.d_flowElementComboBox.addItemListener(evt -> onFeChange.accept(this.d_flowElementComboBox.getSelectedItem()));
    }

    private SelectionEditorPanel.EditorPanel newSection() {
        return new SelectionEditorPanel.EditorPanel(new MigLayout("insets 0, aligny top"));
    }

    private SelectionEditorPanel.EditorPanel newSection(List<SelectionEditorPanel.EditorPanel> sections) {
        SelectionEditorPanel.EditorPanel panel = this.newSection();
        sections.add(panel);
        return panel;
    }

    private guiLabel createTitleLabel(String title) {
        guiLabel label = new guiLabel(title);
        label.setFont(label.getFont().deriveFont(1));
        return label;
    }

    @Override
    public boolean isEnabled(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(FlowPath.START_COMP);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        if (this.d_sections.isEmpty()) {
            this.createSections();
        }
        return this.d_sections;
    }

    public static PropConnections.UDPropConnection multiplierConn() {
        final MerlinUDF field = new MerlinUDF(Unit.ONE);
        return new PropConnections.UDPropConnection(new CompElementActions.DefProp(FlowPath.MULTIPLIER), field){

            @Override
            public void initFromVal(PropValue<UnitDouble> val, guiValueField<UnitDouble> comp) {
                if (val.isUniform() && val.get() != null) {
                    UnitDouble udVal = val.get();
                    UnitSystem us = VentusApp.getAppData().getUnitSystem();
                    int unitType = UnitSystem.getType(udVal.getUnit());
                    field.setDisplayUnit(us.getUnit(unitType));
                }
                super.initFromVal(val, comp);
            }
        };
    }

    public static class EditPropFlowElement
    extends PropConnections.ASinglePropConnection<HTMLBtn, TypedProp<FlowElement>> {
        public EditPropFlowElement(TypedProp<FlowElement> prop, HTMLBtn control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void setProp(TypedProp<FlowElement> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(TypedProp<FlowElement> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            PropValue<FlowElement> val = CompositePropertyUtil.getValue(prop, objs);
            comp.setVisible(false);
            comp.clearListeners();
            if (val.isUniform()) {
                comp.setVisible(true);
                comp.addActionListener(new EditPropFlowElementAction(val.get()));
            }
        }

        private static class EditPropFlowElementAction
        extends AMerlinOp
        implements ActionListener {
            private static FlowElement d_elem;

            public EditPropFlowElementAction(FlowElement elem) {
                d_elem = elem;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UIHook.run(UIHook.getComponent(e), "EditFlowElementAction", this, 0);
            }

            @Override
            public void run(VentusApp app, VentusData md) {
                EditFlowElementsMgrOp.showDlg(app, md, d_elem);
            }
        }
    }

    public static class ZonePropConn
    extends PropConnections.ASinglePropConnection<HTMLBtn, CompElementActions.IObjectProp<IMerlinObj, ISchematicRoom>> {
        public ZonePropConn(TypedProp<ISchematicRoom> prop, HTMLBtn control) {
            super(new CompElementActions.DefProp(prop), control);
            control.addActionListener(this);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, ISchematicRoom> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, ISchematicRoom> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            comp.clearListeners();
            PropValue<ISchematicRoom> value = prop.get(VentusApp.getAppData(), objs);
            if (!value.isUniform()) {
                comp.setText(Intl.intl("&lt;mixed&gt;"));
                return;
            }
            ISchematicRoom zone = value.get();
            comp.setText(MerlinUtil.getName(zone));
            if (zone.equals(FlowPath.AMBIENT_ZONE)) {
                return;
            }
            comp.addActionListener(evt -> {
                MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Select Zone"));
                        Undo.insertUndoEntry_restoreSelection(md);
                        md.selection.set(zone);
                        Undo.end(md);
                    }
                });
                UIHook.run(UIHook.getComponent(evt), "FlowPathRibbon.ZonePropConn.initFromProp", op, 0);
            });
        }
    }

    public static class DirectionPropConn
    extends PropConnections.ASinglePropConnection<HTMLBtn, CompElementActions.IObjectProp<IMerlinObj, Boolean>> {
        private static final String POSITIVE = "&rarr;";
        private static final String NEGATIVE = "&larr;";
        private boolean d_modified = false;

        public DirectionPropConn(TypedProp<Boolean> prop, HTMLBtn control) {
            super(new CompElementActions.DefProp(prop), control);
            control.clearListeners();
            control.addActionListener(evt -> {
                Boolean direction = DirectionPropConn.parse(control);
                direction = direction == null ? Boolean.valueOf(true) : Boolean.valueOf(direction == false);
                this.d_modified = true;
                control.setText(DirectionPropConn.format(direction));
            });
            control.addActionListener(this);
        }

        private static Boolean parse(HTMLBtn comp) {
            if (comp.getText().contains(POSITIVE)) {
                return true;
            }
            if (comp.getText().contains(NEGATIVE)) {
                return false;
            }
            return null;
        }

        private static String format(Boolean dir) {
            return dir != null ? (dir.booleanValue() ? POSITIVE : NEGATIVE) : "&lt;&gt;";
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            if (comp.getText() == null || objs.isEmpty()) {
                return;
            }
            Boolean direction = DirectionPropConn.parse(comp);
            if (direction == null) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Flow Direction"), prop, objs, direction);
            this.d_modified = false;
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            if (objs.isEmpty()) {
                return;
            }
            PropValue<Boolean> val = prop.get(VentusApp.getApp().getData(), objs);
            String text = DirectionPropConn.format(val.orElse(null));
            comp.setText(text);
            this.d_modified = false;
        }
    }

    public static class WindPanelPropConn
    extends PropConnections.AMultiPropConnection<SelectionEditorPanel.EditorPanel, TypedProp<ISchematicRoom>> {
        public WindPanelPropConn(SelectionEditorPanel.EditorPanel control) {
            super(Arrays.asList(FlowPath.START_ZONE, FlowPath.END_ZONE), control);
        }

        @Override
        public void setProps(Collection<? extends TypedProp<ISchematicRoom>> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel comp) {
        }

        @Override
        public void initFromProp(Collection<? extends TypedProp<ISchematicRoom>> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel panel) {
            boolean connectedToAmbient = CompElementActions.flattenToLocallyDefined(FlowPath.START_ZONE, objs).stream().allMatch(obj -> {
                assert (obj.isSupportedLocally(FlowPath.END_ZONE));
                ISchematicRoom start = obj.get(FlowPath.START_ZONE);
                ISchematicRoom end = obj.get(FlowPath.END_ZONE);
                return FlowPath.isExterior(new Pair<ISchematicRoom, ISchematicRoom>(start, end));
            });
            panel.setEnabled(connectedToAmbient);
        }
    }

    public static class BoolRadioPropConn
    extends PropConnections.ASinglePropConnection<guiRadioButton, CompElementActions.IObjectProp<IMerlinObj, Boolean>> {
        private final boolean d_valueWhenSelected;

        public BoolRadioPropConn(TypedProp<Boolean> prop, guiRadioButton control, boolean valueWhenSelected) {
            super(new CompElementActions.DefProp(prop), control);
            this.d_valueWhenSelected = valueWhenSelected;
            control.addItemListener(this);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, guiRadioButton comp) {
            if (objs.isEmpty()) {
                return;
            }
            if (!comp.isSelected()) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Wind Pressure"), prop, objs, Boolean.valueOf(this.d_valueWhenSelected));
            comp.setModified(false);
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, guiRadioButton comp) {
            ButtonGroup group;
            if (objs.isEmpty()) {
                return;
            }
            PropValue<Boolean> value = prop.get(VentusApp.getAppData(), objs);
            if (!value.isUniform() && (group = comp.getModel().getGroup()) != null) {
                group.clearSelection();
            }
            comp.setSelected(value.map(b -> b == this.d_valueWhenSelected).orElse(false));
            comp.setModified(false);
        }
    }
}

