/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.AGeomNode;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathDispProps;
import ventus.geom.IMerlinDispProps;

public class FlowPathGeometry
extends GeomGroup {
    private static final long serialVersionUID = 1L;
    public static final int DOTTED_STIPPLE = IPrimProps.Edge.makeStipple(4, (short)-3856);
    public final Pair<Point3d, Point3d> locations;
    private final Pair<Vector3d, Vector3d> normals;
    private final boolean isExterior;
    private final double size;
    private static final CachedValue<IGeom> cache_sphere = new CachedValue();
    private static final CachedValue<IGeom> s_unitOctahedron = new CachedValue();

    public FlowPathGeometry(Pair<Vector3d, Vector3d> normals, Pair<Point3d, Point3d> locations, boolean isExterior, double size, boolean solid) {
        super(FlowPathGeometry.generateGeoms(normals, locations, isExterior, size, solid));
        this.locations = locations;
        this.normals = normals;
        this.isExterior = isExterior;
        this.size = size;
    }

    public Pair<IGeomNode, IPropsSrc> getRenderData(FlowPath fp, IMerlinDispProps appProps) {
        AGeomNode geom = GeomNodeUtil.newNode(this);
        PropsBuilder pb = new PropsBuilder();
        Color edgeColor = fp.getColor().darker();
        if (this.isExterior) {
            shape = FlowPathGeometry.generateOctahedron();
            faces = shape.getNumPrims(1);
            edges = shape.getNumPrims(2);
            pb.add(new IPrimProps.Face(fp.getColor(), null, 0), faces);
            pb.add(new IPrimProps.Edge(edgeColor, 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
            pb.add(new IPrimProps.Face(fp.getColor(), null, 0), faces);
            pb.add(new IPrimProps.Edge(edgeColor, 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
        } else {
            shape = FlowPathGeometry.generateSphere();
            faces = shape.getNumPrims(1);
            edges = shape.getNumPrims(2);
            pb.add(new IPrimProps.Face(fp.getColor(), null, 0), faces);
            pb.add(new IPrimProps.Edge(edgeColor, 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
            pb.add(new IPrimProps.Face(fp.getColor(), null, 0), faces);
            pb.add(new IPrimProps.Edge(edgeColor, 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
        }
        IPrimProps edgeProps = appProps.getEdgeProps(fp, IMerlinDispProps.SchematicType.BOUNDARY, null, 1.0f);
        pb.add(new IPrimProps.Edge(edgeProps.getColor(), edgeProps.getEdgeWidth(), DOTTED_STIPPLE, 0));
        EnumSet<FlowPathDispProps.Options> fpOptions = appProps.get(FlowPathDispProps.OPTIONS);
        if (fpOptions.contains((Object)FlowPathDispProps.Options.SHOW_AREA_CALCULATION)) {
            Pair<UnitDouble, IGeom> mi = fp.getMultiplierInfo();
            if (!((IGeom)mi.v2).isEmpty(true) && !fp.getName().equals("")) {
                ArrayList<GeomNodeLeaf> nodes = new ArrayList<GeomNodeLeaf>(2);
                nodes.add((GeomNodeLeaf)geom);
                nodes.add(GeomNodeUtil.newNode((IGeom)mi.v2));
                geom = GeomNodeUtil.newNode(nodes);
                int numEdges = ((IGeom)mi.v2).getNumPrims(2);
                int numFaces = ((IGeom)mi.v2).getNumPrims(1);
                assert (numEdges != 0 ^ numFaces != 0);
                if (numEdges != 0) {
                    pb.add(new IPrimProps.Edge(FlowPathDispProps.FLOW_AREA_COLOR, 5.0, IPrimProps.DEF_STIPPLE, 0), numEdges);
                }
                if (numFaces != 0) {
                    pb.add(new IPrimProps.Face(FlowPathDispProps.FLOW_AREA_COLOR, null, 0), numFaces);
                }
            }
        }
        return new Pair<IGeomNode, IPropsSrc>(geom, pb.finalizeProps());
    }

    private static List<IGeom> generateGeoms(Pair<Vector3d, Vector3d> normals, Pair<Point3d, Point3d> locations, boolean isExterior, double size, boolean solid) {
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        IGeom endCapShape = isExterior ? FlowPathGeometry.generateOctahedron() : FlowPathGeometry.generateSphere();
        List<IGeom> caps = Arrays.asList(endCapShape, endCapShape);
        for (int i = 0; i < caps.size(); ++i) {
            Point3d thisLoc = i == 0 ? (Point3d)locations.v1 : (Point3d)locations.v2;
            Vector3d thisNorm = i == 0 ? (Vector3d)normals.v1 : (Vector3d)normals.v2;
            ITransform xform = TransformUtil.translate(thisLoc);
            xform = xform.concatenate(new MatrixXform(Util.getLocalToWorldXform(new Plane3d(thisNorm, GeomConstants.PNT3D_ORIGIN))));
            xform = xform.concatenate(TransformUtil.scale(size, size, size));
            IGeom xformed = caps.get(i).transform(xform.getInfo(), 0);
            geoms.add(xformed);
        }
        if (solid) {
            LineSeg lineGeom = new LineSeg((Point3d)locations.v1, (Point3d)locations.v2);
            geoms.add(lineGeom);
        }
        return geoms;
    }

    private static IGeom generateSphere() {
        return cache_sphere.get(() -> {
            int stacks = 6;
            int slices = 6;
            double size = 0.4;
            ArrayList<Point3d> verts = new ArrayList<Point3d>();
            verts.add(new Point3d(0.0, size, 0.0));
            for (int i = 0; i < stacks - 1; ++i) {
                double phi = Math.PI * ((double)(i + 1) / (double)stacks);
                for (int j = 0; j < slices; ++j) {
                    double theta = Math.PI * 2 * ((double)j / (double)slices);
                    Point3d pt = new Point3d(Math.cos(theta) * Math.sin(phi) * size, Math.cos(phi) * size, Math.sin(theta) * Math.sin(phi) * size);
                    verts.add(pt);
                }
            }
            verts.add(new Point3d(0.0, -size, 0.0));
            ArrayList<Integer> triFaceIndices = new ArrayList<Integer>();
            ArrayList<Integer> creaseSegIndices = new ArrayList<Integer>();
            for (int i = 0; i < slices; ++i) {
                int t0 = 0;
                int t1 = (i + 1) % slices + 1;
                int t2 = i + 1;
                triFaceIndices.addAll(Arrays.asList(t0, t1, t2));
                creaseSegIndices.addAll(Arrays.asList(t0, t1, t2, t0));
                int b0 = i + slices * (stacks - 2) + 1;
                int b1 = (i + 1) % slices + slices * (stacks - 2) + 1;
                int b2 = verts.size() - 1;
                triFaceIndices.addAll(Arrays.asList(b0, b1, b2));
                creaseSegIndices.addAll(Arrays.asList(b0, b1, b2, b0));
            }
            for (int j = 0; j < stacks - 2; ++j) {
                int j0 = j * slices + 1;
                int j1 = (j + 1) * slices + 1;
                for (int i = 0; i < slices; ++i) {
                    int i0 = j0 + i;
                    int i1 = j0 + (i + 1) % slices;
                    int i2 = j1 + (i + 1) % slices;
                    int i3 = j1 + i;
                    triFaceIndices.addAll(Arrays.asList(i0, i1, i2));
                    triFaceIndices.addAll(Arrays.asList(i2, i3, i0));
                    creaseSegIndices.addAll(Arrays.asList(i0, i1, i1, i2, i2, i3, i3, i0));
                }
            }
            Mesh sphere = new Mesh((Point3d[])theUtil.toArray(verts), theUtil.toIntArray(triFaceIndices), 2, 4);
            Mesh creases = new Mesh((Point3d[])theUtil.toArray(verts), theUtil.toIntArray(creaseSegIndices), 1, 0);
            GeomGroup sphereAndCreases = new GeomGroup(Arrays.asList(sphere, creases));
            ITransform rot90 = TransformUtil.rotate(1.0, 0.0, 0.0, 1.5707963267948966);
            return sphereAndCreases.transform(rot90.getInfo(), 0);
        });
    }

    private static IGeom generateOctahedron() {
        return s_unitOctahedron.get(() -> {
            Point3d lx;
            double size = 0.5;
            Point3d top = new Point3d(0.0, 0.0, size);
            Point3d bot = new Point3d(0.0, 0.0, -size);
            Point3d ly = new Point3d(0.0, size, 0.0);
            Point3d v1 = lx = new Point3d(size, 0.0, 0.0);
            Point3d v2 = ly;
            Point3d v3 = Util3D.scale(lx, -1.0);
            Point3d v4 = Util3D.scale(ly, -1.0);
            int itop = 4;
            int ibot = 5;
            Point3d[] verts = new Point3d[]{v1, v2, v3, v4, null, null};
            verts[itop] = top;
            verts[ibot] = bot;
            ArrayList ixes = new ArrayList();
            TriConsumer<Integer, Integer, Integer> addTri = (i1, i2, i3) -> {
                ixes.add(i1);
                ixes.add(i2);
                ixes.add(i3);
            };
            for (int i = 0; i < 4; ++i) {
                int j = (i + 1) % 4;
                addTri.accept(itop, i, j);
                addTri.accept(ibot, j, i);
            }
            Mesh m = new Mesh(verts, theUtil.toIntArray(ixes), 2);
            Mesh outlines = m.generateOutlines();
            return new GeomGroup(Arrays.asList(m, outlines));
        });
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Pair<Point3d, Point3d> newLocations = new Pair<Point3d, Point3d>(Util3D.xform(ti.getMatrix(), (Point3d)this.locations.v1), Util3D.xform(ti.getMatrix(), (Point3d)this.locations.v2));
        Pair<Vector3d, Vector3d> newNormals = new Pair<Vector3d, Vector3d>(Util3D.xform(ti.getMatrix(), (Vector3d)this.normals.v1), Util3D.xform(ti.getMatrix(), (Vector3d)this.normals.v2));
        return new FlowPathGeometry(newNormals, newLocations, this.isExterior, this.size, true);
    }
}

