/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.APropsDisplay;
import ventus.util.MerlinProps;

public class FlowPathBuilder
extends MerlinProps
implements IEventObserver {
    public static final TypedProp<Boolean> OVERWRITE_ELEVATION = TypedProps.newProp((Object)"FlowPathBuilder.OVERWRITE_ELEVATION", false, new Object[0]);
    public static final TypedProp<Mode> MODE = TypedProps.newProp((Object)"FlowPathBuilder.MODE", Mode.class, Mode.ONE_POINT, new Object[0]);
    public static final TypedProp<UnitDouble> RELATIVE_ELEVATION = TypedProps.newProp((Object)"FlowPathBuilder.RELATIVE_ELEVATION", UnitDouble.class, new UnitDouble(0.0, SI.METER), new Object[0]);
    private final FlowPath d_comp = new FlowPath("", this.getDefaultElement());
    public static float SNAP_THRESHOLD = 0.5f;

    public FlowPathBuilder() {
        VentusApp.getAppData().getEvents().addObserver(this);
    }

    private FlowElement getDefaultElement() {
        VentusData vd = VentusApp.getAppData();
        FlowElementRoot flowElementRoot = (FlowElementRoot)vd.getComponentData(FlowElementData.GUID);
        return flowElementRoot != null ? flowElementRoot.getDefault() : new FlowElement("");
    }

    @Override
    public void update(Events events) {
        IEventRecord<FlowElement> rec = events.getEvents(FlowElement.class, new Class[0]);
        if (rec.getRemovedObjs().contains(this.d_comp.get(FlowPath.FLOW_ELEMENT))) {
            this.d_comp.set(FlowPath.FLOW_ELEMENT, this.getDefaultElement());
        }
    }

    public FlowPath comp() {
        return this.d_comp;
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (!(prop instanceof TypedProp)) {
            return;
        }
        if (!FlowPath.has((TypedProp)prop)) {
            super.set(prop, val);
            return;
        }
        if (!this.lock()) {
            return;
        }
        try {
            this.d_comp.set((TypedProp)prop, val);
            this.firePropChanged(prop);
        }
        finally {
            this.release();
        }
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        if (!(prop instanceof TypedProp)) {
            return null;
        }
        if (FlowPath.has((TypedProp)prop)) {
            return this.d_comp.get((TypedProp)prop);
        }
        return super.get(prop);
    }

    public void setLocation(ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.setStartLocation(comp, normal, location, wall);
        this.setEndLocation(comp, normal, location, wall);
        if (this.get(OVERWRITE_ELEVATION).booleanValue()) {
            this.comp().setRelativeElevation(this.get(RELATIVE_ELEVATION));
            this.firePropChanged(RELATIVE_ELEVATION);
        } else {
            this.set(RELATIVE_ELEVATION, this.comp().getRelativeElevation());
        }
    }

    public boolean is2Pt() {
        return this.get(MODE) == Mode.TWO_POINT;
    }

    public boolean isValid() {
        Point3d startLocation = this.get(FlowPath.START_LOCATION);
        Point3d endLocation = this.get(FlowPath.END_LOCATION);
        ISchematicRoom startComp = this.get(FlowPath.START_COMP);
        ISchematicRoom endComp = this.get(FlowPath.END_COMP);
        return startComp != null && endComp != null && startLocation != null && endLocation != null;
    }

    public void reset(boolean fullReset) {
        this.pause();
        this.set(FlowPath.START_COMP, (ISchematicRoom)FlowPath.START_COMP.defVal);
        this.set(FlowPath.END_COMP, (ISchematicRoom)FlowPath.END_COMP.defVal);
        this.set(FlowPath.START_LOCATION, (Point3d)FlowPath.START_LOCATION.defVal);
        this.set(FlowPath.END_LOCATION, (Point3d)FlowPath.END_LOCATION.defVal);
        this.set(FlowPath.START_NORMAL, (Vector3d)FlowPath.START_NORMAL.defVal);
        this.set(FlowPath.END_NORMAL, (Vector3d)FlowPath.END_NORMAL.defVal);
        this.set(MODE, (Mode)((Object)FlowPathBuilder.MODE.defVal));
        if (fullReset) {
            this.set(RELATIVE_ELEVATION, (UnitDouble)FlowPathBuilder.RELATIVE_ELEVATION.defVal);
            this.set(OVERWRITE_ELEVATION, (Boolean)FlowPathBuilder.OVERWRITE_ELEVATION.defVal);
        }
        this.resume();
    }

    public void cancel() {
        this.reset(true);
    }

    public void setLocation(ISchematicRoom startComp, ISchematicRoom endComp, ISchematicRoom.IWallComponent startWall, ISchematicRoom.IWallComponent endWall, Vector3d startNormal, Vector3d endNormal, Point3d startLocation, Point3d endLocation) {
        this.setStartLocation(startComp, startNormal, startLocation, startWall);
        this.setEndLocation(endComp, endNormal, endLocation, endWall);
        if (endComp != startComp) {
            this.set(FlowPath.DIRECTION, true);
        }
    }

    public void setLocation(FlowPath.Connection conn, ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.pause();
        this.set(conn.comp, comp);
        this.set(conn.normal, normal);
        this.set(conn.location, location);
        this.set(conn.wall, wall);
        this.resume();
    }

    public void setStartLocation(ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.setLocation(FlowPath.Connection.START, comp, normal, location, wall);
    }

    public void setEndLocation(ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.setLocation(FlowPath.Connection.END, comp, normal, location, wall);
    }

    public void create() {
        if (!this.isValid()) {
            return;
        }
        final FlowPath path = this.comp().clone();
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(VentusApp app, VentusData md) {
                FlowPathRoot dataRoot = (FlowPathRoot)md.getComponentData("flowpaths.data");
                if (dataRoot == null) {
                    return;
                }
                try (VentusData.WriteLock ignored = md.lockWrite();){
                    Undo.begin(Intl.intl("Create Flow Path"));
                    String nextName = path.getName().equals("") ? dataRoot.nextName() : path.getName();
                    path.setName(nextName);
                    path.updateInitialConnectionType();
                    AddObject.add((VentusData)md, (Composite)dataRoot, (int)dataRoot.getChildren().size(), (IMerlinObj[])new FlowPath[]{path});
                    Undo.end(md);
                }
            }
        };
        UIHook.run(null, "FlowPathBuilder.create", op, 4);
    }

    public static enum Mode {
        ONE_POINT,
        TWO_POINT;

    }

    private static class ToolGeomSrc
    implements IMerlinGeomSrc {
        private final FlowPathBuilder d_builder;
        private static IGeom d_unitCircleWithOutline;
        private static IGeom d_toolGeom;

        public ToolGeomSrc(FlowPathBuilder builder) {
            this.d_builder = builder;
            if (d_unitCircleWithOutline == null) {
                int wedges = 12;
                ArrayList<Point3d> verts = new ArrayList<Point3d>();
                verts.add(new Point3d(0.0, 0.0, 0.0));
                for (int i = 0; i < wedges; ++i) {
                    double theta = (double)i / (double)wedges * (Math.PI * 2);
                    Point3d pt = new Point3d(Math.cos(theta), Math.sin(theta), 0.0);
                    verts.add(pt);
                }
                boolean ic = false;
                boolean i0 = true;
                ArrayList<Integer> triFaceIndices = new ArrayList<Integer>();
                ArrayList<Integer> edgeSegIndices = new ArrayList<Integer>();
                for (int i = 0; i < wedges - 1; ++i) {
                    triFaceIndices.addAll(Arrays.asList(0, 1 + i, 1 + i + 1));
                    edgeSegIndices.addAll(Arrays.asList(1 + i, 1 + i + 1));
                }
                triFaceIndices.addAll(Arrays.asList(0, verts.size() - 1, 1));
                edgeSegIndices.addAll(Arrays.asList(verts.size() - 1, 1));
                Mesh circle = new Mesh((Point3d[])theUtil.toArray(verts), theUtil.toIntArray(triFaceIndices), 2, 0);
                Mesh creases = new Mesh((Point3d[])theUtil.toArray(verts), theUtil.toIntArray(edgeSegIndices), 1, 0);
                GeomGroup circleWithOutline = new GeomGroup(Arrays.asList(circle, creases));
                d_unitCircleWithOutline = circleWithOutline;
            }
            FlowPath fp = this.d_builder.comp();
            Vector3d normal = fp.get(FlowPath.START_NORMAL);
            Point3d loc = fp.get(FlowPath.START_LOCATION);
            double size = fp.get(FlowPath.SIZE).getValue(SI.METER) * 0.4;
            ITransform xform = TransformUtil.translate(loc);
            xform = xform.concatenate(new MatrixXform(Util.getLocalToWorldXform(new Plane3d(normal, GeomConstants.PNT3D_ORIGIN))));
            xform = xform.concatenate(TransformUtil.scale(size, size, size));
            d_toolGeom = d_unitCircleWithOutline.transform(xform.getInfo(), 0);
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            PropsBuilder pb = new PropsBuilder();
            int faces = d_toolGeom.getNumPrims(1);
            int edges = d_toolGeom.getNumPrims(2);
            Color c = this.d_builder.comp().getColor();
            pb.add(new IPrimProps.Face(c, null, 0), faces);
            pb.add(new IPrimProps.Edge(c.darker(), 1.0, IPrimProps.DEF_STIPPLE, 0), edges);
            return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(d_toolGeom), pb.finalizeProps());
        }

        @Override
        public boolean isVisible() {
            return this.d_builder.isValid();
        }

        @Override
        public void setVisible(boolean visible) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setGeom(IGeomNode geom) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IGeomNode getGeom() {
            return null;
        }

        @Override
        public Object clone() {
            return new ToolGeomSrc(this.d_builder);
        }
    }

    public static class Display
    extends APropsDisplay<FlowPathBuilder> {
        public Display(ModelView mv) {
            super(mv);
        }

        @Override
        protected IMerlinGeomSrc constructGeom(FlowPathBuilder builder) {
            if (!builder.isValid()) {
                return null;
            }
            if (builder.is2Pt()) {
                return null;
            }
            return new ToolGeomSrc(builder);
        }

        @Override
        protected Object[] getInterestingChanges() {
            return new Object[0];
        }
    }
}

