/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.QuadFunction;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.ISchematicRoomColorSrc;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPathGeometry;
import ventus.feature.flowpaths.FlowPathInitConnection;
import ventus.feature.flowpaths.FlowPathUtil;
import ventus.feature.props.DisplayProp;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropertyDefs;
import ventus.feature.props.TypedProps;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.feature.windprofiles.WindProfile;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;
import ventus.geom.IMerlinDispProps;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;
import ventus.util.Dependencies;

public class FlowPath
extends NamedMerlinObj
implements Serializable,
ISchematicObj,
ISurrogate,
IEventObserver,
ISchematicRoomColorSrc,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<FlowPath> PROP_TYPES = new PropertyDefs<FlowPath>(new PropertyDefs.Storage<FlowPath>(obj -> obj.d_properties, obj -> obj.d_transientProps, obj -> {
        obj.d_properties = new PropertySet();
        obj.d_transientProps = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES).attrDefaults(Object.class, dattrs -> dattrs.attrSurrogateEquals(null));
    public static final TypedProp<Boolean> VISIBILITY = PROP_TYPES.storeAsPlainOldData(VentusData.VISIBILITY).attrFinish();
    public static final TypedProp<String> DESC = DisplayProps.build((Object)"FlowPath.DESC", "", Intl.intl("Description"), "").attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> SIZE = TypedProps.build((Object)"FlowPath.SIZE", new UnitDouble(1.0, SI.METER)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Point3d> START_LOCATION = TypedProps.build("FlowPath.START_LOCATION", Point3d.class, new Point3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROP_TYPES).attrFireEvents(FlowPath.getTopoFireEvents()).attrFinish();
    public static final TypedProp<Vector3d> START_NORMAL = TypedProps.build("FlowPath.START_NORMAL", Vector3d.class, new Vector3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<ISchematicRoom> START_COMP = TypedProps.build((Object)"FlowPath.START_COMP", ISchematicRoom.class).attrStoreAsTopology(PROP_TYPES).attrFinish();
    public static final TypedProp<ISchematicRoom.IWallComponent> START_WALL = TypedProps.build((Object)"FlowPath.START_WALL", ISchematicRoom.IWallComponent.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Point3d> END_LOCATION = TypedProps.build("FlowPath.END_LOCATION", Point3d.class, new Point3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROP_TYPES).attrFireEvents(FlowPath.getTopoFireEvents()).attrFinish();
    public static final TypedProp<Vector3d> END_NORMAL = TypedProps.build("FlowPath.END_NORMAL", Vector3d.class, new Vector3d(0.0, 0.0, 0.0)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<ISchematicRoom> END_COMP = TypedProps.build((Object)"FlowPath.END_COMP", ISchematicRoom.class).attrStoreAsTopology(PROP_TYPES).attrFinish();
    public static final TypedProp<ISchematicRoom.IWallComponent> END_WALL = TypedProps.build((Object)"FlowPath.END_WALL", ISchematicRoom.IWallComponent.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<ISchematicRoom> START_ZONE = TypedProps.build((Object)"FlowPath.START_ZONE", ISchematicRoom.class).attrStoreAsReadOnly(PROP_TYPES).attrGetter(FlowPath::getStartZone, START_COMP, START_LOCATION, START_WALL, END_COMP, END_LOCATION, END_WALL).attrFinish();
    public static final TypedProp<ISchematicRoom> END_ZONE = TypedProps.build((Object)"FlowPath.END_ZONE", ISchematicRoom.class).attrStoreAsReadOnly(PROP_TYPES).attrGetter(FlowPath::getEndZone, START_COMP, START_LOCATION, START_WALL, END_COMP, END_LOCATION, END_WALL).attrFinish();
    public static final TypedProp<Boolean> OVERWRITE_MULTIPLIER = TypedProps.build((Object)"FlowPath.OVERWRITE_MULTIPLIER", true).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    private static final TypedProp<FlowElement> STORED_FLOW_ELEMENT = TypedProps.build((Object)"FlowPath.FLOW_ELEMENT", FlowElement.class).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, FlowElement.class, Predicates.alwaysTrue())).attrFinish();
    public static final TypedProp<FlowElement> FLOW_ELEMENT = TypedProps.build((Object)"FlowPath.PRESENTED_FLOW_ELEMENT", FlowElement.class).attrStoreAsWrapper(PROP_TYPES).attrGetter(fp -> fp.get(STORED_FLOW_ELEMENT), STORED_FLOW_ELEMENT, new TypedProp[0]).attrSetter((fp, e) -> fp.setFlowElement((FlowElement)e)).attrUndoPropRestore(STORED_FLOW_ELEMENT, OVERWRITE_MULTIPLIER).attrFinish();
    private static final TypedProp<UnitDouble> STORED_MULTIPLIER = TypedProps.build((Object)"FlowPath.MULTIPLIER", new UnitDouble(1.0, Unit.ONE)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> MULTIPLIER = TypedProps.build((Object)"FlowPath.PRESENTED_MULTIPLIER", (UnitDouble)FlowPath.STORED_MULTIPLIER.defVal).attrStoreAsWrapper(PROP_TYPES).attrGetter(FlowPath::getMultiplier, STORED_MULTIPLIER, OVERWRITE_MULTIPLIER, FLOW_ELEMENT, START_COMP, START_WALL, END_COMP, END_WALL).attrSetter((fp, m) -> fp.set(STORED_MULTIPLIER, m)).attrUndoPropRestore(STORED_MULTIPLIER).attrFinish();
    public static final DisplayProp<Schedule> SCHEDULE_MULTIPLIER = (DisplayProp)DisplayProps.build((Object)"FlowPath.SCHEDULE_MULTIPLIER", Schedule.class, Schedule.newConstant(new UnitDouble(1.0, Unit.ONE)), Intl.intl("Multiplier"), Intl.intl("Multiplier applied to the flow rate.")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Boolean> OVERWRITE_COLOR = TypedProps.build((Object)"FlowPath.OVERWRITE_COLOR", false).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Color> STORED_COLOR = TypedProps.build("FlowPath.COLOR", Color.class, Color.RED).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Color> COLOR = TypedProps.build("FlowPath.DISPLAY_COLOR", Color.class, (Color)FlowPath.STORED_COLOR.defVal).attrStoreAsWrapper(PROP_TYPES).attrSetter((prop, fp, c) -> fp.set(STORED_COLOR, c)).attrGetter(FlowPath::getColor, STORED_COLOR, OVERWRITE_COLOR, FLOW_ELEMENT).attrUndoPropRestore(STORED_COLOR).attrFinish();
    public static final TypedProp<Boolean> DIRECTION = TypedProps.build((Object)"FlowPath.DIRECTION", false).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Boolean> CONSTANT_WIND_PRESSURE = TypedProps.build((Object)"FlowPath.CONSTANT_WIND_PRESSURE", true).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<WindProfile> WIND_PROFILE = TypedProps.build((Object)"FlowPath.WIND_PROFILE", WindProfile.class).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> new DepCallback<VentusData, FlowPath, WindProfile, WindProfile>(DLink.WEAK, WindProfile.class, (vd, src, prof) -> Stream.of(prof), Predicates.alwaysTrue(), new DepCallback.ReplaceDep<VentusData, FlowPath, WindProfile, WindProfile>((vd, src) -> (WindProfile)src.get(prop), (vd, src, ref) -> {
        src.insertUndoEntry_propRestore(prop);
        src.insertUndoEntry_propRestore(CONSTANT_WIND_PRESSURE);
    }, (vd, src, newVal) -> {
        src.set(prop, newVal);
        if (newVal == null) {
            src.set(CONSTANT_WIND_PRESSURE, true);
        }
    }, (vd, src, val, old, repl) -> repl))).attrFinish();
    public static final TypedProp<UnitDouble> WIND_PRESSURE = TypedProps.build((Object)"FlowPath.WIND_PRESSURE", new UnitDouble(0.0, SI.PASCAL)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> AZIMUTH = TypedProps.build((Object)"FlowPath.AZIMUTH", new UnitDouble(0.0, NonSI.DEGREE_ANGLE)).attrStoreAsReadOnly(PROP_TYPES).attrGetter(FlowPath::getWallAzimuth, START_COMP, START_WALL).attrFinish();
    public static final TypedProp<UnitDouble> RELATIVE_ELEVATION = TypedProps.build((Object)"FlowPath.RELATIVE_ELEVATION", new UnitDouble(0.0, SI.METER)).attrStoreAsWrapper(PROP_TYPES).attrGetter(FlowPath::getRelativeElevation, START_LOCATION, START_COMP, START_WALL).attrSetter(FlowPath::setRelativeElevation).attrFinish();
    public static final TypedProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    @Deprecated
    private static final TypedProp<Set<Tag>> LEGACY_TAGS = TypedProps.buildGeneric("FlowPath.TAGS", Set.class, Collections.emptySet()).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> TagsUtil.newTagCallback(prop)).attrFinish();
    private static final TypedProp<FlowPathInitConnection> INIT_CXN_TYPE = TypedProps.build("FlowPath.INIT_CXN_TYPE", FlowPathInitConnection.class, FlowPathInitConnection.UnSet).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final SchematicRoom AMBIENT_ZONE = new SchematicRoom(Intl.intl("AMBIENT"));
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();
    public static final Pair<ISchematicRoom, ISchematicRoom> INVALID_ZONES = new Pair<SchematicRoom, SchematicRoom>(AMBIENT_ZONE, AMBIENT_ZONE);
    private static final Color CONNECTED_WALL_COLOR = new Color(116, 166, 158);

    private static <ValT, PropT extends TypedProp<ValT>> BiConsumer<PropT, FlowPath> getTopoFireEvents() {
        return (p, fp) -> {
            fp.pauseUpdates();
            fp.changedEvt(p);
            fp.markTopoDirty();
            fp.resumeUpdates();
        };
    }

    public FlowPath(String name, FlowElement element) {
        super(name);
        this.set(FLOW_ELEMENT, element);
        this.set(OVERWRITE_MULTIPLIER, element.get(FlowElement.DEFAULT_TYPE) != FlowElementRoot.Default.AREA_AREA);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.d_transientProps = new PropertySet();
        this.moveSerializedToTransient(START_COMP);
        this.moveSerializedToTransient(END_COMP);
        int version = VentusOIS.getVersion(is);
        if (version <= VentusIO.Version.VER_0201.num) {
            this.fixUnitlessMultiplier();
        }
    }

    private <T> void moveSerializedToTransient(TypedProp<T> prop) {
        if (this.d_properties.isDefined(prop)) {
            this.d_transientProps.setIfNotDefault(prop, this.d_properties.get(prop));
            this.d_properties.remove(prop);
        }
    }

    public static <T> boolean has(TypedProp<T> prop) {
        return PROP_TYPES.has(prop);
    }

    public void setColor(Color color) {
        this.set(COLOR, color);
    }

    public Color getColor() {
        if (this.get(OVERWRITE_COLOR).booleanValue()) {
            return this.get(STORED_COLOR);
        }
        return this.get(FLOW_ELEMENT).get(FlowElement.COLOR);
    }

    private double getZProjectedLoc(ISchematicRoom room, Point3d loc) {
        Point3d proj = room.getZProjectedLoc(loc);
        if (proj != null) {
            return proj.z;
        }
        Floor level = room.getLevel();
        return level != null ? level.getWorkingZ().get(Geometry.LENGTH_UNIT) : loc.z;
    }

    public void setRelativeElevation(UnitDouble elevation) {
        Point3d startLocation = this.get(START_LOCATION);
        Point3d endLocation = this.get(END_LOCATION);
        ISchematicRoom startComp = this.get(START_COMP);
        ISchematicRoom endComp = this.get(END_COMP);
        if (startLocation == null || endLocation == null || startComp == null || endComp == null) {
            return;
        }
        double elev = elevation.get(Geometry.LENGTH_UNIT);
        BiFunction<ISchematicRoom, TypedProp, Double> clampElev = (room, edgeProp) -> {
            ISchematicRoom.IWallComponent wall = (ISchematicRoom.IWallComponent)this.get(edgeProp);
            if (wall == null) {
                return 0.0;
            }
            Floor level = FlowPathUtil.getLevel(room);
            return FlowPathUtil.clampRelativeElevation(elev, level);
        };
        TriFunction<ISchematicRoom, TypedProp, Point3d, Point3d> adjustElev = (room, edgeProp, loc) -> {
            double clampedElev = (Double)clampElev.apply((ISchematicRoom)room, (TypedProp)edgeProp);
            double minZ = this.getZProjectedLoc((ISchematicRoom)room, (Point3d)loc);
            Point3d result = new Point3d((Point3d)loc);
            result.z = minZ + clampedElev;
            return result;
        };
        startLocation = adjustElev.apply(startComp, START_WALL, startLocation);
        endLocation = adjustElev.apply(endComp, END_WALL, endLocation);
        this.pauseUpdates();
        this.setToPropertySet(START_LOCATION, startLocation);
        this.setToPropertySet(END_LOCATION, endLocation);
        this.resumeUpdates();
    }

    public UnitDouble getRelativeElevation() {
        Point3d startLocation = this.get(START_LOCATION);
        ISchematicRoom startComp = this.get(START_COMP);
        ISchematicRoom.IWallComponent startWall = this.get(START_WALL);
        if (startLocation == null || startComp == null || startWall == null) {
            return new UnitDouble(0.0, Geometry.LENGTH_UNIT);
        }
        double projZ = this.getZProjectedLoc(startComp, startLocation);
        double startElevation = startLocation.getZ() - projZ;
        return new UnitDouble(startElevation, Geometry.LENGTH_UNIT);
    }

    public UnitDouble getWallAzimuth() {
        ISchematicRoom startComp = this.get(START_COMP);
        ISchematicRoom.IWallComponent startEdge = this.get(START_WALL);
        if (startComp == null || startEdge == null) {
            return new UnitDouble(0.0, NonSI.DEGREE_ANGLE);
        }
        return new UnitDouble(FlowPathUtil.getWallAzimuth(startComp, startEdge), NonSI.DEGREE_ANGLE);
    }

    public boolean isInvalid() {
        Pair<ISchematicRoom, ISchematicRoom> zones = this.getZones();
        return zones.v1 == AMBIENT_ZONE && zones.v2 == AMBIENT_ZONE;
    }

    public boolean isWallPath() {
        return this.get(START_WALL) != null || this.get(END_WALL) != null;
    }

    public boolean isFloorPath() {
        return this.get(START_WALL) == null && this.get(START_COMP) == this.get(END_COMP);
    }

    public Collection<FlowPath> getConflicts() {
        ArrayList<FlowPath> conflicts;
        block7: {
            FlowElement element;
            block6: {
                element = this.getFlowElement();
                if (!element.get(FlowElement.POWERLAW_MODEL).equals((Object)FlowElement.PowerlawModel.LEAKAGE_AREA) || !element.get(FlowElement.LEAKAGE_AREA_TYPE).equals((Object)FlowElement.LeakageAreaType.AREA)) {
                    return Collections.emptyList();
                }
                conflicts = new ArrayList<FlowPath>();
                if (!this.isFloorPath()) break block6;
                ISchematicRoom startZone = this.get(START_COMP);
                if (startZone == null) {
                    return Collections.emptyList();
                }
                Collection<FlowPath> flowPaths = startZone.getConnections(FlowPath.class);
                if (flowPaths.isEmpty() || flowPaths.size() == 1 && flowPaths.iterator().next() == this) {
                    return Collections.emptyList();
                }
                Pair<ISchematicRoom, ISchematicRoom> zones = this.getZones();
                for (FlowPath fp : flowPaths) {
                    if (fp.equals(this) || !fp.isFloorPath() || !fp.getFlowElement().equals(element) || !zones.equals(fp.getZones())) continue;
                    conflicts.add(fp);
                }
                break block7;
            }
            if (!this.isWallPath()) break block7;
            Pair<ISchematicRoom, ISchematicRoom> zones = this.getZones();
            ISchematicRoom startZone = (ISchematicRoom)zones.v1;
            for (FlowPath fp : startZone.getConnections(FlowPath.class)) {
                if (fp.equals(this) || !fp.isWallPath() || !fp.getFlowElement().equals(element)) continue;
                Connection start = fp.getConnection(startZone);
                assert (start != null);
                if (start == null) continue;
                Connection end = start.opposite();
                if (this.get(START_COMP) != fp.get(start.comp) || this.get(END_COMP) != fp.get(end.comp) || !Objects.equals(this.get(START_WALL), fp.get(start.wall)) || !Objects.equals(this.get(END_WALL), fp.get(end.wall)) || zones.v1 != fp.get(start.zone) || zones.v2 != fp.get(end.zone)) continue;
                conflicts.add(fp);
            }
        }
        return conflicts;
    }

    public Pair<ISchematicRoom, ISchematicRoom> getZones() {
        ISchematicRoom startComp = this.get(START_COMP);
        ISchematicRoom endComp = this.get(END_COMP);
        if (startComp == null || endComp == null) {
            return INVALID_ZONES;
        }
        if (this.isFloorPath()) {
            if (this.getDomain() == null) {
                return INVALID_ZONES;
            }
            endComp = FlowPathUtil.getRoomBelow((VentusData)this.getDomain(), startComp, this.get(START_LOCATION));
            if (endComp == null) {
                endComp = AMBIENT_ZONE;
            }
            if (startComp.getType() == ISchematicRoom.Type.CEILING) {
                startComp = endComp;
                endComp = AMBIENT_ZONE;
            }
            return new Pair<ISchematicRoom, ISchematicRoom>(startComp, endComp);
        }
        ISchematicRoom.IWallComponent startWall = this.get(START_WALL);
        if (startWall != null && startComp == endComp) {
            return new Pair<ISchematicRoom, ISchematicRoom>(startComp, AMBIENT_ZONE);
        }
        ISchematicRoom.IWallComponent endWall = this.get(END_WALL);
        if (startWall != null && endWall != null) {
            return new Pair<ISchematicRoom, ISchematicRoom>(startComp, endComp);
        }
        return INVALID_ZONES;
    }

    public Pair<ISchematicRoom, ISchematicRoom> getZonesByDirection() {
        Pair<ISchematicRoom, ISchematicRoom> zones = this.getZones();
        return this.get(DIRECTION) != false ? zones : FlowPathUtil.reverse(zones);
    }

    public ISchematicRoom getStartZone() {
        return (ISchematicRoom)this.getZones().v1;
    }

    public ISchematicRoom getEndZone() {
        return (ISchematicRoom)this.getZones().v2;
    }

    public boolean isExterior() {
        Pair<ISchematicRoom, ISchematicRoom> zones = this.getZones();
        return FlowPath.isExterior(zones);
    }

    public static boolean isExterior(Pair<ISchematicRoom, ISchematicRoom> zones) {
        return zones.v1 != null && zones.v2 != null && ((ISchematicRoom)zones.v1).equals(AMBIENT_ZONE) ^ ((ISchematicRoom)zones.v2).equals(AMBIENT_ZONE);
    }

    public void setFlowElement(FlowElement newElement) {
        this.setFlowElement(newElement, true);
    }

    protected void setFlowElement(FlowElement newElement, boolean useOverwriteMultHint) {
        FlowElement oldElement = this.get(STORED_FLOW_ELEMENT);
        if (oldElement == newElement) {
            return;
        }
        this.pauseUpdates();
        this.set(STORED_FLOW_ELEMENT, newElement);
        if (useOverwriteMultHint && newElement != null) {
            this.set(OVERWRITE_MULTIPLIER, newElement.isLeakageAreaPerItem());
        }
        this.resumeUpdates();
    }

    public FlowElement getFlowElement() {
        return this.get(STORED_FLOW_ELEMENT);
    }

    private void fixUnitlessMultiplier() {
        Object mult = this.d_properties.getMap().get(FlowPath.STORED_MULTIPLIER.key);
        if (!(mult instanceof Double)) {
            return;
        }
        FlowElement fe = this.getFlowElement();
        FlowElement.LeakageAreaType laType = fe.get(FlowElement.LEAKAGE_AREA_TYPE);
        FlowElement.LeakageAreaTypeInfo laTypeInfo = new FlowElement.LeakageAreaTypeInfo(laType);
        Unit lenUnit = this.getRelativeElevation().getUnit();
        laTypeInfo.exec(() -> this.set(STORED_MULTIPLIER, new UnitDouble((Double)mult, Unit.ONE)), () -> this.set(STORED_MULTIPLIER, new UnitDouble((Double)mult, lenUnit)), () -> this.set(STORED_MULTIPLIER, new UnitDouble((Double)mult, lenUnit.pow(2))));
    }

    private boolean isValidOverwriteMultiplier() {
        if (!this.d_properties.isDefined(STORED_MULTIPLIER)) {
            return false;
        }
        FlowElement fe = this.getFlowElement();
        UnitDouble value = this.get(STORED_MULTIPLIER);
        if (fe.get(FlowElement.POWERLAW_MODEL) == FlowElement.PowerlawModel.LEAKAGE_AREA) {
            FlowElement.LeakageAreaType laType = fe.get(FlowElement.LEAKAGE_AREA_TYPE);
            FlowElement.LeakageAreaTypeInfo laTypeInfo = new FlowElement.LeakageAreaTypeInfo(laType);
            return laTypeInfo.get(() -> Unit.ONE.isCompatible(value.getUnit()), () -> SI.METER.isCompatible(value.getUnit()), () -> SI.METER.pow(2).isCompatible(value.getUnit()));
        }
        return Unit.ONE.isCompatible(value.getUnit());
    }

    public UnitDouble getMultiplier() {
        return (UnitDouble)this.getMultiplierInfo().v1;
    }

    public Pair<UnitDouble, IGeom> getMultiplierInfo() {
        if (this.get(OVERWRITE_MULTIPLIER).booleanValue() && this.isValidOverwriteMultiplier()) {
            return new Pair<UnitDouble, IGeom>(this.get(STORED_MULTIPLIER), EmptyGeom.INSTANCE);
        }
        FlowElement fe = this.getFlowElement();
        if (fe.get(FlowElement.POWERLAW_MODEL) != FlowElement.PowerlawModel.LEAKAGE_AREA) {
            return new Pair<UnitDouble, IGeom>(new UnitDouble(1.0, Unit.ONE), EmptyGeom.INSTANCE);
        }
        boolean direction = this.get(DIRECTION);
        Connection c1 = direction ? Connection.START : Connection.END;
        Connection c2 = direction ? Connection.END : Connection.START;
        ISchematicRoom startComp = this.get(c1.comp);
        ISchematicRoom endComp = this.get(c2.comp);
        if (startComp == null || endComp == null) {
            return new Pair<UnitDouble, IGeom>(new UnitDouble(1.0, Unit.ONE), EmptyGeom.INSTANCE);
        }
        Function<QuadFunction, Pair> calcMult = compute -> {
            Point3d searchLocation;
            Vector3d projectionDir;
            TriFunction<ISchematicRoom, ISchematicRoom.IWallComponent, Point3d, Model> getModel = (room, wall, pt) -> {
                Pair<Model, Face> nmt;
                if (wall == null) {
                    return room.getModel();
                }
                ISchematicRoom.IPatch patch = FlowPath.subdivide((VentusData)this.getDomain(), room, wall, pt);
                Pair<Model, Face> pair = nmt = patch != null ? patch.toNmt((ISchematicRoom)room, false) : wall.toNmt((ISchematicRoom)room, false);
                if (nmt == null) {
                    return null;
                }
                if (((Model)nmt.v1).getFaces().size() == 1) {
                    return (Model)nmt.v1;
                }
                Model tmodel = new Model();
                tmodel.addFace((Face)nmt.v2);
                return tmodel;
            };
            Point3d startLocation = this.get(c1.location);
            ArrayList<Model> models = new ArrayList<Model>();
            ISchematicRoom.IWallComponent startWall = this.get(c1.wall);
            ISchematicRoom.IWallComponent endWall = this.get(c2.wall);
            Model startModel = getModel.apply(startComp, startWall, startLocation);
            if (startModel == null) {
                return new Pair<Double, EmptyGeom>(0.0, EmptyGeom.INSTANCE);
            }
            if (startWall != null && endWall != null) {
                Face startFace = startModel.getFaces().iterator().next();
                boolean[] thisAdded = new boolean[]{false};
                List<FlowPath> sibs = FlowPathUtil.getFlowPaths(startComp, startWall);
                BiConsumer<FlowPath, Connection> addOtherWall = (fp, otherSide) -> {
                    Point3d ptOnStartRoom = fp.get(otherSide.opposite().location);
                    if (fp != this && startModel.testPointOnFace((Face)startFace, (Point3d)ptOnStartRoom).outside) {
                        return;
                    }
                    Model model = (Model)getModel.apply(fp.get(otherSide.comp), fp.get(otherSide.wall), fp.get(otherSide.location));
                    if (model != null) {
                        if (fp == this) {
                            thisAdded[0] = true;
                        }
                        models.add(model);
                    }
                };
                for (FlowPath fp2 : sibs) {
                    ISchematicRoom.IWallComponent wall1 = fp2.get(START_WALL);
                    ISchematicRoom.IWallComponent wall2 = fp2.get(END_WALL);
                    if (!wall1.equals(startWall)) {
                        addOtherWall.accept(fp2, Connection.START);
                    }
                    if (wall2.equals(startWall)) continue;
                    addOtherWall.accept(fp2, Connection.END);
                }
                projectionDir = null;
                searchLocation = thisAdded[0] && models.size() == 1 ? null : startLocation;
            } else if (startWall == null && endWall == null) {
                models.addAll(FlowPathUtil.getRoomsBelow(startComp).stream().map(ISchematicRoom::getModel).toList());
                projectionDir = Util3D.VEC3D_ZPOS;
                searchLocation = startLocation;
            } else {
                projectionDir = null;
                searchLocation = startLocation;
            }
            return (Pair)compute.apply(startModel, models, searchLocation, projectionDir);
        };
        FlowElement.LeakageAreaType laType = fe.get(FlowElement.LEAKAGE_AREA_TYPE);
        FlowElement.LeakageAreaTypeInfo laTypeInfo = new FlowElement.LeakageAreaTypeInfo(laType);
        return laTypeInfo.get(() -> new Pair<UnitDouble, EmptyGeom>(new UnitDouble(1.0, Unit.ONE), EmptyGeom.INSTANCE), () -> {
            Pair lengthM = (Pair)calcMult.apply(FlowPathUtil::getLengthInfo);
            return new Pair<UnitDouble, IGeom>(new UnitDouble((Double)lengthM.v1, SI.METER), (IGeom)lengthM.v2);
        }, () -> {
            Pair areaM2 = (Pair)calcMult.apply(FlowPathUtil::getAreaInfo);
            return new Pair<UnitDouble, IGeom>(new UnitDouble((Double)areaM2.v1, SI.METER.pow(2)), (IGeom)areaM2.v2);
        });
    }

    private static ISchematicRoom.IPatch subdivide(VentusData vd, ISchematicRoom srcRoom, ISchematicRoom.IWallComponent wall, Point3d fpPoint) {
        if (vd == null) {
            return wall;
        }
        AABox wallSearch = wall.getBounds(srcRoom);
        Collection<ISchematicRoom> nearRooms = vd.geomLocation.getLocator().find((ITest<AABox>)wallSearch, ISchematicRoom.class, r -> r != srcRoom, 1);
        Collection<? extends ISchematicRoom.IPatch> patch = wall.subdivide(srcRoom, fpPoint, nearRooms);
        return patch.isEmpty() ? null : patch.iterator().next();
    }

    public void setStartLocation(ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.setLocation(Connection.START, comp, normal, location, wall);
    }

    public void setEndLocation(ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.setLocation(Connection.END, comp, normal, location, wall);
    }

    public void setLocation(Connection connection, ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.pauseUpdates();
        this.setToPropertySet(connection.comp, comp);
        this.setToPropertySet(connection.normal, normal);
        this.setToPropertySet(connection.location, location);
        this.setToPropertySet(connection.wall, wall);
        this.resumeUpdates();
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof FlowPathGeometry) {
            FlowPathGeometry fpg = (FlowPathGeometry)geom;
            this.pauseUpdates();
            this.set(START_LOCATION, (Point3d)fpg.locations.v1);
            this.set(END_LOCATION, (Point3d)fpg.locations.v2);
            this.resumeUpdates();
        } else assert (false) : "Unable to update model from unknown geom.";
    }

    private void markTopoDirty() {
        this.changedEvt(VentusData.TOPOLOGY);
    }

    public FlowPathGeometry getCustomGeom() {
        return new FlowPathGeometry(new Pair<Vector3d, Vector3d>(this.get(START_NORMAL), this.get(END_NORMAL)), new Pair<Point3d, Point3d>(this.get(START_LOCATION), this.get(END_LOCATION)), this.isExterior(), this.get(SIZE).getValue(SI.METER), true);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getCustomGeom());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    protected void addToDomain(VentusData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        domain.getEvents().addObserverInDomain((IEventObserver)this, FlowElement.class, false, false, FlowElement.COLOR);
    }

    @Override
    protected void removeFromDomain(VentusData domain, IMerlinObj parent) {
        domain.getEvents().removeObserverInDomain(this);
        super.removeFromDomain(domain, parent);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (props instanceof IMerlinDispProps) {
            IMerlinDispProps ventusProps = (IMerlinDispProps)props;
            FlowPathGeometry fpGeom = this.getCustomGeom();
            Pair<IGeomNode, IPropsSrc> data = fpGeom.getRenderData(this, ventusProps);
            return new DisplayGeom((IGeomNode)data.v1, (IPropsSrc)data.v2);
        }
        return DisplayGeom.EMPTY;
    }

    @Override
    public boolean isVisible() {
        return this.get(VISIBILITY);
    }

    @Override
    public void setVisible(boolean visible) {
        this.set(VISIBILITY, visible);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        ArrayList<ISchematicObj> conns = new ArrayList<ISchematicObj>(2);
        if (this.get(START_COMP) != null) {
            conns.add(this.get(START_COMP));
        }
        if (this.get(END_COMP) != null) {
            conns.add(this.get(END_COMP));
        }
        return conns;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return this.get(START_COMP) == null || this.get(END_COMP) == null || this.get(START_COMP) == this.get(END_COMP);
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
        if (conn == this.get(START_COMP)) {
            this.clearConnection(Connection.START);
        }
        if (conn == this.get(END_COMP)) {
            this.clearConnection(Connection.END);
        }
    }

    private void clearConnection(Connection conn) {
        this.pauseUpdates();
        this.set(conn.comp, null);
        this.set(conn.wall, (ISchematicRoom.IWallComponent)conn.wall.defVal);
        this.resumeUpdates();
    }

    @Override
    public void connectTo(ISchematicObj conn) {
    }

    private Collection<GeomUtil.FindResult> findRooms(Connection cprops) {
        Point3d location = this.get(cprops.location);
        ArrayList<GeomUtil.FindResult> isects = new ArrayList<GeomUtil.FindResult>();
        GeomUtil.findRooms((VentusData)this.getDomain(), location, 1, () -> {}, isects::add);
        Collections.sort(isects, (i1, i2) -> Double.compare(i1.p.distanceSquared(location), i2.p.distanceSquared(location)));
        return isects;
    }

    @Override
    public boolean updateTopo() {
        this.pauseUpdates();
        BiConsumer<Connection, GeomUtil.FindResult> updateTopo = (conn, found) -> this.setLocation((Connection)((Object)conn), found.room, found.faceNormal, found.p, found.getWall().orElse(null));
        Collection<GeomUtil.FindResult> found1 = this.findRooms(Connection.START);
        Collection<GeomUtil.FindResult> found2 = this.findRooms(Connection.END);
        if (found1.isEmpty()) {
            this.clearConnection(Connection.START);
        }
        if (found2.isEmpty()) {
            this.clearConnection(Connection.END);
        }
        if (!found1.isEmpty() && !found2.isEmpty()) {
            BiPredicate<GeomUtil.FindResult, GeomUtil.FindResult> isValidConnection = (c1, c2) -> {
                if (c1.room != c2.room) {
                    return true;
                }
                if (c1.getWall().isPresent() != c2.getWall().isPresent()) {
                    return false;
                }
                if (c1.getWall().isEmpty()) {
                    return c1.room == c2.room && c1.p.epsilonEquals(c2.p, 1.0E-9);
                }
                return c1.room != c2.room || c1.getWall().get().equals(c2.getWall().get()) && c1.p.epsilonEquals(c2.p, 1.0E-9);
            };
            Vector3d prevNorm1 = this.get(START_NORMAL);
            Vector3d prevNorm2 = this.get(END_NORMAL);
            ArrayList<Pair<GeomUtil.FindResult, GeomUtil.FindResult>> pairs = new ArrayList<Pair<GeomUtil.FindResult, GeomUtil.FindResult>>();
            for (GeomUtil.FindResult r1 : found1) {
                for (GeomUtil.FindResult r2 : found2) {
                    pairs.add(new Pair<GeomUtil.FindResult, GeomUtil.FindResult>(r1, r2));
                }
            }
            Pair best = (Pair)pairs.stream().min((p1, p2) -> {
                boolean diffRooms2;
                boolean valid2;
                boolean valid1 = isValidConnection.test((GeomUtil.FindResult)p1.v1, (GeomUtil.FindResult)p1.v2);
                if (valid1 != (valid2 = isValidConnection.test((GeomUtil.FindResult)p2.v1, (GeomUtil.FindResult)p2.v2))) {
                    return valid1 ? -1 : 1;
                }
                boolean diffRooms1 = ((GeomUtil.FindResult)p1.v1).room != ((GeomUtil.FindResult)p1.v2).room;
                boolean bl = diffRooms2 = ((GeomUtil.FindResult)p2.v1).room != ((GeomUtil.FindResult)p2.v2).room;
                if (diffRooms1 != diffRooms2) {
                    return diffRooms1 ? -1 : 1;
                }
                double normalScore1 = 2.0 * prevNorm1.dot(((GeomUtil.FindResult)p1.v1).faceNormal) + prevNorm2.dot(((GeomUtil.FindResult)p1.v2).faceNormal);
                double normalScore2 = 2.0 * prevNorm1.dot(((GeomUtil.FindResult)p2.v1).faceNormal) + prevNorm2.dot(((GeomUtil.FindResult)p2.v2).faceNormal);
                return Double.compare(normalScore2, normalScore1);
            }).get();
            updateTopo.accept(Connection.START, (GeomUtil.FindResult)best.v1);
            updateTopo.accept(Connection.END, (GeomUtil.FindResult)best.v2);
        } else if (!found1.isEmpty()) {
            updateTopo.accept(Connection.START, found1.iterator().next());
        } else if (!found2.isEmpty()) {
            updateTopo.accept(Connection.END, found2.iterator().next());
        }
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
        return true;
    }

    @Override
    public void update(Events events) {
        if (events.isChanged(this.get(FLOW_ELEMENT), FlowElement.COLOR)) {
            this.changedEvt(FLOW_ELEMENT, COLOR);
        }
    }

    public Connection getConnection(ISchematicRoom zone) {
        Pair<ISchematicRoom, ISchematicRoom> zones = this.getZones();
        if (zones.v1 == zone) {
            return Connection.START;
        }
        if (zones.v2 == zone) {
            return Connection.END;
        }
        return null;
    }

    public Set<Tag> getTags() {
        return this.get(TAGS);
    }

    public void setTags(Set<Tag> tags) {
        this.set(TAGS, tags);
    }

    @Deprecated
    public Set<Tag> getLegacyTags() {
        return this.d_properties.get(LEGACY_TAGS);
    }

    public FlowPathInitConnection getInitialConnType() {
        if (Objects.equals(this.get(INIT_CXN_TYPE), FlowPathInitConnection.UnSet)) {
            this.updateInitialConnectionType();
        }
        return this.get(INIT_CXN_TYPE);
    }

    public void updateInitialConnectionType() {
        if (this.getZones() != INVALID_ZONES) {
            FlowPathInitConnection type = this.isExterior() ? FlowPathInitConnection.IntExt : FlowPathInitConnection.IntInt;
            this.set(INIT_CXN_TYPE, type);
        }
    }

    @Override
    public void getRoomColors(ISchematicRoom room, BiConsumer<ISchematicRoom.IComponent, Color> compColor) {
        Consumer<Connection> testConnection = conn -> {
            ISchematicRoom.IWallComponent wall;
            if (room == this.get(conn.comp) && (wall = this.get(conn.wall)) != null) {
                compColor.accept(wall, CONNECTED_WALL_COLOR);
            }
        };
        testConnection.accept(Connection.START);
        testConnection.accept(Connection.END);
    }

    protected PropertyDefs<FlowPath> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public FlowPath clone() {
        return (FlowPath)super.clone();
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (VentusOIS.isPrior(ois, VentusIO.Version.VER_215)) {
            this.set(START_COMP, (ISchematicRoom)ois.readObject());
            this.set(END_COMP, (ISchematicRoom)ois.readObject());
        } else {
            super.readTopology(ois);
        }
    }

    public static final class Connection
    extends Enum<Connection> {
        public static final /* enum */ Connection START = new Connection(START_LOCATION, START_NORMAL, START_COMP, START_ZONE, START_WALL);
        public static final /* enum */ Connection END = new Connection(END_LOCATION, END_NORMAL, END_COMP, END_ZONE, END_WALL);
        public final TypedProp<Point3d> location;
        public final TypedProp<Vector3d> normal;
        public final TypedProp<ISchematicRoom> comp;
        public final TypedProp<ISchematicRoom> zone;
        public final TypedProp<ISchematicRoom.IWallComponent> wall;
        private static final /* synthetic */ Connection[] $VALUES;

        public static Connection[] values() {
            return (Connection[])$VALUES.clone();
        }

        public static Connection valueOf(String name) {
            return Enum.valueOf(Connection.class, name);
        }

        private Connection(TypedProp<Point3d> location, TypedProp<Vector3d> normal, TypedProp<ISchematicRoom> comp, TypedProp<ISchematicRoom> zone, TypedProp<ISchematicRoom.IWallComponent> wall) {
            this.location = location;
            this.normal = normal;
            this.comp = comp;
            this.zone = zone;
            this.wall = wall;
        }

        public Connection opposite() {
            switch (this.ordinal()) {
                case 0: {
                    return END;
                }
                case 1: {
                    return START;
                }
            }
            assert (false);
            return this;
        }

        private static /* synthetic */ Connection[] $values() {
            return new Connection[]{START, END};
        }

        static {
            $VALUES = Connection.$values();
        }
    }
}

