/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.Map;
import java.util.Objects;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.FloorOptions;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.geom.Geometry;
import ventus.io.contamx.PrjData;

public class FlowElementPrjWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.NORMAL;
    }

    public double getLevelHeight(VentusData md) {
        FloorOptions floorSort = Objects.requireNonNull(md.floorOptions);
        return floorSort.get(FloorOptions.MIN_AUTO_FLOOR_DIST).get(Geometry.LENGTH_UNIT);
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        FlowElementRoot root = (FlowElementRoot)md.getComponentData(FlowElementData.GUID);
        for (FlowElement in : root.flatten(FlowElement.class)) {
            PrjData.AirFlowElem out = new PrjData.AirFlowElem(in);
            prjData.airFlowList.add(out);
            out.nr = prjData.nafe = prjData.airFlowList.size();
            out.type = in.getPowerlawModelType();
            out.name = in.getName();
            out.desc = "";
            if (in.get(FlowElement.POWERLAW_MODEL) == FlowElement.PowerlawModel.ORIFICE_AREA) {
                PrjData.AirFlowTypePlrOrf outPlrOrf = new PrjData.AirFlowTypePlrOrf();
                prjData.plrOrfMap.put(out.nr, outPlrOrf);
                outPlrOrf.lam = in.getLaminarFlow();
                outPlrOrf.turb = in.getTurbulentFlow();
                outPlrOrf.expt = in.get(FlowElement.PRESSURE_EXPONENT);
                outPlrOrf.area = in.get(FlowElement.CROSS_SECTIONAL_AREA).getValue(SI.METER.pow(2));
                outPlrOrf.dia = FlowElement.areaToDiameter(in.get(FlowElement.CROSS_SECTIONAL_AREA)).getValue(SI.METER);
                outPlrOrf.coef = in.get(FlowElement.DISCHARGE_COEFFICIENT);
                outPlrOrf.Re = in.get(FlowElement.REYNOLDS_NUMBER);
                outPlrOrf.uA = 0;
                outPlrOrf.uD = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == FlowElement.PowerlawModel.LEAKAGE_AREA) {
                PrjData.AirFlowTypePlrLeakArea outLeakArea = new PrjData.AirFlowTypePlrLeakArea();
                prjData.plrLeakAreaMap.put(out.nr, outLeakArea);
                outLeakArea.lam = in.getLaminarFlow();
                outLeakArea.turb = in.getTurbulentFlow();
                outLeakArea.expt = in.get(FlowElement.PRESSURE_EXPONENT);
                outLeakArea.coef = in.get(FlowElement.DISCHARGE_COEFFICIENT);
                outLeakArea.pres = in.get(FlowElement.PRESSURE_DIFFERENCE).get(SI.PASCAL);
                Unit unitArea1 = SI.METER.pow(2);
                outLeakArea.area1 = in.get(FlowElement.LEAKAGE_AREA_PER_ITEM).get(unitArea1);
                BaseUnit unitArea2 = SI.METER;
                outLeakArea.area2 = in.get(FlowElement.LEAKAGE_AREA_PER_LENGTH).get(unitArea2);
                Unit unitArea3 = Unit.ONE;
                outLeakArea.area3 = in.get(FlowElement.LEAKAGE_AREA_PER_AREA).get(unitArea3);
                outLeakArea.uA1 = 0;
                outLeakArea.uA2 = 0;
                outLeakArea.uA3 = 0;
                outLeakArea.udP = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == FlowElement.PowerlawModel.STAIRWELL) {
                PrjData.AirFlowTypePlrStair outPlrStair = new PrjData.AirFlowTypePlrStair();
                prjData.plrStairMap.put(out.nr, outPlrStair);
                outPlrStair.lam = in.getLaminarFlow();
                outPlrStair.turb = in.getTurbulentFlow();
                outPlrStair.expt = in.get(FlowElement.PRESSURE_EXPONENT);
                outPlrStair.Ht = in.get(FlowElement.STAIR_SHAFT_DZ).get(SI.METER);
                outPlrStair.area = in.get(FlowElement.CROSS_SECTIONAL_AREA).getValue(SI.METER.pow(2));
                outPlrStair.peo = 0;
                outPlrStair.tread = in.get(FlowElement.STAIR_TREADS_OPEN) != false ? 1 : 0;
                outPlrStair.uA = 0;
                outPlrStair.uD = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) == FlowElement.PowerlawModel.SHAFT) {
                PrjData.AirFlowTypePlrShaft outPlrShaft = new PrjData.AirFlowTypePlrShaft();
                prjData.plrShaftMap.put(out.nr, outPlrShaft);
                outPlrShaft.lam = in.getLaminarFlow();
                outPlrShaft.turb = in.getTurbulentFlow();
                outPlrShaft.expt = in.get(FlowElement.PRESSURE_EXPONENT);
                outPlrShaft.Ht = in.get(FlowElement.STAIR_SHAFT_DZ).get(SI.METER);
                outPlrShaft.area = in.get(FlowElement.CROSS_SECTIONAL_AREA).getValue(SI.METER.pow(2));
                outPlrShaft.perim = in.get(FlowElement.PERIMETER).getValue(SI.METER);
                outPlrShaft.rough = in.get(FlowElement.ROUGHNESS).getValue(SI.METER);
                outPlrShaft.uA = 0;
                outPlrShaft.uD = 0;
                outPlrShaft.uP = 0;
                outPlrShaft.uR = 0;
                continue;
            }
            if (in.get(FlowElement.POWERLAW_MODEL) != FlowElement.PowerlawModel.SELF_REG_VENT) continue;
            PrjData.AirFlowTypeSelfRegulatingVent selfRegulatingVent = new PrjData.AirFlowTypeSelfRegulatingVent();
            prjData.selfRegulatingVentMap.put(out.nr, selfRegulatingVent);
            selfRegulatingVent.maxFlowRate = in.get(FlowElement.MAX_FLOW_RATE).getValue(SI.METER.pow(3).divide(SI.SECOND));
            selfRegulatingVent.regulatingPressure = in.get(FlowElement.REGULATING_PRESSURE).getValue(SI.PASCAL);
            selfRegulatingVent.reverseFlowFraction = in.get(FlowElement.REVERSE_FLOW_FRACTION).getValue(Unit.ONE);
            selfRegulatingVent.uF = 0;
            selfRegulatingVent.uP = 0;
        }
    }
}

