/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementEditor;
import ventus.feature.flowpaths.FlowElementManager;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.gui.ManagerDlg;
import ventus.unitsystem.UnitSystem;

public class FlowElementMgrDlg
extends ManagerDlg<FlowElement, FlowElementManager> {
    private static final long serialVersionUID = 1L;
    private final FlowElementEditor d_editor;
    private FlowElementManager d_manager;

    public FlowElementMgrDlg(JFrame owner, UnitSystem us) {
        super(owner, Intl.intl("Edit Flow Elements"), FlowElement.class);
        this.d_editor = new FlowElementEditor(us);
        this.createActions();
        this.updateActions();
    }

    private void createActions() {
        this.addAction(new guiAction(Intl.intl("New..."), this::createNew));
        this.addAction(new ManagerDlg.LibraryAction(this, Intl.intl("Flow Element"), vd -> (FlowElementRoot)vd.getComponentData(FlowElementData.GUID), "lib/flowelement", "flowelement"));
        this.addAction(new guiAction(Intl.intl("Duplicate..."), this::duplicate));
        this.addAction(new ManagerDlg.RenameAction(this, FlowElement.NAME), x$0 -> super.canRename(x$0));
        this.addAction(new ManagerDlg.DeleteAction(this), x$0 -> super.canDelete(x$0));
    }

    public void init(VentusData data, FlowElementManager manager, FlowElement node) {
        super.init(data, manager, this.d_editor, FlowElementData.icon_contrast2_md);
        this.d_manager = manager;
        if (node == null) {
            this.getList().select(0);
            return;
        }
        this.getList().select(node);
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        FlowElementRoot root = this.d_manager.getRoot();
        NameGenerator ng = root.getNameGenerator();
        FlowElement.PowerlawModel initPlmFromSelected = this.getList().getSelectedItem() != null ? ((FlowElement)this.getList().getSelectedItem()).get(FlowElement.POWERLAW_MODEL) : FlowElement.PowerlawModel.ORIFICE_AREA;
        guiComboBox<FlowElement.PowerlawModel> modelBox = new guiComboBox<FlowElement.PowerlawModel>(FlowElement.PowerlawModel.values());
        modelBox.setSelectedItem((Object)initPlmFromSelected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(ng.generateValidName(Intl.intl("FlowElement")));
        guiPanel dlgPanel = new guiPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return FlowElementMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        dlgPanel.setLayout(new MigLayout("insets 0", "[left, grow][right]"));
        dlgPanel.add((Component)new guiLabel(Intl.intl("Name:")), "");
        dlgPanel.add((Component)nameField, "sg 1, wrap");
        dlgPanel.add((Component)new guiLabel(Intl.intl("Model:")), "");
        dlgPanel.add(modelBox, "sg 1, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Flow Element"), 9);
        dlg.setDialogComponent(dlgPanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            FlowElement element = new FlowElement(name, null, theUtil.newRandomColor(), modelBox.getSelectedItem());
            root.add(element);
            this.getList().updateModelView(this.d_manager);
        }
    }

    public void duplicate(ActionEvent event) {
        this.preSave();
        FlowElementRoot root = this.d_manager.getRoot();
        FlowElement selected = (FlowElement)this.getList().getSelectedItem();
        guiComboBox<FlowElement> basedOnComboBox = new guiComboBox<FlowElement>(this.d_manager.getSorted());
        basedOnComboBox.setSelectedItem(selected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(root.getNameGenerator().generateValidName(selected.getName()));
        basedOnComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1 && !nameField.isModified()) {
                FlowElement item = (FlowElement)evt.getItem();
                nameField.setText(root.getNameGenerator().generateValidName(item.getName()));
            }
        });
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return FlowElementMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        namePanel.add((Component)new guiLabel(Intl.intl("Based On:")), "growx");
        namePanel.add(basedOnComboBox, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("Duplicate Flow Element"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            FlowElement element = basedOnComboBox.getSelectedItem() != null ? basedOnComboBox.getSelectedItem().clone() : new FlowElement(name);
            element.setName(name);
            element.set(FlowElement.DESC, "");
            root.add(element);
            this.getList().updateModelView(this.d_manager);
        }
    }
}

