/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.ComponentSizeFixer;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPathMathUtil;
import ventus.gui.ManagerDlg;
import ventus.gui.guiUtil;
import ventus.unitsystem.UnitSystem;

public class FlowElementEditor
extends guiPanel
implements IEditor<FlowElement> {
    private static final long serialVersionUID = 1L;
    private final Bindings d_bindings = new Bindings();
    private final List<Consumer<FlowElement>> d_onInit = new ArrayList<Consumer<FlowElement>>();

    public FlowElementEditor(UnitSystem us) {
        super(new MigLayout("insets 0", "[left][grow][right]"));
        guiTextField name = this.d_bindings.bind(FlowElement.NAME, new guiTextField());
        name.setEnabled(false);
        guiTextField desc = this.d_bindings.bind(FlowElement.DESC, new guiTextField());
        ColorButton color = this.d_bindings.bind(FlowElement.COLOR, guiUtil.newColorButton());
        guiComboBox<FlowElement.PowerlawModel> cbPowerLaw = new guiComboBox<FlowElement.PowerlawModel>(FlowElement.PowerlawModel.values());
        this.d_bindings.bind(cbPowerLaw, new Binding<FlowElement>(data -> cbPowerLaw.setSelectedItem((Object)data.get(FlowElement.POWERLAW_MODEL)), data -> data.set(FlowElement.POWERLAW_MODEL, (FlowElement.PowerlawModel)((Object)((Object)cbPowerLaw.getSelectedItem())))));
        FlowElementEditor.addRow(this, Intl.intl("Name:"), null, name, "growx, wrap");
        FlowElementEditor.addRow(this, Intl.intl("Description:"), null, desc, "width pref*2.5, growx, wrap");
        FlowElementEditor.addRow(this, Intl.intl("Color:"), null, color, "sg 1, wrap");
        FlowElementEditor.addRow(this, Intl.intl("Model:"), null, cbPowerLaw, "sg 1, wrap");
        this.add((Component)new guiSeparator(), "growx, span, wrap");
        guiPanel cardsPanel = new guiPanel(new CardLayout());
        cardsPanel.add((Component)this.createCardOrificeArea(us), FlowElement.PowerlawModel.ORIFICE_AREA.toString());
        cardsPanel.add((Component)this.createCardLeakageArea(us), FlowElement.PowerlawModel.LEAKAGE_AREA.toString());
        cardsPanel.add((Component)this.createCardStairwell(us), FlowElement.PowerlawModel.STAIRWELL.toString());
        cardsPanel.add((Component)this.createCardShaft(us), FlowElement.PowerlawModel.SHAFT.toString());
        cardsPanel.add((Component)this.createCardSelfRegulatingVent(us), FlowElement.PowerlawModel.SELF_REG_VENT.toString());
        this.add((Component)cardsPanel, "grow, span, wrap");
        guiPanel coefficientPanel = new guiPanel(new MigLayout());
        ValueField<Double> coefLam = ValueFields.doubleFld();
        coefLam.setEditable(false);
        ValueField<Double> coefTurb = ValueFields.doubleFld();
        coefTurb.setEditable(false);
        this.add((Component)new guiSeparator(), "growx, span, wrap");
        FlowElementEditor.addRow(coefficientPanel, Intl.intl("Laminar Coefficient:"), null, coefLam, "sg 1, wrap");
        FlowElementEditor.addRow(coefficientPanel, Intl.intl("Turbulent Coefficient:"), null, coefTurb, "sg 1, wrap");
        this.add((Component)coefficientPanel, "grow, span, wrap");
        cbPowerLaw.addItemListener(evt -> {
            if (evt.getStateChange() == 1) {
                CardLayout cards = (CardLayout)cardsPanel.getLayout();
                cards.show(cardsPanel, ((FlowElement.PowerlawModel)((Object)((Object)evt.getItem()))).toString());
                coefficientPanel.setVisible(!evt.getItem().equals((Object)FlowElement.PowerlawModel.SELF_REG_VENT));
            }
        });
        ComponentSizeFixer.fromExistingContainer(this).setAllPreferredWidthToMax();
        final Runnable updateCoefs = () -> {
            if (this.validateData(false, false)) {
                FlowElement temp = new FlowElement("");
                this.d_bindings.store(temp);
                coefLam.setValue(temp.getLaminarFlow());
                coefTurb.setValue(temp.getTurbulentFlow());
            }
        };
        this.getComm().addObserver((src, arg) -> updateCoefs.run());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                updateCoefs.run();
                FlowElementEditor.this.setModified(false);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private guiPanel createCardOrificeArea(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> crossSectionalArea = this.d_bindings.bind(FlowElement.CROSS_SECTIONAL_AREA, ValueFields.udFld(UnitDoubleVR.above(0.0, SI.METER.pow(2), false), us.getArea()));
        ValueField<Double> pressureExponent = this.d_bindings.bind(FlowElement.PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.between(0.5, 1.0, true, true)));
        ValueField<Double> dischargeCoef = this.d_bindings.bind(FlowElement.DISCHARGE_COEFFICIENT, ValueFields.doubleFld(DoubleVR.between(0.1, 1.0, true, true)));
        ValueField<Double> reynoldsNumber = this.d_bindings.bind(FlowElement.REYNOLDS_NUMBER, ValueFields.doubleFld(DoubleVR.above(1.0, true)));
        FlowElementEditor.addRow(card, Intl.intl("Cross-Sectional Area:"), null, crossSectionalArea, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Flow Exponent:"), null, pressureExponent, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Discharge Coefficient:"), null, dischargeCoef, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Reynolds Number:"), null, reynoldsNumber, new String[0]);
        return card;
    }

    private guiPanel createCardLeakageArea(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0, hidemode 3", "[left][grow][fill, right]"));
        ValueField<Double> pressureExponent = this.d_bindings.bind(FlowElement.PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.between(0.5, 1.0, true, true)));
        ValueField<Double> dischargeCoef = this.d_bindings.bind(FlowElement.DISCHARGE_COEFFICIENT, ValueFields.doubleFld(DoubleVR.between(0.1, 1.0, true, true)));
        ValueField<UnitDouble> presDiff = this.d_bindings.bind(FlowElement.PRESSURE_DIFFERENCE, ValueFields.udFld(UnitDoubleVR.above(1.0, SI.PASCAL, true), us.getPressure()));
        guiComboBox<FlowElement.LeakageAreaType> leakAreaType = new guiComboBox<FlowElement.LeakageAreaType>(FlowElement.LeakageAreaType.values());
        this.d_bindings.bind(leakAreaType, new Binding<FlowElement>(data -> leakAreaType.setSelectedItem((Object)data.get(FlowElement.LEAKAGE_AREA_TYPE)), data -> data.set(FlowElement.LEAKAGE_AREA_TYPE, (FlowElement.LeakageAreaType)((Object)((Object)leakAreaType.getSelectedItem())))));
        ValueField<UnitDouble> leakAreaPerItem = this.d_bindings.bind(FlowElement.LEAKAGE_AREA_PER_ITEM, ValueFields.udFld(DoubleVR.above(0.0, false), us.getArea()));
        ValueField<UnitDouble> leakAreaPerLen = this.d_bindings.bind(FlowElement.LEAKAGE_AREA_PER_LENGTH, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> leakAreaPerArea = this.d_bindings.bind(FlowElement.LEAKAGE_AREA_PER_AREA, ValueFields.udFld(DoubleVR.above(0.0, false), us.getUnit(10)));
        String areaPerItem = String.format(Intl.intl("Area per Item (%s)"), us.getArea().toString() + "/" + Intl.intl("unit"));
        String areaPerLength = String.format(Intl.intl("Area per Unit Length (%s)"), us.getArea().toString() + "/" + us.getLength().toString());
        String areaPerArea = String.format(Intl.intl("Area per Unit Area (%s)"), us.getArea().toString() + "/" + us.getArea().toString());
        String areaTooltip = Intl.intl("Used with Flow Path multiplier.");
        FlowElementEditor.addRow(card, Intl.intl("Type:"), null, leakAreaType, new String[0]);
        List<Component> laPerItemComps = FlowElementEditor.addRow(card, areaPerItem, areaTooltip, leakAreaPerItem, new String[0]);
        List<Component> laPerLenComps = FlowElementEditor.addRow(card, areaPerLength, areaTooltip, leakAreaPerLen, new String[0]);
        List<Component> laPerAreaComps = FlowElementEditor.addRow(card, areaPerArea, areaTooltip, leakAreaPerArea, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Flow Exponent:"), null, pressureExponent, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Discharge Coefficient:"), null, dischargeCoef, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Pressure Difference:"), null, presDiff, new String[0]);
        Consumer<FlowElement.LeakageAreaType> updateFields = type -> {
            laPerItemComps.forEach(item -> item.setVisible(type == FlowElement.LeakageAreaType.ITEM));
            laPerLenComps.forEach(item -> item.setVisible(type == FlowElement.LeakageAreaType.LENGTH));
            laPerAreaComps.forEach(item -> item.setVisible(type == FlowElement.LeakageAreaType.AREA));
            card.revalidate();
            card.repaint();
        };
        leakAreaType.addItemListener(evt -> updateFields.accept((FlowElement.LeakageAreaType)((Object)((Object)leakAreaType.getSelectedItem()))));
        this.d_onInit.add(fe -> updateFields.accept((FlowElement.LeakageAreaType)((Object)((Object)leakAreaType.getSelectedItem()))));
        return card;
    }

    private guiPanel createCardStairwell(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> dz = this.d_bindings.bind(FlowElement.STAIR_SHAFT_DZ, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> crossSectionalArea = this.d_bindings.bind(FlowElement.CROSS_SECTIONAL_AREA, ValueFields.udFld(UnitDoubleVR.above(0.0, SI.METER.pow(2), false), us.getArea()));
        ValueField<Double> pressureExponent = ValueFields.doubleFld();
        this.d_bindings.bind(pressureExponent, new Binding<FlowElement>(fe -> pressureExponent.setValue(0.5), fe -> fe.set(FlowElement.PRESSURE_EXPONENT, 0.5)));
        pressureExponent.setEditable(false);
        ValueField<UnitDouble> peopleDens = this.d_bindings.bind(FlowElement.PEOPLE_DENSITY, ValueFields.udFld(DoubleVR.above(0.0, true), us.getPersonsDensity()));
        String stOpen = Intl.intl("Open");
        String stClosed = Intl.intl("Closed");
        guiComboBox<Object> stairTreads = new guiComboBox<Object>((T[])new Object[]{stOpen, stClosed});
        this.d_bindings.bind(stairTreads, new Binding<FlowElement>(data -> {
            Boolean value = data.get(FlowElement.STAIR_TREADS_OPEN);
            stairTreads.setSelectedItem(value != false ? stOpen : stClosed);
        }, data -> {
            String item = (String)stairTreads.getSelectedItem();
            data.set(FlowElement.STAIR_TREADS_OPEN, item == stOpen);
        }));
        FlowElementEditor.addRow(card, Intl.intl("Distance Between Levels:"), Intl.intl("Vertical distance between doorways of the stairwell."), dz, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Cross-Sectional Area:"), Intl.intl("Horizontal cross-section area of stairwell shaft."), crossSectionalArea, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Flow Exponent:"), Intl.intl("Exponent related to dynamic vs viscous effects."), pressureExponent, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("People Density:"), Intl.intl("People density influences flow resistance in stairwell."), peopleDens, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Stair Treads:"), Intl.intl("Indicate if the stair treads are open to flow."), stairTreads, new String[0]);
        return card;
    }

    private guiPanel createCardShaft(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> dz = this.d_bindings.bind(FlowElement.STAIR_SHAFT_DZ, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> crossSectionalArea = this.d_bindings.bind(FlowElement.CROSS_SECTIONAL_AREA, ValueFields.udFld(DoubleVR.above(0.0, false), us.getArea()));
        ValueField<UnitDouble> perimeter = this.d_bindings.bind(FlowElement.PERIMETER, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<UnitDouble> roughness = this.d_bindings.bind(FlowElement.ROUGHNESS, ValueFields.udFld(DoubleVR.above(0.0, false), us.getLength()));
        ValueField<Double> flowExponent = this.d_bindings.bind(FlowElement.PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.above(0.0, false)));
        flowExponent.setEditable(false);
        FlowElementEditor.addRow(card, Intl.intl("Distance Between Levels:"), Intl.intl("Vertical distance between shaft openings."), dz, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Cross-Sectional Shaft Area:"), Intl.intl("Horizontal cross-sectional area of the shaft, not the opening."), crossSectionalArea, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Perimeter:"), Intl.intl("Perimeter of shaft. Used with cross-sectional\narea to calculate hydraulic diameter."), perimeter, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Roughness:"), Intl.intl("Average size of protrusions from shaft wall into airflow."), roughness, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Flow Exponent:"), null, flowExponent, new String[0]);
        Arrays.asList(crossSectionalArea, perimeter, roughness).forEach(vf -> vf.addValueChangeListener(evt -> {
            if (card.validateData(false, false)) {
                FlowPathMathUtil.ShaftCalcOutput result = FlowPathMathUtil.getShaftData(((UnitDouble)dz.getValue()).get(SI.METER), ((UnitDouble)crossSectionalArea.getValue()).get(SI.METER.pow(2)), ((UnitDouble)perimeter.getValue()).get(SI.METER), ((UnitDouble)roughness.getValue()).get(SI.METER));
                flowExponent.setValue(result.flowExponent);
            }
        }));
        return card;
    }

    private guiPanel createCardSelfRegulatingVent(UnitSystem us) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> maxFlowRate = this.d_bindings.bind(FlowElement.MAX_FLOW_RATE, ValueFields.udFld(DoubleVR.above(0.0, false), us.getVolume().divide(us.getTime())));
        ValueField<UnitDouble> regulatingPressure = this.d_bindings.bind(FlowElement.REGULATING_PRESSURE, ValueFields.udFld(DoubleVR.above(0.0, false), us.getPressure()));
        ValueField<UnitDouble> reverseFlowFraction = this.d_bindings.bind(FlowElement.REVERSE_FLOW_FRACTION, ValueFields.udFld(DoubleVR.above(0.0, false), us.getUnit(10)));
        FlowElementEditor.addRow(card, Intl.intl("Max Flow Rate:"), Intl.intl("Maximum airflow rate allowed through paths using this element."), maxFlowRate, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Regulating Pressure:"), Intl.intl("Approximate pressure difference above which airflow will be limited to the maximum flow rate."), regulatingPressure, new String[0]);
        FlowElementEditor.addRow(card, Intl.intl("Reverse Flow Fraction:"), Intl.intl("Fraction of the Maximum Flow Rate that this element is limited to when the pressure difference is negative."), reverseFlowFraction, new String[0]);
        return card;
    }

    private static List<Component> addRow(guiPanel migPanel, String intl, String tooltip, Component comp, String ... compConstraints) {
        ArrayList<Component> comps = new ArrayList<Component>();
        guiLabel label = new guiLabel(intl);
        if (tooltip != null) {
            label.setToolTipText(tooltip);
        }
        comps.add(label);
        migPanel.add(label);
        Component glue = Box.createGlue();
        comps.add(glue);
        migPanel.add(glue, "");
        comps.add(comp);
        if (compConstraints.length > 0) {
            migPanel.add(comp, String.join((CharSequence)", ", compConstraints));
        } else {
            migPanel.add(comp, "wrap");
        }
        return comps;
    }

    @Override
    public void init(FlowElement dataObj) {
        ManagerDlg.defaultInit(this, dataObj, obj -> {
            this.d_bindings.load(dataObj);
            this.d_onInit.forEach(handler -> handler.accept(dataObj));
        });
    }

    @Override
    public FlowElement commit(FlowElement dataObj) {
        return ManagerDlg.defaultCommit(this, dataObj, Intl.intl("Edit Flow Element"), "FlowElementEditor.commit", obj -> this.d_bindings.store(dataObj));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private static class Bindings {
        private final Map<Component, Binding<FlowElement>> d_bindings = new HashMap<Component, Binding<FlowElement>>();

        public void load(FlowElement dataObj) {
            for (Binding<FlowElement> binding : this.d_bindings.values()) {
                binding.updateComp.accept(dataObj);
            }
        }

        public void store(FlowElement dataObj) {
            for (Map.Entry<Component, Binding<FlowElement>> entry : this.d_bindings.entrySet()) {
                Component comp = entry.getKey();
                if (!comp.isShowing() || !comp.isEnabled()) continue;
                entry.getValue().updateData.accept(dataObj);
            }
        }

        public <F extends Component> F bind(F comp, Binding binding) {
            this.d_bindings.put(comp, binding);
            return comp;
        }

        public <T, F extends Component> F bind(TypedProp<T> prop, F fld) {
            Binding<FlowElement> bindObj;
            if (fld instanceof guiTextField) {
                bindObj = new Binding<FlowElement>(data -> ((guiTextField)fld).setValue((String)data.get(prop)), data -> data.set(prop, ((guiTextField)fld).getValue()));
            } else if (fld instanceof ValueField) {
                bindObj = new Binding<FlowElement>(data -> ((ValueField)fld).setValue(data.get(prop)), data -> data.set(prop, ((ValueField)fld).getValue()));
            } else if (fld instanceof ColorButton) {
                bindObj = new Binding<FlowElement>(data -> ((ColorButton)fld).setColor((Color)data.get(prop)), data -> data.set(prop, ((ColorButton)fld).getColor()));
            } else {
                throw new IllegalArgumentException(fld.getClass().getName() + " not supported");
            }
            return this.bind(fld, bindObj);
        }
    }

    private static class Binding<T> {
        public final Consumer<T> updateComp;
        public final Consumer<T> updateData;

        public Binding(Consumer<T> updateComp, Consumer<T> updateData) {
            this.updateComp = updateComp;
            this.updateData = updateData;
        }
    }
}

