/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import javax.swing.ImageIcon;
import thunderheadeng.util.GroupedSequence;
import ventus.EntryPointFactory;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.feature.comps.IDataModel;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.gui.guiUtil;

class FlowElementData
implements IDataModel {
    public static String GUID = "flowelements.data";
    public static int SEQ_IX = 43;
    public static final ImageIcon icon_contrast2_sm = guiUtil.loadIconSvg(FlowElement.class.getResource("icons/contrast-2.svg"), 16);
    public static final ImageIcon icon_contrast2_md = guiUtil.loadIconSvg(FlowElement.class.getResource("icons/contrast-2.svg"), 32);

    FlowElementData() {
    }

    @Override
    public void init(VentusData md) {
        md.setComponentData(GUID, new FlowElementRoot());
    }

    @Override
    public void reset(VentusData md) {
        ((FlowElementRoot)md.getComponentData(GUID)).reset();
    }

    private static FlowElementRoot getDataRoot(VentusData md) {
        return (FlowElementRoot)md.getComponentData(GUID);
    }

    @Override
    public void loadFrom(VentusData src, VentusData dest) {
        FlowElementRoot srcData = FlowElementData.getDataRoot(src);
        FlowElementRoot destData = FlowElementData.getDataRoot(dest);
        destData.restoreFrom(srcData);
        dest.replaceInSel(srcData, destData);
    }

    @Override
    public void addTreeRoots(VentusData md, GroupedSequence roots) {
        roots.add(SEQ_IX, (Object)md.getComponentData(GUID));
    }

    @Override
    public void registerEntryPointData() {
        EntryPointHelper<FlowElementRoot> rootHelper = EntryPointHelper.rootEP(FlowElementRoot.class, icon_contrast2_sm);
        rootHelper.register();
        EntryPointHelper<FlowElementRoot.FlowElementNode> compHelper = EntryPointHelper.groupEP(GUID, FlowElementRoot.FlowElementNode.class, icon_contrast2_sm, Intl.intl("Flow Element Group"));
        compHelper.register();
        EntryPointHelper<FlowElement> nodeHelper = EntryPointHelper.objectEP(GUID, FlowElement.class, (md, obj, unused) -> {
            if (obj == null) {
                return icon_contrast2_sm;
            }
            return guiUtil.loadIconSvg(FlowElement.class.getResource("icons/contrast-2.svg"), obj.get(FlowElement.COLOR), 16);
        }, (md, obj) -> Intl.intl("Flow Element"));
        nodeHelper.getDomainRequiredType = EntryPointFactory.always(FlowElement.class);
        nodeHelper.getNameGroup = EntryPointFactory.nameGroup(vd -> FlowElementData.getDataRoot(vd).flatten(FlowElement.class));
        nodeHelper.register();
    }
}

