/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahssimple;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.gui.guiUtil;
import ventus.unitsystem.UnitSystem;

public class SimpleAHSEditor
extends guiPanel
implements IEditor<SimpleAHS> {
    private final guiTextField d_nameField = new guiTextField();
    private final guiTextField d_descriptionField = new guiTextField();
    private final ValueField<UnitDouble> d_minimumOAFlowField = ValueFields.udFld(UnitSystem.getType(17, false), UnitDoubleVR.ge(0.0, SI.KILOGRAM.divide(SI.SECOND)));

    public SimpleAHSEditor() {
        super(new MigLayout("insets 0", "[left][grow][right]"));
        SimpleAHSEditor.addRow(this, Intl.intl("Name:"), Intl.intl("Unique Simple Air Handling System Name."), this.d_nameField, "growx, wrap");
        SimpleAHSEditor.addRow(this, Intl.intl("Description:"), Intl.intl("Simple Air Handling System description."), this.d_descriptionField, "width pref*2.5, growx, wrap");
        this.add((Component)new guiSeparator(), "growx, span, wrap");
        SimpleAHSEditor.addRow(this, Intl.intl("Minimum OA Flow:"), Intl.intl("Simple Air Handling System Outdoor Air Flow."), this.d_minimumOAFlowField, "sg 1, wrap");
    }

    private static List<Component> addRow(guiPanel migPanel, String intl, String tooltip, Component comp, String ... compConstraints) {
        ArrayList<Component> comps = new ArrayList<Component>();
        guiLabel label = guiUtil.lblHtml(intl, tooltip);
        comps.add(label);
        migPanel.add(label);
        Component glue = Box.createGlue();
        comps.add(glue);
        migPanel.add(glue, "");
        comps.add(comp);
        if (compConstraints.length > 0) {
            migPanel.add(comp, String.join((CharSequence)", ", compConstraints));
        } else {
            migPanel.add(comp, "wrap");
        }
        return comps;
    }

    @Override
    public void init(SimpleAHS dataObj) {
        if (dataObj == null) {
            this.setEnabled(false);
            this.setModified(false);
            return;
        }
        this.d_nameField.setText(dataObj.getName());
        this.d_descriptionField.setText(dataObj.get(SimpleAHS.DESC));
        this.d_minimumOAFlowField.setValue(dataObj.get(SimpleAHS.MINIMUM_OA_FLOW));
        this.setEnabled(true);
        this.setModified(false);
    }

    @Override
    public SimpleAHS commit(final SimpleAHS dataObj) {
        this.setModified(false);
        if (dataObj == null) {
            return null;
        }
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                Undo.begin(Intl.intl("Edit Air Handling System"));
                try (VentusData.WriteLock lock = md.lockWrite();){
                    Undo.insertUndoEntry_restore(md, dataObj);
                    dataObj.setName(SimpleAHSEditor.this.d_nameField.getText());
                    dataObj.set(SimpleAHS.DESC, SimpleAHSEditor.this.d_descriptionField.getText());
                    dataObj.set(SimpleAHS.MINIMUM_OA_FLOW, (UnitDouble)SimpleAHSEditor.this.d_minimumOAFlowField.getValue());
                    Undo.end(md);
                }
            }
        };
        UIHook.run((Component)this, "SimpleAHSEditor.commit", op, 0);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

