/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import java.util.Map;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.FloorUtil;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.ahs.AHSRoot;
import ventus.feature.comps.IPrjDataWriter;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjUtil;

public class AHSPrjDataWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        AHSRoot ahsPointRoot = (AHSRoot)md.getComponentData("AHS.data");
        for (AHSPoint point : ahsPointRoot.flatten(AHSPoint.class)) {
            PrjData.AirFlowPath pointFP = new PrjData.AirFlowPath(point);
            pointFP.vntsDesc = point.getName();
            prjData.airFlowPathList.add(pointFP);
            pointFP.nr = prjData.airFlowPathList.size();
            pointFP.flags = 8;
            if (point.get(AHSPoint.TYPES) == AHSPoint.Types.RETURN) {
                pointFP.pzn = prjData.findZone((Object)point.get(AHSPoint.ROOM)).nr;
                pointFP.pzm = prjData.findAHS((Object)point.get(AHSPoint.AHS)).zoneR;
            }
            if (point.get(AHSPoint.TYPES) == AHSPoint.Types.SUPPLY) {
                pointFP.pzn = prjData.findAHS((Object)point.get(AHSPoint.AHS)).zoneS;
                pointFP.pzm = prjData.findZone((Object)point.get(AHSPoint.ROOM)).nr;
            }
            Pair<Integer, Double> multiplier = PrjUtil.maybeWriteSchedule(prjData, point.get(AHSPoint.MULTIPLIER), Unit.ONE);
            pointFP.pe = 0;
            pointFP.pf = 0;
            pointFP.pw = 0;
            pointFP.pa = prjData.findAHS((Object)point.get(AHSPoint.AHS)).nr;
            pointFP.ps = (Integer)multiplier.v1;
            pointFP.pc = 0;
            pointFP.pld = prjData.findLevel((Object)FloorUtil.getFloor((VentusData)md, (Object)point.get(AHSPoint.ROOM))).nr;
            pointFP.relHt = 0.0;
            pointFP.mult = 1.0;
            pointFP.Fahs = (Double)multiplier.v2 * point.get(AHSPoint.DESIGN_FLOW_RATE).getValue(SI.KILOGRAM.divide(SI.SECOND));
            pointFP.icon = 128;
            pointFP.dir = 2;
            pointFP.u_Ht = 0;
            pointFP.u_XY = 0;
            pointFP.u_dp = 0;
            pointFP.u_F = 0;
        }
    }
}

