/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import java.awt.Component;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.ahs.AHSRoot;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.ahssimple.SimpleAHSRoot;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.APropsDisplay;
import ventus.util.MerlinProps;

public class AHSPointBuilder
extends MerlinProps
implements IEventObserver {
    public static final Object COMPLETED = new Object();
    protected static final Object[] VALID_PROPS = new Object[]{AHSPoint.ROOM, AHSPoint.AHS};
    private final AHSPoint ahsPoint = new AHSPoint("");

    public AHSPointBuilder() {
        VentusApp.getAppData().getEvents().addObserver(this);
    }

    private SimpleAHS getDefaultSystem() {
        VentusData vd = VentusApp.getAppData();
        SimpleAHSRoot ahsRoot = (SimpleAHSRoot)vd.getComponentData("SimpleAHS.data");
        return ahsRoot != null ? ahsRoot.getDefault() : null;
    }

    @Override
    public void update(Events events) {
        IEventRecord<SimpleAHS> rec = events.getEvents(SimpleAHS.class, new Class[0]);
        if (rec.getRemovedObjs().contains(this.ahsPoint.get(AHSPoint.AHS))) {
            this.ahsPoint.set(AHSPoint.AHS, this.getDefaultSystem());
        } else if (!rec.getAddedObjs().isEmpty() && this.ahsPoint.get(AHSPoint.AHS) == null) {
            this.ahsPoint.set(AHSPoint.AHS, this.getDefaultSystem());
        }
    }

    public AHSPoint getAhsPoint() {
        return this.ahsPoint;
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (!this.lock()) {
            return;
        }
        try {
            this.ahsPoint.set((TypedProp)prop, val);
            this.firePropChanged(prop);
        }
        finally {
            this.release();
        }
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        if (!(prop instanceof TypedProp)) {
            return null;
        }
        if (AHSPoint.PROP_TYPES.has((TypedProp)prop)) {
            return this.ahsPoint.get((TypedProp)prop);
        }
        return super.get(prop);
    }

    public void setLocation(ISchematicRoom room, Vector3d normal, Point3d location) {
        this.pause();
        this.set(AHSPoint.ROOM, room);
        this.set(AHSPoint.LOCATION, location);
        this.set(AHSPoint.ROOM_NORMAL, normal);
        this.resume();
    }

    public boolean isValid() {
        return this.get(AHSPoint.ROOM) != null && this.get(AHSPoint.AHS) != null;
    }

    public void reset() {
        this.pause();
        this.set(AHSPoint.ROOM, (ISchematicRoom)AHSPoint.ROOM.defVal);
        this.set(AHSPoint.LOCATION, (Point3d)AHSPoint.LOCATION.defVal);
        this.set(AHSPoint.ROOM_NORMAL, (Vector3d)AHSPoint.ROOM_NORMAL.defVal);
        this.resume();
    }

    public void cancel() {
        this.reset();
    }

    public void create(Component c) {
        if (!this.isValid()) {
            return;
        }
        final AHSPoint ahs = this.getAhsPoint().clone();
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(VentusApp app, VentusData md) {
                AHSRoot ahsRoot = (AHSRoot)md.getComponentData("AHS.data");
                if (ahsRoot == null) {
                    return;
                }
                try (VentusData.WriteLock ignored = md.lockWrite();){
                    Undo.begin(Intl.intl("New AHS Zone Point"));
                    String nextName = ahs.getName().isEmpty() ? ahsRoot.nextName(ahs.get(AHSPoint.TYPES)) : ahs.getName();
                    ahs.setName(nextName);
                    AddObject.add((VentusData)md, (Composite)ahsRoot, (int)ahsRoot.getMembers().size(), (IMerlinObj[])new AHSPoint[]{ahs});
                    Undo.end(md);
                }
            }
        };
        UIHook.run(c, "AHSBuilder.create", op, 4);
        this.firePropChanged(COMPLETED);
    }

    public static class Display
    extends APropsDisplay<AHSPointBuilder> {
        public Display(ModelView mv) {
            super(mv);
        }

        @Override
        protected IMerlinGeomSrc constructGeom(AHSPointBuilder builder) {
            if (!builder.isValid()) {
                return null;
            }
            AHSPoint ahs = builder.getAhsPoint().clone();
            ahs.setName("");
            ahs.setVisible(true);
            return ahs;
        }

        @Override
        protected Object[] getInterestingChanges() {
            return new Object[]{AHSPoint.LOCATION, AHSPoint.ROOM_NORMAL};
        }
    }
}

