/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import ventus.EntryPointFactory;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.actions.copypaste.DefaultPasteHandler;
import ventus.data.IMerlinObj;
import ventus.data.schematics.SimError;
import ventus.feature.Feature;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.ahs.AHSPointOISHandler;
import ventus.feature.ahs.AHSPointRibbon;
import ventus.feature.ahs.AHSPointSceneItem;
import ventus.feature.ahs.AHSPrjDataWriter;
import ventus.feature.ahs.AHSRoot;
import ventus.feature.ahs.NewAHSPoint;
import ventus.feature.comps.DefaultCompositeDataModel;
import ventus.feature.comps.FeatureUtil;
import ventus.gui.guiUtil;

public class AHSFeature {
    public static final String GUID = "AHS.data";
    public static final int SEQ_IX = 77;
    public static final ImageIcon ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(AHSPoint.class, "icons/air-conditioner.svg"), 16);

    public static Feature create() {
        DefaultCompositeDataModel ahsData = new DefaultCompositeDataModel(() -> new AHSRoot(), GUID, 77);
        ahsData.addEntryPoint(EntryPointHelper.rootEP(AHSRoot.class, ICON));
        ahsData.addEntryPoint(EntryPointHelper.groupEP(GUID, AHSRoot.AHSNode.class, ICON, Intl.intl("AHS Zone Point Group")));
        EntryPointHelper<AHSPoint> ahsEp = ahsData.addEntryPoint(EntryPointHelper.objectEP(GUID, AHSPoint.class, ICON, Intl.intl("AHS Zone Point")));
        ahsEp.getNameGroup = EntryPointFactory.nameGroup(vd -> ((AHSRoot)vd.getComponentData(GUID)).flatten(AHSPoint.class));
        ahsEp.getErrors = (vd, obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (obj.getInvalid()) {
                errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%s is not connected to any zones."), obj.getName()), Intl.intl("Delete AHS or re-attach to a surface."), (IMerlinObj)obj));
            }
            return errors;
        };
        AHSPointRibbon ribbon = new AHSPointRibbon();
        AHSPointSceneItem sceneItem = new AHSPointSceneItem();
        NewAHSPoint ahsPoint = new NewAHSPoint();
        DefaultPasteHandler pathsPasteHandler = new DefaultPasteHandler(AHSRoot.class);
        return new Feature(ahsData, new AHSPrjDataWriter(), ribbon, sceneItem, ahsPoint, pathsPasteHandler, new AHSPointOISHandler());
    }
}

