/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.value;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;
import ventus.Intl;

public class Schedule
implements Serializable,
ICyclicSurrogate {
    private static final long serialVersionUID = 1L;
    public final ScheduleType type;
    public final UnitDouble initVal;
    public final Entry[] entries;

    protected Schedule(ScheduleType type, UnitDouble initVal, Entry[] entries) {
        this.type = type;
        this.initVal = initVal;
        this.entries = entries;
    }

    public static Schedule newConstant(UnitDouble initVal) {
        return new Schedule(ScheduleType.CONSTANT, initVal, new Entry[0]);
    }

    public static Schedule newRectangular(UnitDouble initVal, Entry[] entries) {
        return new Schedule(ScheduleType.RECTANGULAR, initVal, entries);
    }

    public static Schedule newTrapezoidal(UnitDouble initVal, Entry[] entries) {
        return new Schedule(ScheduleType.TRAPEZOIDAL, initVal, entries);
    }

    public int hashCode() {
        int hash = theUtil.hashCode(this.initVal);
        for (Entry entry : this.entries) {
            hash += entry.hashCode();
        }
        return 0xB9F8037F ^ hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Schedule) {
            Schedule lv = (Schedule)obj;
            return Objects.equals((Object)lv.type, (Object)this.type) && Objects.equals(lv.initVal, this.initVal) && Arrays.equals(lv.entries, this.entries);
        }
        return false;
    }

    public UnitDouble getInitialValue() {
        return this.initVal;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public Stream<UnitDouble> allValues() {
        return Stream.concat(Stream.of(this.getInitialValue()), Arrays.stream(this.getEntries()).map(entry -> entry.val));
    }

    public Schedule transform(Function<UnitDouble, UnitDouble> xformValue) {
        UnitDouble newInit = xformValue.apply(this.getInitialValue());
        Entry[] newEntries = (Entry[])Arrays.stream(this.getEntries()).map(entry -> new Entry(entry.t, (UnitDouble)xformValue.apply(entry.val))).toArray(Entry[]::new);
        return new Schedule(this.type, newInit, newEntries);
    }

    @Override
    public boolean cyclicEquals(Object obj, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Schedule lv = (Schedule)obj;
        return theUtil.equal((Object)this.type, (Object)lv.type, comparedSet) && theUtil.equal(this.initVal, lv.initVal, comparedSet) && theUtil.surrogateListsEqual(Arrays.asList(this.entries), Arrays.asList(lv.entries), comparedSet);
    }

    public static enum ScheduleType {
        CONSTANT(false, Intl.intl("Constant")),
        RECTANGULAR(true, Intl.intl("Rectangular")),
        TRAPEZOIDAL(true, Intl.intl("Trapezoidal"));

        public final boolean hasEntries;
        public final String name;

        private ScheduleType(boolean hasEntries, String name) {
            this.hasEntries = hasEntries;
            this.name = name;
        }
    }

    public static class Entry
    implements Serializable,
    Comparable<Entry>,
    ICyclicSurrogate {
        private static final long serialVersionUID = 1L;
        public final UnitDouble t;
        public final UnitDouble val;

        public Entry(UnitDouble t, UnitDouble val) {
            this.t = t;
            this.val = val;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Entry) {
                Entry entry = (Entry)obj;
                return entry.t.equals(this.t) && Objects.equals(entry.val, this.val);
            }
            return false;
        }

        @Override
        public boolean cyclicEquals(Object obj, HashSet<UnorderedPair<Object, Object>> comparedSet) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Entry entry = (Entry)obj;
            return this.t.equals(entry.t) && theUtil.equal(this.val, entry.val, comparedSet);
        }

        public int hashCode() {
            return 0x6B4FDA05 ^ theUtil.hashCode(this.t) + theUtil.hashCode(this.val);
        }

        @Override
        public int compareTo(Entry o) {
            return this.t.compareTo(o.t);
        }
    }
}

