/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.material;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.scene3d.gui.materialdlg.IMaterialDB;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theTimer;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.HashMaterial;
import ventus.data.material.Material;

public class MaterialDB
extends Composite<Material>
implements IMaterialDB {
    static final long serialVersionUID = 8455150678501557691L;
    private static final Logger LOGGER = Logger.getLogger(MaterialDB.class.getName());
    public static final int FS_OPTIONS = 3;
    public static final String TEX_DIR_NAME = "textures";
    private static final String INFO_EXTN = "xml";
    private transient File d_dbDir;
    private transient Map<Material, Entry> d_materials;
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(Material.class);

    public MaterialDB(String name) {
        this(null, name);
    }

    public MaterialDB(File dbDir, String name) {
        super(name);
        this.d_dbDir = dbDir;
        this.d_materials = new LinkedIdentityHashMap<Material, Entry>();
    }

    public void setDBDir(File dbDir) {
        this.d_dbDir = dbDir;
    }

    public File getDBDir() {
        return this.d_dbDir;
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    public void loadFrom(MaterialDB db) {
        this.reset();
        if (db.flatten().isEmpty()) {
            return;
        }
        HashMap<HashMaterial, Material> matSet = new HashMap<HashMaterial, Material>();
        for (Material mat : this.flatten(Material.class)) {
            matSet.put(mat.makeImagesHashable(), mat);
        }
        for (Material mat : db.flatten(Material.class)) {
            if (!db.isLocal(mat)) continue;
            HashMaterial hmat = mat.makeImagesHashable();
            Material existing = (Material)matSet.get(hmat);
            if (existing != null) {
                this.remove(existing, false);
                this.add(mat, false);
                continue;
            }
            this.add(mat, true);
        }
    }

    protected void removeLocal() {
        ArrayList<Material> toRemove = new ArrayList<Material>();
        for (Material mat : this.flatten(Material.class)) {
            if (!this.isLocal(mat)) continue;
            toRemove.add(mat);
        }
        for (Material mat : toRemove) {
            this.remove(mat, false);
        }
    }

    @Override
    protected boolean getSerializeMembersEnabled() {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(Version.curr().ordinal());
        Set<Material> inUseAppearances = Collections.EMPTY_SET;
        if (this.getDomain() != null) {
            VentusData domain = (VentusData)this.getDomain();
            inUseAppearances = domain.getMaterialsInUse();
        }
        ArrayList<Material> toWrite = new ArrayList<Material>();
        for (Material mat : this.flatten(Material.class)) {
            if (!this.isLocal(mat) && !inUseAppearances.contains(mat)) continue;
            toWrite.add(mat);
        }
        out.writeObject(toWrite);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        this.d_materials = new LinkedIdentityHashMap<Material, Entry>();
        Collection materials = (Collection)in.readObject();
        for (Material tex : materials) {
            this.add(tex);
        }
    }

    public File getTexDir() {
        if (this.d_dbDir == null) {
            return null;
        }
        File texDir = new File(this.d_dbDir, TEX_DIR_NAME);
        if (!texDir.isDirectory()) {
            if (texDir.exists()) {
                texDir.delete();
            }
            texDir.mkdir();
        }
        return texDir;
    }

    public FilenameFilter getPropFilenameFilter() {
        final ExampleFileFilter fileFilter = new ExampleFileFilter(INFO_EXTN);
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                return file.isFile() && fileFilter.accept(file);
            }
        };
    }

    public void scan() {
        this.scanDir(this.getTexDir());
    }

    private void scanDir(File texDir) {
        System.out.printf("Scanning materials...", new Object[0]);
        System.out.flush();
        theTimer timer = new theTimer();
        this.removeAll(new ArrayList<Material>(this.d_materials.keySet()), false);
        File[] matFiles = texDir.listFiles(this.getPropFilenameFilter());
        if (matFiles != null) {
            for (File matFile : matFiles) {
                try {
                    Material mat = this.loadDBMat(matFile);
                    this.add(mat, false);
                }
                catch (Throwable e) {
                    TeciLogging.log(LOGGER, e);
                }
            }
        }
        System.out.printf("done (%g sec)%n", timer.curr());
    }

    protected Material loadDBMat(File infoFile) throws IOException {
        if (!infoFile.exists()) {
            return null;
        }
        return Material.load(infoFile.getParentFile(), infoFile.getName());
    }

    protected void saveDBMat(Material mat) throws IOException {
        File file = this.getDBPropsFile(mat);
        mat.save(file.getParentFile(), file.getName());
    }

    public static IImage cacheImage(IImage img) {
        return img.cacheImage();
    }

    public void updateFile(Material tex) throws IOException {
        if (this.isPermanent(tex)) {
            this.saveDBMat(tex);
        }
    }

    public boolean isLocal(Material tex) {
        Entry entry = this.d_materials.get(tex);
        return entry != null && entry.local;
    }

    public boolean isPermanent(Material tex) {
        Entry entry = this.d_materials.get(tex);
        return entry != null && !entry.local;
    }

    private File getDBPropsFile(Material mat) {
        return MaterialDB.getPropsFile(this.d_dbDir, TEX_DIR_NAME, mat.getName());
    }

    private static File getPropsFile(File dir, String texDir, String matName) {
        dir = new File(dir, texDir);
        return new File(dir, matName + ".xml");
    }

    @Override
    public void add(IMerlinObj tex) {
        if (!(tex instanceof Material)) {
            return;
        }
        this.add((Material)tex, true);
    }

    protected void add(Material tex, boolean local) {
        super.add(tex);
        this.d_materials.put(tex, new Entry(local));
    }

    public boolean importToDB(Material mat) throws Exception {
        if (!this.isLocal(mat)) {
            return false;
        }
        List<IImage> images = mat.getImages();
        ArrayList<IImage> newImages = new ArrayList<IImage>(images.size());
        for (IImage img : images) {
            boolean saveImg = true;
            File srcFile = new File(img.getFilename());
            File dest = new File(this.getTexDir(), srcFile.getName());
            if (dest.exists()) {
                IImage existingImg = MaterialDB.loadImage(dest.getAbsolutePath());
                if (new HashableImage(existingImg).equals(img)) {
                    saveImg = false;
                } else {
                    dest = MaterialDB.findNewFilename(dest);
                }
            }
            if (saveImg) {
                System.out.print("Copying image to db: \"" + dest.getName() + "\"...");
                int saveOptions = 1;
                if (!img.save(dest.getAbsolutePath(), saveOptions)) {
                    throw new IOException(String.format(Intl.intl("Could not save image to %s."), dest.getAbsolutePath()));
                }
                System.out.println("done");
            }
            newImages.add(MaterialDB.loadImage(dest.getAbsolutePath()));
        }
        mat.setImages(newImages);
        File propsFile = this.getDBPropsFile(mat);
        if (propsFile.exists()) {
            propsFile = MaterialDB.findNewFilename(propsFile);
            mat.setName(FilenameManager.splitFilename(propsFile.getName())[0]);
        }
        this.saveDBMat(mat);
        this.remove(mat, false);
        this.add(mat, false);
        return true;
    }

    public static IImage loadImage(String path) {
        return ImageManager.getImage(path, 3, 0);
    }

    private static File findNewFilename(File file) {
        File dir = file.getParentFile();
        String[] name = FilenameManager.splitFilename(file.getName());
        int lu = name[0].lastIndexOf(95);
        int id = 1;
        if (lu > 0) {
            String idStr = name[0].substring(lu + 1);
            try {
                id = Integer.parseInt(idStr);
                name[0] = name[0].substring(0, lu);
            }
            catch (NumberFormatException e) {
                TeciLogging.logUnhandledException(e);
            }
        }
        while (file.exists()) {
            String testName = name[0] + "_" + Integer.toString(id++) + "." + name[1];
            file = new File(dir, testName);
        }
        return file;
    }

    @Override
    public boolean remove(IMerlinObj obj) {
        if (!(obj instanceof Material)) {
            return false;
        }
        Material mat = (Material)obj;
        return this.remove(mat, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Material tex, boolean deleteFiles) {
        this.pauseUpdates();
        try {
            if (!super.remove(tex)) {
                boolean bl = false;
                return bl;
            }
            Entry te = this.d_materials.remove(tex);
            if (te == null) {
                boolean bl = true;
                return bl;
            }
            if (!te.local && deleteFiles) {
                File propsFile = this.getDBPropsFile(tex);
                ArrayList<File> files = new ArrayList<File>();
                files.add(propsFile);
                for (File file : files) {
                    file.delete();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.resumeUpdates();
        }
    }

    public void removeAll(Collection<? extends Material> materials, boolean deleteFiles) {
        for (Material material : materials) {
            this.remove(material, deleteFiles);
        }
    }

    public void reset() {
        this.removeLocal();
    }

    private static enum Version {
        VERSION_0000;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }

    private static class Entry {
        public boolean local;

        public Entry(boolean local) {
            this.local = local;
        }
    }
}

