/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jscience.physics.units.NonSI;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;
import ventus.BackupHandler;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.data.DisplayFilter;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.INameGenerator;
import ventus.data.IOpacity;
import ventus.data.MerlinHierarchy;
import ventus.data.MerlinSelectionModel;
import ventus.data.Opacity;
import ventus.data.Proxies;
import ventus.data.SequentialNameGen;
import ventus.data.SimParams;
import ventus.data.ViewProps;
import ventus.data.camera.CameraList;
import ventus.data.material.Material;
import ventus.data.material.MaterialDB;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.FloorOptions;
import ventus.data.schematics.SchematicTopology;
import ventus.events.EventUtil;
import ventus.events.NonModifyingEvent;
import ventus.feature.comps.IDataModel;
import ventus.feature.props.DisplayProp;
import ventus.feature.props.DisplayProps;
import ventus.feature.tags.Tag;
import ventus.geom.GeomLocation;
import ventus.gui.guiUtil;
import ventus.io.FileUtil;
import ventus.unitsystem.EnglishUS;
import ventus.unitsystem.SIUS;
import ventus.unitsystem.UnitSystem;
import ventus.util.VentusDepSnapshot;

public class VentusData
extends Mediator
implements Serializable,
IMerlinObj {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(VentusData.class.getSimpleName());
    public static final Object MODEL_RESET = "MODEL_RESET";
    public static final Object MODEL_LOADED = "MODEL_LOADED";
    public static final Object MODEL_BACKUP_RESTORED = "MODEL_BACKUP_RESTORED";
    public static final Object MODEL_SAVED = "MODEL_SAVED";
    public static final Object MODIFIED_CHANGED = "MODIFIED_CHANGED";
    public static final Object SELECTION_CHANGED = new NonModifyingEvent("SELECTION_CHANGED");
    public static final Object SUPPORTED_PROPS_CHANGED = "SUPPORTED_PROPS_CHANGED";
    public static final Object MESH_CHANGED = "MESH_CHANGED";
    public static final Object VISIBILITY_MARKER = "VISIBILITY";
    public static final DisplayProp<Boolean> VISIBILITY = ((DisplayProps.TBuilder)DisplayProps.build((Object)"VISIBILITY", true, Intl.intl("Visible"), Intl.intl("Whether the object is visible.")).attrMarkers(VISIBILITY_MARKER)).attrToProp();
    public static final Object CHILD_REMOVED = "CHILD_REMOVED";
    public static final Object CHILDREN_CHANGED = "CHILDREN_CHANGED";
    public static final Object CHILD_ADDED = "CHILD_ADDED";
    public static final Object PARENT_CHANGED = "PARENT_CHANGED";
    public static final Object UNITSYSTEM_CHANGED = new NonModifyingEvent("UNITSYSTEM_CHANGED");
    public static final Object SIM_PARAMS_CHANGED = "SIM_PARAMS_CHANGED";
    public static final Object PREFS_CHANGED = new NonModifyingEvent("PREFS_CHANGED");
    public static final DisplayProp<Color> COLOR = DisplayProps.build((Object)"MerlinData.COLOR", Color.class, null, Intl.intl("Color"), Intl.intl("The color of the object.")).attrToProp();
    public static final DisplayProp<IOpacity> OPACITY = DisplayProps.build((Object)"MerlinData.OPACITY", IOpacity.class, new Opacity(1.0f), Intl.intl("Opacity"), Intl.intl("The opacity of the object.")).attrToProp();
    public static final DisplayProp<Set<Tag>> TAGS = DisplayProps.build((Object)"VentusData.TAGS", Set.class, Collections.emptySet(), Intl.intl("Tags"), Intl.intl("Defines labels that can be applied to the object to quickly find it later and group with like items.")).attrToProp();
    public static final DisplayProp<IMaterial[]> MATERIAL = DisplayProps.build((Object)"MATERIAL", IMaterial[].class, new IMaterial[0], Intl.intl("Material"), Intl.intl("Visual material applied to the object.")).attrToProp();
    public static final Object TOPOLOGY = "TOPOLOGY";
    public static final Object CONNECTION = "CONNECTION";
    public static final DisplayProp<Boolean> ENABLED = DisplayProps.build((Object)"ENABLED", true, Intl.intl("Enabled"), Intl.intl("Whether or not the object is enabled.")).attrToProp();
    public transient String filename = null;
    public transient boolean modified = false;
    private final transient IEventObserver d_modifiedListener = new ModifiedListener();
    public GeomComposite<IMerlinObj> sceneGeom = new GeomComposite(Intl.intl("Imported Geometry"));
    public FloorComposite floors = new FloorComposite();
    public CameraList cameras = new CameraList(Intl.intl("Views"));
    private final Map<String, IMerlinObj> d_managedData;
    @Deprecated
    private FloorOptions floorSortOptions;
    public final FloorOptions floorOptions;
    public final ViewProps viewProps;
    public INameGenerator roomNameGen;
    public INameGenerator wallNameGen;
    public INameGenerator cameraNameGen;
    public MerlinSelectionModel selection = new MerlinSelectionModel();
    public transient MerlinHierarchy hierarchy = new MerlinHierarchy();
    public Proxies proxies = new Proxies();
    public SimParams simParams = new SimParams();
    public MaterialDB materials;
    public final transient GeomLocation geomLocation;
    public final transient SchematicTopology topology;
    public final transient DisplayFilter displayFilter;
    public final transient ModelBackup backup = new ModelBackup("Ventus", "vnts", new BackupHandler());
    private transient BackupEvtListener d_backupListener;
    private transient UnitSystem d_unitSystem;
    private int d_unitSystemInt = 0;
    private final transient ReentrantReadWriteLock d_lock = new ReentrantReadWriteLock();

    public VentusData(boolean autosave) {
        this(autosave, true);
    }

    public VentusData(boolean autosave, boolean topologyEnabled) {
        this.setEvents(new MerlinEvents());
        this.d_managedData = new LinkedHashMap<String, IMerlinObj>();
        VentusApp.getApp().getComponents(IDataModel.class).forEach(obj -> obj.init(this));
        this.initNameGenerators();
        this.floorOptions = new FloorOptions();
        this.viewProps = new ViewProps();
        this.geomLocation = new GeomLocation(this);
        this.topology = new SchematicTopology(this, topologyEnabled);
        this.displayFilter = new DisplayFilter(this);
        File libDir = null;
        if (Application.getApp() != null) {
            libDir = new File(Application.getApp().getInstallDir(), "lib");
        }
        this.materials = new MaterialDB(libDir, Intl.intl("Materials"));
        this.setDomain();
        if (autosave) {
            this.d_backupListener = new BackupEvtListener();
            this.getEvents().addObserver(this.d_backupListener);
            this.updateBackup();
        }
    }

    @Override
    public Object clone() {
        assert (false);
        return null;
    }

    @Override
    public Object getRestoreObj() {
        assert (false);
        return null;
    }

    @Override
    public void restoreFrom(Object obj) {
        assert (false);
    }

    @Override
    public Set<TypedProp<?>> getSupportedProps(IMerlinObj.SupportMode mode) {
        return Set.of();
    }

    @Override
    public <T, PropT extends TypedProp<T>> void insertUndoEntry_propRestore(PropT prop) {
    }

    @Override
    public <T> void set(TypedProp<T> prop, T val) {
        assert (false);
    }

    @Override
    public <T> PropValue<T> getWithDetails(TypedProp<T> prop) {
        return PropValue.unsupported();
    }

    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        assert (false);
        return false;
    }

    public boolean surrogateEquals(Object comparable) {
        assert (false);
        return false;
    }

    public void takeDepSnapshot(DepList<VentusData> deps) {
        assert (false);
    }

    public void writeTopology(ObjectOutputStream oos) throws IOException {
        assert (false);
    }

    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        assert (false);
    }

    @Override
    public long getResultsId() {
        return 0L;
    }

    public boolean isReadLockedByCurrentThread() {
        return this.d_lock.getReadHoldCount() > 0;
    }

    public ReadLock lockRead() {
        return new ReadLock(!EventQueue.isDispatchThread());
    }

    public WriteLock lockWrite() {
        assert (EventQueue.isDispatchThread()) : "Writes must be performed on the event dispatch thread";
        if (!EventQueue.isDispatchThread()) {
            LOGGER.log(Level.SEVERE, "Attempting to acquire a write lock on a non-event dispatch thread, which could lead to deadlock. Restructure code to avoid this condition. Returning an invalid lock.");
        }
        return new WriteLock(EventQueue.isDispatchThread());
    }

    public void downgradeWriteLock() {
        this.d_lock.readLock().lock();
        this.d_lock.writeLock().unlock();
    }

    public void upgradeReadLock() {
        this.d_lock.readLock().unlock();
        this.d_lock.writeLock().lock();
    }

    public <T> T ui(Callable<T> worker) throws CancellationException {
        try {
            if (EventQueue.isDispatchThread()) {
                return worker.call();
            }
            Object[] result = new Object[1];
            EventQueue.invokeAndWait(() -> {
                result[0] = this.call(worker);
            });
            return (T)result[0];
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            VentusApp.crash(e);
            return null;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            VentusApp.crash(e);
            return null;
        }
    }

    public void ui(Runnable worker) throws CancellationException {
        try {
            if (EventQueue.isDispatchThread()) {
                worker.run();
            } else {
                EventQueue.invokeAndWait(worker);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            VentusApp.crash(e);
        }
    }

    public void uiLater(Runnable worker) {
        EventQueue.invokeLater(worker);
    }

    private <T> T call(Callable<T> worker) throws CancellationException {
        try {
            return worker.call();
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            VentusApp.crash(e);
            return null;
        }
    }

    public void setDomain() {
        this.pauseUpdates();
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(this, this);
        }
        this.resumeUpdates();
    }

    public void initNameGenerators() {
        if (this.roomNameGen == null) {
            this.roomNameGen = new SequentialNameGen(Intl.intl("Zone"), 2);
        }
        if (this.wallNameGen == null) {
            this.wallNameGen = new SequentialNameGen(Intl.intl("Wall"), 2);
        }
        if (this.cameraNameGen == null) {
            this.cameraNameGen = new SequentialNameGen(Intl.intl("View"), 2);
        }
    }

    public void reset() {
        this.pauseUpdates();
        VentusApp.getApp().getComponents(IDataModel.class).forEach(obj -> obj.reset(this));
        this.floors.reset();
        this.sceneGeom.clear();
        this.selection.clear();
        this.roomNameGen.reset();
        this.wallNameGen.reset();
        this.simParams.reset();
        this.displayFilter.reset();
        this.floorOptions.reset();
        this.viewProps.reset();
        this.materials.reset();
        this.cameras.clear();
        this.cameraNameGen.reset();
        this.modified = false;
        this.getEvents().changed(this, MODIFIED_CHANGED);
        this.getEvents().changed(this, MODEL_RESET);
        this.resumeUpdates();
        this.modified = false;
        this.filename = null;
        System.gc();
    }

    public void replaceInSel(Object old, Object repl) {
        if (this.selection.isSelected(old)) {
            this.selection.deselect(old);
            this.selection.select(repl);
        }
    }

    public void loadFrom(VentusData md) {
        this.pauseUpdates();
        this.displayFilter.reset();
        this.geomLocation.getLocator().reset();
        this.sceneGeom.restoreFrom(md.sceneGeom);
        this.floors.restoreFrom(md.floors);
        this.cameras.restoreFrom(md.cameras);
        this.selection.restoreFrom(md.selection);
        VentusApp.getApp().getComponents(IDataModel.class).forEach(obj -> obj.loadFrom(md, this));
        this.replaceInSel(md.sceneGeom, this.sceneGeom);
        this.replaceInSel(md.floors, this.floors);
        this.replaceInSel(md.cameras, this.cameras);
        this.simParams.restoreFrom(md.simParams);
        this.roomNameGen = md.roomNameGen;
        this.wallNameGen = md.wallNameGen;
        this.cameraNameGen = md.cameraNameGen;
        this.floorOptions.restoreFrom(md.floorOptions);
        this.viewProps.restoreFrom(md.viewProps);
        this.materials.loadFrom(md.materials);
        this.setUnitSystem(md.getUnitSystem());
        this.modified = md.modified;
        this.getEvents().changed(this, MODIFIED_CHANGED);
        this.getEvents().changed(this, MODEL_LOADED);
        this.resumeUpdates();
        this.filename = null;
        System.gc();
    }

    public String getNewFilename(FileUtil.Types ftype) {
        return this.filename == null ? Intl.intl("untitled") + ftype.tail : guiUtil.getFileNameNoExt(this.filename) + ftype.tail;
    }

    public void updateSearches() {
        this.geomLocation.updateDirty();
    }

    public void updateTopology() {
        this.topology.update();
    }

    public Floor activeFloor() {
        return this.floors.getActive();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        GroupedSequence root = new GroupedSequence("", 0, null);
        root.add(3, (Object)this.materials);
        root.add(13, (Object)this.cameras);
        root.add(23, this.sceneGeom);
        root.add(83, (Object)this.floors);
        root.add(100000, (Object)this.viewProps);
        root.add(200000, (Object)this.floorOptions);
        root.add(300000, (Object)this.selection);
        VentusApp.getApp().getComponents(IDataModel.class).forEach(obj -> obj.addTreeRoots(this, root));
        List objs = root.getChildNodes().stream().map(node -> (IMerlinObj)node.data).collect(Collectors.toList());
        return objs;
    }

    @Override
    public VentusData getDomain() {
        return this;
    }

    @Override
    public void setDomain(VentusData domain, IMerlinObj parent) {
    }

    @Override
    public void setDomain(VentusData owner) {
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        return false;
    }

    @Override
    public void pauseUpdates() {
        this.getEvents().pause();
    }

    @Override
    public boolean resumeUpdates() {
        return this.getEvents().resume();
    }

    public boolean isVisible(Object obj) {
        if (obj instanceof IMerlinObj) {
            return this.isVisible((IMerlinObj)obj);
        }
        if (obj instanceof IDisplayableGeomSrc) {
            boolean basevis = ((IDisplayableGeomSrc)obj).isVisible();
            return basevis && !this.displayFilter.filter(obj);
        }
        return !this.displayFilter.filter(obj);
    }

    public boolean isVisible(IMerlinObj obj) {
        return EntryPointFactory.get(obj).isVisible(this, obj);
    }

    public void setInitialUnitSystem(UnitSystem us) {
        this.d_unitSystem = us;
    }

    public void setUnitSystem(UnitSystem us) {
        this.d_unitSystem = us;
        this.d_unitSystemInt = us == SIUS.getInstance() ? 0 : 1;
        this.getEvents().changed(this, UNITSYSTEM_CHANGED);
    }

    public UnitSystem getUnitSystem() {
        return this.d_unitSystem;
    }

    public VentusDepSnapshot takeFullDependencySnapshot() {
        return this.takeDependencySnapshot(Collections.emptySet());
    }

    public VentusDepSnapshot takeDependencySnapshot(Collection<?> interestingTargets) {
        VentusDepSnapshot deps = new VentusDepSnapshot(this, interestingTargets);
        deps.start(this, this.getChildren());
        return deps;
    }

    public Set<Material> getMaterialsInUse() {
        VentusDepSnapshot deps = this.takeDependencySnapshot(this.materials.flatten(Material.class));
        LinkedIdentityHashSet<Material> result = new LinkedIdentityHashSet<Material>();
        result.addAll(theUtil.filter(deps.getAllDirectDependedOn(), Material.class));
        return result;
    }

    public IMerlinObj getComponentData(String guid) {
        return this.d_managedData.get(guid);
    }

    public void setComponentData(String guid, IMerlinObj obj) {
        this.d_managedData.put(guid, obj);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_unitSystem = this.d_unitSystemInt == 0 ? SIUS.getInstance() : EnglishUS.getInstance();
        if (this.floorSortOptions != null) {
            try {
                theUtil.assignFinalField(this, "floorOptions", this.floorSortOptions);
            }
            catch (Throwable t) {
                assert (false);
                t.printStackTrace();
            }
            this.floorSortOptions = null;
        }
    }

    private void updateBackup() {
        UnitDouble autosavePeriod = MerlinPrefs.getUnitDouble(MerlinPrefs.BACKUP_AUTOSAVE_INTERVAL, NonSI.MINUTE);
        this.backup.setAutosavePeriod(autosavePeriod);
        this.backup.setFilename(this.filename);
        boolean autosaveEnabled = MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_AUTOSAVE);
        this.backup.setAutosaveEnabled(autosaveEnabled);
        boolean backupEnabled = MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_BACKUPONOPEN);
        this.backup.setBackupEnabled(backupEnabled);
        boolean customBackDirEnabled = MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_CUSTOMDIR);
        this.backup.setUseCustomBackupDir(customBackDirEnabled);
        if (customBackDirEnabled) {
            String customBackupDir = MerlinPrefs.getString(MerlinPrefs.BACKUP_CUSTOMDIR_PATH);
            this.backup.setCustomBackupDir(customBackupDir);
        }
    }

    private class ModifiedListener
    implements IEventObserver {
        private ModifiedListener() {
        }

        private boolean isModifiedEvt(Events events) {
            IEventRecord<Object> oevts = events.getEvents(Object.class, new Class[0]);
            return !oevts.filterChanges(EventUtil.acceptOnlyModifying()).isEmpty();
        }

        private boolean hasExplicitModify(Events events) {
            IEventRecord<VentusData> mevts = events.getEvents(VentusData.class, new Class[0]);
            return mevts.hasChangedObjs(MODIFIED_CHANGED);
        }

        @Override
        public void update(Events events) {
            if (this.hasExplicitModify(events)) {
                VentusData.this.backup.setModified(VentusData.this.modified);
            } else if (this.isModifiedEvt(events)) {
                VentusData.this.modified = true;
                VentusData.this.backup.setModified(true);
            }
        }
    }

    private class MerlinEvents
    extends Events {
        private MerlinEvents() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireNotice() {
            Application app = Application.getApp();
            if (app != null) {
                app.beginWaitCursor();
            }
            try {
                VentusData.this.d_lock.writeLock().lock();
                try {
                    VentusData.this.updateTopology();
                }
                finally {
                    VentusData.this.d_lock.writeLock().unlock();
                }
                VentusData.this.pauseUpdates(false);
                VentusData.this.d_lock.writeLock().lock();
                try {
                    for (EventChannel<Object> channel : this.getAffectedChannels(Object.class, new Class[0])) {
                        VentusData.this.selection.deselectAll(channel.getRemovedObjs());
                    }
                }
                finally {
                    VentusData.this.d_lock.writeLock().unlock();
                }
                VentusData.this.resumeUpdates();
                VentusData.this.d_modifiedListener.update(this);
                super.fireNotification();
            }
            finally {
                if (app != null) {
                    app.endWaitCursor();
                }
            }
        }

        @Override
        protected void fireNotification() {
            Runnable noticer = new Runnable(){

                @Override
                public void run() {
                    MerlinEvents.this.fireNotice();
                }
            };
            VentusData.this.ui(noticer);
        }
    }

    private class BackupEvtListener
    implements IEventObserver {
        private BackupEvtListener() {
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(VentusData.class, new Class[0]).hasChangedObjs(MODEL_RESET, MODEL_LOADED, MODEL_SAVED, PREFS_CHANGED)) {
                VentusData.this.updateBackup();
            }
        }
    }

    public class ReadLock
    implements AutoCloseable {
        private final boolean d_valid;

        private ReadLock(boolean valid) {
            this.d_valid = valid;
            if (this.d_valid) {
                VentusData.this.d_lock.readLock().lock();
            }
        }

        @Override
        public void close() {
            if (this.d_valid) {
                VentusData.this.d_lock.readLock().unlock();
            }
        }
    }

    public class WriteLock
    implements AutoCloseable {
        private final boolean d_valid;

        private WriteLock(boolean valid) {
            this.d_valid = valid;
            if (this.d_valid) {
                VentusData.this.pauseUpdates();
                VentusData.this.d_lock.writeLock().lock();
            }
        }

        @Override
        public void close() {
            if (this.d_valid) {
                VentusData.this.d_lock.writeLock().unlock();
                VentusData.this.resumeUpdates();
            }
        }
    }
}

