/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.vecmath.Vector3d;
import thunderheadeng.cad.bim.BIMCoveringType;
import thunderheadeng.cad.bim.BIMTransportType;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.actions.Undo;
import ventus.data.IOpacity;
import ventus.data.ImportType;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.DisplayProp;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropertyDefs;
import ventus.feature.props.TypedProps;
import ventus.geom.GeomUtil;
import ventus.geom.IMerlinGeomSrc;

public class ImportedGeom
extends NamedMerlinObj
implements IMerlinGeomSrc,
IDirectDependent<VentusData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<ImportedGeom> PROP_TYPES = new PropertyDefs<ImportedGeom>(PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES);
    public static final TypedProp<Boolean> PROP_VISIBILITY = PROP_TYPES.storeAsPlainOldData(VentusData.VISIBILITY).attrGetter(ImportedGeom::isVisible, null, new TypedProp[0]).attrSetter(ImportedGeom::setVisible).attrFinish();
    public static final TypedProp<Integer> PROP_OPTIONS = TypedProps.build((Object)"OPTIONS", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ImportedGeom::getOptions, null, new TypedProp[0]).attrSetter(ImportedGeom::setOptions).attrFinish();
    public static final TypedProp<IPropsSrc> PROP_DISPLAY_PROPS = TypedProps.build((Object)"DISPLAY_PROPS", IPropsSrc.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ImportedGeom::getDisplayProps, null, new TypedProp[0]).attrSetter(ImportedGeom::setDisplayProps).attrFinish();
    public static final TypedProp<IGeomNode> PROP_GEOM = TypedProps.build((Object)"GEOM", IGeomNode.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ImportedGeom::getGeom, null, new TypedProp[0]).attrSetter(ImportedGeom::setGeom).attrFinish();
    public static final IPropertySet.Prop<BIMType> PROP_BIM_TYPE = TypedProps.build("BIM_TYPE", BIMType.class, BIMType.UNKNOWN).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ImportedGeom::getBIMType, null, new TypedProp[0]).attrSetter(ImportedGeom::setBIMType).attrFinish();
    public static final DisplayProp<String> PROP_OBJECT_TYPE = (DisplayProp)DisplayProps.build((Object)"OBJECT_TYPE", "", Intl.intl("Object Type"), "<html>" + Intl.intl("The object type used when generating model elements.<br>This is determined automatically if imported from an IFC file.")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<ImportType> PROP_IMPORTED_TYPE = (DisplayProp)DisplayProps.build((Object)"IMPORTED_TYPE", ImportType.class, ImportType.OBSTRUCTION, Intl.intl("Import Type"), Intl.intl("Import type of the object")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> PROP_DOOR_WIDTH = TypedProps.build((Object)"DOOR_WIDTH", UnitDouble.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> PROP_DOOR_HEIGHT = TypedProps.build((Object)"DOOR_HEIGHT", UnitDouble.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<IGeomNode> PROP_DOOR_VOID = TypedProps.build((Object)"DOOR_VOID", IGeomNode.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Vector3d> PROP_DOOR_DIR = TypedProps.build((Object)"DOOR_DIR", Vector3d.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Boolean> PROP_DOOR_IS_ACCESSIBLE = TypedProps.build((Object)"DOOR_IS_ACCESSIBLE", Boolean.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> PROP_DOOR_FLOWRATE = TypedProps.build((Object)"DOOR_FLOWRATE", UnitDouble.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<BIMCoveringType> PROP_COVERING_TYPE = TypedProps.build("PROP_COVERING_TYPE", BIMCoveringType.class, BIMCoveringType.UNKNOWN).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<BIMTransportType> PROP_TRANSPORT_TYPE = TypedProps.build("PROP_TRANSPORT_TYPE", BIMTransportType.class, BIMTransportType.UNKNOWN).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Integer> PROP_SPACE_OCCUPANCY_NUMBER = TypedProps.build((Object)"SPACE_OCCUPANCY_NUMBER", Integer.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> PROP_SPACE_AREA_PER_OCCUPANT = TypedProps.build((Object)"SPACE_AREA_PER_OCCUPANT", UnitDouble.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Integer> PROP_SPACE_OCCUPANCY_NUMBER_PEAK = TypedProps.build((Object)"SPACE_OCCUPANCY_NUMBER_PEAK", Integer.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<String> PROP_BUILDING_PRE_EVACUATION_TIME = TypedProps.build((Object)"BUILDING_PRE_EVACUATION_TIME", String.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<String> PROP_BUILDING_OCC_PROFILES_LIST = TypedProps.build((Object)"BUILDING_OCC_PROFILES_LIST", String.class).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<IMaterial[]> PROP_MATERIAL = GeomUtil.defineMaterialProp(PROP_TYPES, ImportedGeom::getGeom, ImportedGeom::getDisplayProps, ImportedGeom::setDisplayGeom, (md, ig, matsProp) -> {
        Undo.insertUndoEntry_propRestore(md, ig, PROP_GEOM);
        Undo.insertUndoEntry_propRestore(md, ig, PROP_DISPLAY_PROPS);
    });
    public static final DisplayProp<Color> PROP_COLOR = GeomUtil.defineColorProp(PROP_TYPES, ImportedGeom::getGeom, ImportedGeom::getDisplayProps, ImportedGeom::setDisplayGeom, (md, ig, colorProp) -> Undo.insertUndoEntry_propRestore(md, ig, PROP_DISPLAY_PROPS));
    public static final DisplayProp<IOpacity> PROP_OPACITY = GeomUtil.defineOpacityProp(PROP_TYPES, ImportedGeom::getGeom, ImportedGeom::getDisplayProps, ImportedGeom::setDisplayGeom, (md, ig, opacProp) -> Undo.insertUndoEntry_propRestore(md, ig, PROP_DISPLAY_PROPS));
    @SkipDep
    private IGeomNode d_geom;
    @SkipDep
    private IPropsSrc d_propsSrc;
    private int d_options;
    private boolean d_visible;
    private BIMType d_bimType;
    private PropertySet d_props;

    public ImportedGeom(String name) {
        this(name, DisplayGeom.EMPTY);
    }

    public ImportedGeom(String name, DisplayGeom dg) {
        this(name, dg.node, dg.props);
    }

    public ImportedGeom(String name, IGeomNode geom, IPropsSrc propsSrc) {
        super(name);
        this.d_geom = geom;
        this.d_propsSrc = propsSrc;
        this.d_visible = true;
        this.d_options = 0;
        this.d_bimType = BIMType.UNKNOWN;
        this.d_props = new PropertySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_bimType == null) {
            this.d_bimType = BIMType.UNKNOWN;
        }
        if (this.d_props == null) {
            this.d_props = new PropertySet();
        }
    }

    public ImportType getImportedTypeFromBIMType() {
        switch (this.d_bimType) {
            case Ramp: 
            case RampFlight: {
                return ImportType.RAMP;
            }
            case Slab: {
                return ImportType.FLOOR;
            }
            case Covering: {
                return this.get(PROP_COVERING_TYPE) == BIMCoveringType.FLOORING ? ImportType.FLOOR : ImportType.OBSTRUCTION;
            }
            case Stair: 
            case StairFlight: {
                return ImportType.STAIR;
            }
            case Door: {
                return ImportType.DOOR;
            }
            case TransportElement: {
                switch (this.get(PROP_TRANSPORT_TYPE)) {
                    case ESCALATOR: {
                        return ImportType.ESCALATOR;
                    }
                    case MOVINGWALKWAY: {
                        return ImportType.MOVING_WALKWAY;
                    }
                }
                return ImportType.OBSTRUCTION;
            }
            case Space: {
                return this.getDisplayGeom().node == DisplayGeom.EMPTY.node ? ImportType.IGNORED : ImportType.ROOM;
            }
            case Building: {
                return ImportType.BUILDING;
            }
        }
        return this.isA(BIMType.Element) || this.isA(BIMType.UNKNOWN) ? ImportType.OBSTRUCTION : ImportType.IGNORED;
    }

    public void setBIMType(BIMType type) {
        if (this.d_bimType == type) {
            return;
        }
        this.d_bimType = type;
        this.changedEvt(PROP_BIM_TYPE);
    }

    public BIMType getBIMType() {
        return this.d_bimType;
    }

    public ImportType getImportedType() {
        return this.get(PROP_IMPORTED_TYPE);
    }

    public void setImportedType(ImportType type) {
        this.set(PROP_IMPORTED_TYPE, type);
    }

    public boolean isA(BIMType type) {
        return type.isAncestorOf(this.getBIMType());
    }

    public boolean isA(ImportType type) {
        return this.getImportedType() == type;
    }

    public boolean isIgnoredInModelGeneration() {
        return this.getImportedType() == ImportType.IGNORED;
    }

    private int getOptions() {
        return this.d_options;
    }

    private void setOptions(int options) {
        if (options != this.d_options) {
            this.d_options = options;
            this.changedEvt(PROP_OPTIONS);
        }
    }

    public void setOptionsState(boolean state, int options) {
        int newOpts;
        int n = newOpts = state ? this.d_options | options : this.d_options & ~options;
        if (newOpts == this.d_options) {
            return;
        }
        this.d_options = newOpts;
        this.changedEvt(new Object[0]);
    }

    public boolean getOptionsWithOptions(int options) {
        return (this.d_options & options) == options;
    }

    protected PropertyDefs<ImportedGeom> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public ImportedGeom clone() {
        return (ImportedGeom)super.clone();
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return new DisplayGeom(this.d_geom, this.d_propsSrc);
    }

    public DisplayGeom getDisplayGeom() {
        return this.getDisplayGeom(null);
    }

    public void setDisplayGeom(DisplayGeom dg) {
        this.setDisplayGeom(dg.node, dg.props);
    }

    public void setDisplayGeom(IGeomNode geom, IPropsSrc props) {
        this.pauseUpdates();
        this.setGeom(geom);
        this.setDisplayProps(props);
        this.resumeUpdates();
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dispProps, Runnable validateProgress) {
        IGeomNode pickable = this.getGeom().getPickable(validateProgress, dispProps.isWireframe(this));
        return new DisplayGeom(pickable, this.d_propsSrc);
    }

    @Override
    public IGeomNode getGeom() {
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (this.d_geom == geom) {
            return;
        }
        this.d_geom = geom;
        this.changedEvt(PROP_GEOM);
    }

    public void setDisplayProps(IPropsSrc props) {
        if (this.d_propsSrc == props) {
            return;
        }
        this.d_propsSrc = props;
        this.changedEvt(PROP_DISPLAY_PROPS);
    }

    public IPropsSrc getDisplayProps() {
        return this.d_propsSrc;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.d_visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(VentusData.VISIBILITY);
    }
}

