/*
 * Decompiled with CFR 0.152.
 */
package ventus.builders;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.vecmath.Point2d;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import ventus.builders.ATwoPointBuilder;
import ventus.builders.PlanarGeomBuilder;
import ventus.builders.WorkingPlane;
import ventus.data.VentusData;
import ventus.geom.Geometry;

public class RectBuilder
extends ATwoPointBuilder {
    public RectBuilder(VentusData data, WorkingPlane workingPlane, PlanarGeomBuilder.IGeomBuilder builder) {
        super(data, workingPlane, builder);
    }

    @Override
    public Shape getShape() {
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        if (p1 == null || p2 == null) {
            return new Rectangle2D.Double();
        }
        double width = Math.abs(p2.x - p1.x);
        double height = Math.abs(p2.y - p1.y);
        double miny = Math.min(p1.y, p2.y);
        double minx = Math.min(p1.x, p2.x);
        return new Rectangle2D.Double(minx, miny, width, height);
    }

    @Override
    public void updatePoints(ArrayList<Point2d> points) {
        points.add(this.getP1());
        points.add(this.getP2());
    }

    @Override
    public Point2d getMidpointLocation(int ix) {
        double posX = 0.0;
        double posY = 0.0;
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        if (ix == 0) {
            posX = (p1.x + p2.x) / 2.0;
            posY = p1.y;
        } else if (ix == 2) {
            posX = (p1.x + p2.x) / 2.0;
            posY = p2.y;
        } else if (ix == 1) {
            posX = p1.x;
            posY = (p1.y + p2.y) / 2.0;
        } else if (ix == 3) {
            posX = p2.x;
            posY = (p1.y + p2.y) / 2.0;
        }
        return new Point2d(posX, posY);
    }

    @Override
    public ArrayList<String> getPointsAsStrings(Unit u) {
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        UnitDouble w = new UnitDouble(Math.abs(p1.x - p2.x), Geometry.LENGTH_UNIT);
        UnitDouble h = new UnitDouble(Math.abs(p1.y - p2.y), Geometry.LENGTH_UNIT);
        String width = Global.format(w, u, 1);
        String height = Global.format(h, u, 1);
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(width);
        texts.add(height);
        texts.add(width);
        texts.add(height);
        return texts;
    }
}

