/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.importgeom;

import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.stage.FileChooser;
import javax.swing.Icon;
import thunderheadeng.cad.in.CadImportUI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.gui.wizard.WizardDlg;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CancelledException;
import ventus.actions.MerlinOp;
import ventus.actions.New;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.importgeom.IImporter;
import ventus.actions.importgeom.ImportCAD;
import ventus.actions.importgeom.ImportCSV;
import ventus.actions.importgeom.ImportOptions;
import ventus.actions.importgeom.ImportPSM;
import ventus.actions.importgeom.ImportPrj;
import ventus.actions.importgeom.ImportUtil;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.gui.guiUtil;
import ventus.mv.ModelView;

public class Import
extends AMerlinOp {
    public static final Object MODEL_IMPORTED = "Import.MODEL_IMPORTED";
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Import16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Import(), Intl.intl("&Import...,-,Import File,Import File"), ICON);
    private static final List<IImporter> s_importers = new ArrayList<IImporter>();
    private static final Map<Pair<IImporter, String>, ImportOptions> s_cachedOptions = new HashMap<Pair<IImporter, String>, ImportOptions>();

    public static void registerImporter(IImporter importer) {
        s_importers.add(importer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(VentusApp app, VentusData mdd) {
        ArrayList<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();
        for (IImporter importer : s_importers) {
            filters.addAll(Arrays.asList(importer.getFileFilters()));
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, filters);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        String ext = FilenameManager.getExtension(f.getAbsolutePath());
        if (ext.isEmpty()) {
            String msg = Intl.intl("Could not determine file type.");
            guiDialog.showInvalidEntryMessage(app.getActiveFrame(), msg);
            return;
        }
        IImporter importer = null;
        block5: for (IImporter imp : s_importers) {
            FileChooser.ExtensionFilter[] impFilters;
            for (FileChooser.ExtensionFilter filt : impFilters = imp.getFileFilters()) {
                if (!filt.getExtensions().contains("*." + ext)) continue;
                importer = imp;
                break block5;
            }
        }
        assert (importer != null);
        if (importer == null) {
            return;
        }
        ImportOptions options = null;
        app.beginWaitCursor();
        try {
            WhereCard firstImportCard;
            options = s_cachedOptions.get(new Pair<Object, String>(importer, ext));
            if (options == null) {
                options = new ImportOptions(mdd);
                importer.initDefaultOptions(mdd, ext, options);
                s_cachedOptions.put(new Pair<IImporter, String>(importer, ext), options);
            }
            options.reset(f);
            options.set(CadImportUI.WARNINGS, new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0));
            WhereCard firstCard = firstImportCard = importer.getCard(options);
            firstCard = new WhereCard(firstImportCard, f);
            if (firstCard != null) {
                WizardDlg<IPropertySet> wizard = new WizardDlg<IPropertySet>((Window)app.getActiveFrame(), Intl.intl("Import"), String.format(Intl.intl("Import %s"), f.getName()), firstCard);
                wizard.init(options);
                if (wizard.doModal() != 1) {
                    return;
                }
            }
            Import.open(app, mdd, f.getPath(), importer, options);
            WarningReport<Warning> warningReport = options.get(CadImportUI.WARNINGS);
            if (!warningReport.isEmpty()) {
                new WarningDlg<Warning>((Window)app.getActiveFrame(), Intl.intl("Import Warning"), Intl.intl("Problem importing model."), options.get(CadImportUI.WARNINGS)).doModal();
            }
        }
        finally {
            if (options != null) {
                options.cleanup();
            }
            importer.cleanup(options);
            app.endWaitCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean open(VentusApp app, VentusData mdd, String fn, IImporter importer, ImportOptions options) {
        app.beginWaitCursor();
        try {
            if (options.get(ImportOptions.NEW_MODEL).booleanValue() && !app.promptSaveIfModified()) {
                boolean bl = false;
                return bl;
            }
            IImporter.Result result = importer.read(app, fn, options);
            result.root.prune();
            if (result.root.isEmpty() && result.additionalObjs.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            IdentityHashSet<Material> usedMats = new IdentityHashSet<Material>();
            ImportUtil.getUsedMaterials(result.root.flatten(ImportedGeom.class), usedMats);
            LinkedIdentityHashSet<Material> newUsedMats = new LinkedIdentityHashSet<Material>((Collection<Material>)options.get(ImportOptions.MAT_CACHE).get().getAddedMaterials());
            newUsedMats.retainAll(usedMats);
            try (VentusData.WriteLock lock = mdd.lockWrite();){
                Undo.begin(Intl.intl("Import"));
                if (options.get(ImportOptions.NEW_MODEL).booleanValue()) {
                    New.newModel(app, mdd);
                }
                if (!newUsedMats.isEmpty()) {
                    Undo.insertUndoEntry_delete(mdd, mdd.materials, newUsedMats);
                    mdd.materials.addAll(newUsedMats);
                }
                if (!result.root.isEmpty()) {
                    Undo.insertUndoEntry_delete(mdd, mdd.sceneGeom, result.root);
                    mdd.sceneGeom.add(result.root);
                }
                ArrayList<IMerlinObj> newSelection = new ArrayList<IMerlinObj>();
                for (Pair<GeomComposite<?>, IMerlinObj> additionalObj : result.additionalObjs) {
                    Undo.insertUndoEntry_delete(mdd, (Composite)additionalObj.v1, additionalObj.v2);
                    ((GeomComposite)additionalObj.v1).add((IMerlinObj)additionalObj.v2);
                    newSelection.add((IMerlinObj)additionalObj.v2);
                }
                if (!newSelection.isEmpty()) {
                    Undo.insertUndoEntry_restoreSelection(mdd);
                    mdd.selection.set(newSelection);
                }
                mdd.getEvents().changed(mdd, MODEL_IMPORTED);
                mdd.getEvents().changed(mdd, ModelView.EVT_RESET_CAMERAS);
                Undo.end(mdd);
            }
        }
        catch (CancelledException result) {
        }
        catch (Exception e) {
            Import.showError(app, fn, e);
            boolean bl = false;
            return bl;
        }
        finally {
            app.endWaitCursor();
        }
        System.gc();
        return true;
    }

    private static void showError(VentusApp app, String fn, Exception e) {
        String msg = String.format(Intl.intl("Error importing %s."), fn);
        guiUtil.showError(app, Intl.intl("Import Error"), msg, (Throwable)e);
    }

    static {
        Import.registerImporter(new ImportPSM());
        Import.registerImporter(new ImportCAD());
        Import.registerImporter(new ImportPrj());
        if (System.getProperty("csvimport_enable") != null) {
            Import.registerImporter(new ImportCSV());
        }
    }

    private static class WhereCard
    extends AWizardCard<IPropertySet> {
        private static final long serialVersionUID = -7470489699676283058L;
        private final AWizardCard<IPropertySet> d_nextCard;
        private final guiRadioButton d_newModel;
        private final guiRadioButton d_currModel;

        public WhereCard(AWizardCard<IPropertySet> nextCard, File f) {
            super(Intl.intl("Import Location"));
            this.d_nextCard = nextCard;
            this.d_newModel = new guiRadioButton(Intl.intl("Into a new model"));
            this.d_currModel = new guiRadioButton(Intl.intl("Into the current model"));
            new guiButtonGroup(this.d_newModel, this.d_currModel);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Where should the data be imported?"));
            gb.addIdentRow(this.d_newModel);
            gb.addIdentRow(this.d_currModel);
            gb.finalizeRows();
        }

        @Override
        public Dimension getMaxCardSize() {
            return this.getMaxSizeThisOrNext();
        }

        @Override
        public boolean isActionEnabled(IPropertySet data, int action) {
            switch (action) {
                case 0: {
                    return true;
                }
                case 4: {
                    return this.d_nextCard == null;
                }
                case 1: {
                    return this.d_nextCard != null;
                }
            }
            return false;
        }

        @Override
        public void initFrom(IPropertySet data) {
            if (data.get(ImportOptions.NEW_MODEL).booleanValue()) {
                this.d_newModel.setSelected(true);
            } else {
                this.d_currModel.setSelected(true);
            }
        }

        @Override
        public void saveTo(IPropertySet data) {
            data.set(ImportOptions.NEW_MODEL, this.d_newModel.isSelected());
        }

        @Override
        public void cancel() {
        }

        @Override
        public AWizardCard<?> getNext() {
            return this.d_nextCard;
        }
    }
}

