/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.dependencies.Dependency;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.copypaste.CopyPasteUtil;
import ventus.actions.copypaste.DefaultPasteHandler;
import ventus.actions.copypaste.FloorPasteHandler;
import ventus.actions.copypaste.GeomPasteHandler;
import ventus.actions.copypaste.PasteHandler;
import ventus.actions.copypaste.PasteHints;
import ventus.actions.copypaste.VentusCopyDataContainer;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.camera.CameraList;
import ventus.data.material.MaterialDB;
import ventus.data.schematics.FloorComposite;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.mv.gui.LocationPanel;
import ventus.util.MerlinUtil;
import ventus.util.VentusDepSnapshot;

public class Paste
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Paste16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Paste(), Intl.intl("&Paste...,V,Paste selected objects"), ICON);

    public boolean canPaste(Collection<PasteHandler> handlers, Map<IDomainObject, String> payload) {
        return !payload.isEmpty() && !payload.entrySet().stream().allMatch(entry -> Paste.isUnsupported(handlers, (IDomainObject)entry.getKey(), (String)entry.getValue()));
    }

    public static boolean isUnsupported(Collection<PasteHandler> handlers, IDomainObject obj, String mdRootClassName) {
        for (PasteHandler handler : handlers) {
            if (!handler.isHandlerFor(obj, mdRootClassName)) continue;
            return false;
        }
        return true;
    }

    private Map<IDomainObject, String> getClipboardPayload(VentusApp app, VentusData md) {
        block5: {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            Clipboard systemClipboard = defaultToolkit.getSystemClipboard();
            try {
                if (!systemClipboard.isDataFlavorAvailable(VentusCopyDataContainer.DATAFLAVOR_BINARY)) break block5;
                try {
                    VentusCopyDataContainer pasteData = (VentusCopyDataContainer)systemClipboard.getData(VentusCopyDataContainer.DATAFLAVOR_BINARY);
                    if (pasteData.getVersion() == VentusIO.Version.curr().num) {
                        return pasteData.getObjs(app.getComponents(IInputStreamFeatureHandler.class));
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IllegalStateException e) {
                if ("cannot open system clipboard".equals(e.getMessage())) break block5;
                e.printStackTrace();
            }
        }
        return Collections.emptyMap();
    }

    public static Collection<PasteHandler> getPasteHandlers(VentusApp app) {
        ArrayList<PasteHandler> handlers = new ArrayList<PasteHandler>();
        handlers.add(new GeomPasteHandler());
        handlers.add(new FloorPasteHandler());
        handlers.add(new DefaultPasteHandler(CameraList.class));
        handlers.add(new DefaultPasteHandler(MaterialDB.class));
        handlers.addAll(app.getComponents(PasteHandler.class));
        return handlers;
    }

    public Collection<Warning> performPaste(VentusData md, VentusApp app, Map<IDomainObject, String> payload) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        Collection<PasteHandler> handlers = Paste.getPasteHandlers(app);
        PasteQueue pasteObjs = new PasteQueue(md, handlers, warnings::add);
        LinkedIdentityHashSet<IDomainObject> adjustedPayload = new LinkedIdentityHashSet<IDomainObject>();
        payload.entrySet().stream().filter(entry -> pasteObjs.enqueue((IDomainObject)entry.getKey(), (String)entry.getValue())).map(entry -> (IDomainObject)entry.getKey()).forEach(adjustedPayload::add);
        VentusDepSnapshot pasteDeps = new VentusDepSnapshot(md);
        adjustedPayload.forEach(obj -> pasteDeps.takeSnapshot(obj));
        Paste.resolvePasteDependencies(md, app.getMainFrame(), adjustedPayload, handlers, pasteObjs, pasteDeps, warnings);
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Paste"));
            pasteObjs.paste(app);
            Undo.end(md);
        }
        return warnings;
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Map<IDomainObject, String> payload = this.getClipboardPayload(app, md);
        if (!this.canPaste(Paste.getPasteHandlers(app), payload)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Collection<Warning> warnings = this.performPaste(md, app, payload);
        Paste.showWarnings(app, warnings);
    }

    public static void showWarnings(VentusApp app, Collection<Warning> warnings) {
        if (warnings.isEmpty()) {
            return;
        }
        WarningReport<Warning> rpt = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
        warnings.forEach(rpt::addWarning);
        WarningDlg warnDlg = WarningDlg.create(app.getMainFrame(), Intl.intl("Warnings"), "", rpt);
        warnDlg.doModal();
    }

    private static boolean promptForPasteFloorDeps(VentusData md, Window dlgParent) {
        Callable<Boolean> uiFunc = () -> {
            int option = JOptionPane.showConfirmDialog(dlgParent, Intl.intl("Geometry is referenced by pasted objects. Include the geometry in the paste?\n \"No\" will remove references of the geometry from paste objects."), Intl.intl("Paste Geometry"), 0);
            return option == 0;
        };
        return md.ui(uiFunc);
    }

    /*
     * Could not resolve type clashes
     */
    private static void resolvePasteDependencies(VentusData md, Window dlgParent, Collection<IDomainObject> payload, Collection<PasteHandler> handlers, PasteQueue pasteObjs, VentusDepSnapshot pasteDeps, List<Warning> warnings) {
        LinkedIdentityHashSet nonPasteable = new LinkedIdentityHashSet();
        DepSnapshot.Hierarchy hierarchy = pasteDeps.getHierarchy(IDomainObject.class, IDomainObject.class);
        Set referenced = pasteDeps.getAllDirectDependedOn();
        ArrayList sortedReferenced = new ArrayList(referenced);
        sortedReferenced.sort((r1, r2) -> {
            if (r1 == r2) {
                return 0;
            }
            boolean refed1 = hierarchy.isReferenced((IDomainObject)r1, (IDomainObject)r2);
            boolean refed2 = hierarchy.isReferenced((IDomainObject)r2, (IDomainObject)r1);
            if (refed1 && refed2) {
                return 0;
            }
            if (refed1) {
                return -1;
            }
            if (refed2) {
                return 1;
            }
            return 0;
        });
        HashSet closedRemovalNotSupported = new HashSet();
        CachedValue<Boolean> pasteFloorDeps = new CachedValue<Boolean>();
        Set flattenedPayload = MerlinUtil.flatten(payload, IDomainObject.class).stream().collect(Collectors.toCollection(() -> new IdentityHashSet()));
        IdentityHashSet doNotReplace = new IdentityHashSet();
        for (IDomainObject dependedOn : sortedReferenced) {
            IDomainObject existing;
            Set dependencies;
            block11: {
                block10: {
                    dependencies = pasteDeps.getDependents(dependedOn);
                    if (flattenedPayload.contains(dependedOn)) break block10;
                    if (!doNotReplace.contains(dependedOn)) break block11;
                }
                dependencies.stream().filter(dep -> dep.source instanceof IDomainObject).map(dep -> (IDomainObject)dep.source).filter(Filters.reject(flattenedPayload)).forEach(doNotReplace::add);
                if (flattenedPayload.contains(dependedOn)) continue;
            }
            IDomainObject iDomainObject = existing = !doNotReplace.contains(dependedOn) && dependencies.stream().anyMatch(dep -> dep.supportsReplacement()) && dependencies.stream().allMatch(dep -> dep.supportsReplacement() || dep.link() == DLink.CONTAINED_BY) ? EntryPointFactory.get(dependedOn).getConflict(md, dependedOn) : null;
            if (existing == null && dependencies.stream().anyMatch(dep -> dep.link() != DLink.CONTAINED_BY)) {
                boolean paste;
                String mdRootClassName = CopyPasteUtil.getRootString(md, dependedOn);
                if (Paste.isUnsupported(handlers, dependedOn, mdRootClassName)) {
                    paste = false;
                    dependencies.stream().filter(dep -> dep.source instanceof IDirectDependent).map(dep -> dep.source).filter(o -> closedRemovalNotSupported.add(new Pair<IDirectDependent, IDomainObject>((IDirectDependent)o, dependedOn))).forEach(o -> warnings.add(CopyPasteUtil.getPasteDependencySupportWarning(o, dependedOn)));
                } else {
                    paste = mdRootClassName.equals(FloorComposite.class.getName()) ? pasteFloorDeps.get(() -> Paste.promptForPasteFloorDeps(md, dlgParent)) : true;
                }
                if (paste && !nonPasteable.contains(dependedOn) && pasteObjs.enqueue(dependedOn, mdRootClassName)) continue;
                nonPasteable.add(dependedOn);
            }
            for (Dependency dep2 : dependencies) {
                if (dep2.link() == DLink.CONTAINED_BY) continue;
                if (dep2.supportsReplacement() && (existing != null || dep2.link() == DLink.WEAK)) {
                    dep2.replaceDependency(md, dependedOn, existing);
                    continue;
                }
                Object SrcT = dep2.source;
                if (!(SrcT instanceof IDomainObject)) continue;
                IDomainObject dobj = (IDomainObject)SrcT;
                nonPasteable.add(dobj);
                pasteObjs.remove(dobj);
            }
        }
        if (!nonPasteable.isEmpty()) {
            pasteObjs.removeNonPasteableFromComposites(o -> !nonPasteable.contains(o));
        }
        payload.stream().filter(nonPasteable::contains).forEach(o -> {
            String ctgyName = EntryPointFactory.get(o).getCategoryName(md, (IDomainObject)o);
            warnings.add(new Warning(String.format(Intl.intl("%1$s, \"%2$s\", referenced an object that could not be pasted."), ctgyName, MerlinUtil.getName(o)), String.format(Intl.intl("%1$s, \"%2$s\", excluded from paste."), ctgyName, MerlinUtil.getName(o))));
        });
    }

    private static TransformInfo promptForTransformParameter(Window dlgParent, VentusData md) {
        Callable<TransformInfo> uiFunc = () -> {
            int option = JOptionPane.showConfirmDialog(dlgParent, Intl.intl("Geometry intersection detected.\nOffset pasted geometry?"), Intl.intl("Paste Offset"), 0);
            if (option != 0) {
                return TransformUtil.IDENTITY_INFO;
            }
            guiDialog dlg = new guiDialog(dlgParent, Intl.intl("Offset"), 1);
            LocationPanel panel = new LocationPanel();
            dlg.getDialogPane().add(panel, "Center");
            if (dlg.doModal() == 1) {
                UnitPoint3D xformUpt3d = panel.getValue();
                Point3d xformMeters = xformUpt3d.getValue(SI.METER);
                ITransform xform = TransformUtil.translate(xformMeters.x, xformMeters.y, xformMeters.z);
                return xform.getInfo();
            }
            return TransformUtil.IDENTITY_INFO;
        };
        return md.ui(uiFunc);
    }

    private static class PasteQueue {
        private final VentusData md;
        private final Consumer<? super Warning> warnings;
        private final Collection<PasteHandler> handlers;
        private final Collection<Composite<IMerlinObj>> selectedComposites;
        private final Collection<IMerlinObj> selectedLeaves;
        private final Map<IDomainObject, ObjPasteInfo> pasteQueue = new LinkedIdentityHashMap<IDomainObject, ObjPasteInfo>();

        public PasteQueue(VentusData md, Collection<PasteHandler> handlers, Consumer<? super Warning> warnings) {
            this.md = md;
            this.warnings = warnings;
            this.handlers = handlers;
            Set selectedCompositesIntenseGenerics = md.selection.getSelected(Composite.class);
            this.selectedComposites = selectedCompositesIntenseGenerics;
            this.selectedLeaves = md.selection.getSelected(IMerlinObj.class);
        }

        public boolean enqueue(IDomainObject obj, String mdRootClassName) {
            if (Paste.isUnsupported(this.handlers, obj, mdRootClassName)) {
                this.warnings.accept(CopyPasteUtil.getPasteSupportWarning(obj, false));
                return false;
            }
            Optional<Object> result = Optional.empty();
            for (PasteHandler ph : this.handlers) {
                if (!ph.isHandlerFor(obj, mdRootClassName)) continue;
                result = Optional.of(ph);
                break;
            }
            if (result.isPresent()) {
                PasteHandler ph = (PasteHandler)result.get();
                Composite<IMerlinObj> defaultRoot = CopyPasteUtil.getDefaultRoot(this.md, obj, mdRootClassName);
                IDomainObject pasteLoc = ph.getPasteLocation(this.md, defaultRoot, obj, this.selectedComposites, this.selectedLeaves);
                if (!CopyPasteUtil.validInsertRoot(ph.getClass(), obj, pasteLoc, this.warnings)) {
                    return false;
                }
                PasteHints hints = ph.getPasteHints(this.md, obj);
                this.pasteQueue.put(obj, new ObjPasteInfo(ph, hints, mdRootClassName, pasteLoc));
                return true;
            }
            this.warnings.accept(CopyPasteUtil.getPasteSupportWarning(obj, false));
            return false;
        }

        public void remove(IDomainObject obj) {
            this.pasteQueue.remove(obj);
        }

        public void removeNonPasteableFromComposites(Predicate<? super IDomainObject> isPasteable) {
            this.pasteQueue.keySet().forEach(o -> PasteQueue.removeNonPasteableFromComposites(isPasteable, o));
        }

        private static void removeNonPasteableFromComposites(Predicate<? super IDomainObject> isPasteable, IDomainObject pasteObj) {
            if (pasteObj instanceof Composite) {
                Composite comp = (Composite)pasteObj;
                List<? super IDomainObject> toRemove = comp.getMembers().stream().filter(isPasteable.negate()).toList();
                comp.removeAll(toRemove);
            }
            if (pasteObj instanceof IMerlinObj) {
                IMerlinObj mobj = (IMerlinObj)pasteObj;
                for (IMerlinObj iMerlinObj : mobj.getChildren()) {
                    PasteQueue.removeNonPasteableFromComposites(isPasteable, iMerlinObj);
                }
            }
        }

        public void paste(VentusApp app) {
            boolean shouldPromptForTransform = this.pasteQueue.values().stream().anyMatch(info -> info.hints.geomTransformShouldPrompt);
            if (shouldPromptForTransform) {
                TransformInfo moveInfo = Paste.promptForTransformParameter(app.getActiveFrame(), this.md);
                this.pasteQueue.values().forEach(pair -> {
                    pair.hints.geomTransform = moveInfo;
                });
            }
            LinkedIdentityHashSet pastedObjs = new LinkedIdentityHashSet();
            for (Map.Entry<IDomainObject, ObjPasteInfo> pasteObjMapEntry : this.pasteQueue.entrySet()) {
                ObjPasteInfo info2 = pasteObjMapEntry.getValue();
                info2.handler.pasteApply(this.md, app, this.pasteQueue::containsKey, pasteObjMapEntry.getKey(), info2.rootName, info2.pasteLoc, info2.hints, pastedObjs::add, this.warnings);
            }
            Undo.insertUndoEntry_restoreSelection(this.md);
            this.md.selection.set(pastedObjs);
        }
    }

    private record ObjPasteInfo(PasteHandler handler, PasteHints hints, String rootName, IDomainObject pasteLoc) {
    }
}

