/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.VentusApp;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.mv.displays.GlobalDisplayMgr;
import ventus.util.MerlinUtil;

public class Visibility {
    public static void setVisibility(VentusData md, Collection<?> toShow, Collection<?> toHide, boolean hideFirst) {
        Function<Collection, Set> flattenToSupported = coll -> new LinkedIdentityHashSet<IMerlinObj>(MerlinUtil.flatten(coll, IMerlinObj.class, o -> o.isSupportedLocally(VentusData.VISIBILITY)));
        Set showObjs = flattenToSupported.apply(toShow);
        Set hideObjs = flattenToSupported.apply(toHide);
        if (Visibility.containsClipped(md, toShow)) {
            hideObjs.removeAll(md.floors.getMembers());
            showObjs.addAll(md.floors.getMembers());
        }
        Consumer<Set> insertRestoreVis = objs -> objs.forEach(obj -> obj.insertUndoEntry_propRestore(VentusData.VISIBILITY));
        if (hideFirst) {
            hideObjs.removeAll(showObjs);
            Undo.insertUndoEntry_restoreSelection(md);
            insertRestoreVis.accept(hideObjs);
            insertRestoreVis.accept(showObjs);
            Visibility.setVisibility(md, hideObjs, false);
            Visibility.setVisibility(md, showObjs, true);
        } else {
            showObjs.removeAll(hideObjs);
            Undo.insertUndoEntry_restoreSelection(md);
            insertRestoreVis.accept(showObjs);
            insertRestoreVis.accept(hideObjs);
            Visibility.setVisibility(md, showObjs, true);
            Visibility.setVisibility(md, hideObjs, false);
        }
    }

    private static boolean containsClipped(VentusData md, Collection<?> objs) {
        VentusApp app = VentusApp.getApp();
        if (app == null) {
            return false;
        }
        GlobalDisplayMgr dispMgr = app.getModelView().getDisplayManager();
        for (Object o : MerlinUtil.flatten(objs)) {
            if (!dispMgr.isClippedByFloor(o)) continue;
            return true;
        }
        return false;
    }

    private static void setVisibility(VentusData vd, Collection<? extends IMerlinObj> objs, boolean visibility) {
        for (IMerlinObj iMerlinObj : objs) {
            EntryPoint<IMerlinObj> ep = EntryPointFactory.get(iMerlinObj);
            ep.setVisible(vd, iMerlinObj, visibility);
        }
    }
}

