/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.FloorSortActions;
import ventus.actions.SubtractAction;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.IMerlinGeomSrc;
import ventus.util.MerlinUtil;

public class TransformAction
extends AMerlinOp {
    @Override
    public void run(VentusApp app, VentusData md) {
    }

    public static Collection<IMerlinGeomSrc> getGeom(VentusData md, Collection<? extends IMerlinObj> objs) {
        return MerlinUtil.flatten(objs, IMerlinGeomSrc.class);
    }

    public static Set<IMerlinObj> getValidObjs(VentusData md) {
        Set<IMerlinObj> selObjs = md.selection.getSelected(IMerlinObj.class);
        TransformAction.flattenRoots(md, selObjs);
        return MerlinUtil.filter(selObjs, new Predicate<IMerlinObj>(){

            @Override
            public boolean test(IMerlinObj o) {
                if (o instanceof Composite) {
                    return !((Composite)o).getDeepMembers(IMerlinGeomSrc.class).isEmpty();
                }
                return o instanceof IMerlinGeomSrc;
            }
        });
    }

    private static Collection<? extends IMerlinObj> promoteSelection(VentusData md, Set<IMerlinObj> selection) {
        LinkedIdentityHashSet<IMerlinObj> newSelObjs = new LinkedIdentityHashSet<IMerlinObj>();
        ArrayList<Object> remSelObjs = new ArrayList<Object>();
        LinkedIdentityHashSet testParents = new LinkedIdentityHashSet();
        while (true) {
            for (IMerlinObj obj : selection) {
                Object parent;
                if (newSelObjs.contains(obj) || !((parent = md.hierarchy.getParent(obj)) instanceof IMerlinObj)) continue;
                testParents.add((IMerlinObj)parent);
            }
            for (IMerlinObj parent : testParents) {
                if (TransformAction.containsAncestor(newSelObjs, selection, md, parent) || !selection.containsAll(md.hierarchy.getChildren(parent))) continue;
                newSelObjs.add(parent);
                remSelObjs.addAll(md.hierarchy.getChildren(parent));
            }
            if (newSelObjs.isEmpty() && remSelObjs.isEmpty()) break;
            selection.removeAll(remSelObjs);
            selection.addAll(newSelObjs);
            newSelObjs.clear();
            remSelObjs.clear();
            testParents.clear();
        }
        return selection;
    }

    private static boolean containsAncestor(Set<IMerlinObj> set1, Set<IMerlinObj> set2, VentusData md, Object obj) {
        while (obj instanceof IMerlinObj) {
            if (set1.contains(obj) || set2.contains(obj)) {
                return true;
            }
            obj = md.hierarchy.getParent(obj);
        }
        return false;
    }

    private static void flattenRoots(VentusData md, Set<IMerlinObj> objs) {
        ArrayList<IMerlinObj> toAdd = new ArrayList<IMerlinObj>();
        ArrayList<IMerlinObj> toRemove = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : objs) {
            TransformAction.flattenRoots(md, obj, toAdd, toRemove);
        }
        objs.removeAll(toRemove);
        objs.addAll(toAdd);
    }

    private static boolean flattenRoots(VentusData md, IMerlinObj obj, List<IMerlinObj> addObjs, List<IMerlinObj> removeObjs) {
        if (!(obj instanceof Composite)) {
            return false;
        }
        Composite group = (Composite)obj;
        if (TransformAction.isDuplicateRoot(md, group)) {
            removeObjs.add(group);
            for (IMerlinObj child : group.getMembers()) {
                if (TransformAction.flattenRoots(md, child, addObjs, removeObjs)) continue;
                addObjs.add(child);
            }
            return true;
        }
        return false;
    }

    private static boolean isDuplicateRoot(VentusData md, Composite<?> group) {
        return group instanceof Floor || md.getChildren().contains(group);
    }

    public static List<List<IMerlinObj>> transform(VentusApp app, VentusData md, Consumer<? super SchematicRoom> toClean, Collection<? extends IMerlinObj> objs, int numCopies, TransformInfo ... xforms) {
        return TransformAction.transformImpl(app, md, toClean, objs, numCopies, xforms);
    }

    public static int getSubtractOptions(TransformInfo ... xforms) {
        int sopts = 0;
        boolean noScaling = Stream.of(xforms).map(ti -> ti.xform).allMatch(xform -> TransformUtil.findTransformLastToFirst(xform, TransformUtil.SCALING_FILTER) == null);
        if (noScaling) {
            sopts |= 1;
        }
        return sopts;
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<IMerlinObj>> transformImpl(VentusApp app, VentusData md, Consumer<? super SchematicRoom> toClean, Collection<? extends IMerlinObj> objs, int numCopies, TransformInfo ... xforms) {
        void var13_24;
        assert (numCopies == 0 && xforms.length == 1 || xforms.length == numCopies);
        int sopts = TransformAction.getSubtractOptions(xforms);
        if (numCopies == 0) {
            LinkedIdentityHashSet<IMerlinObj> srcObjs = new LinkedIdentityHashSet<IMerlinObj>((Collection<IMerlinObj>)objs);
            Predicate<IMerlinObj> copyXformFilter = TransformAction.getCopyXformFilter(md, srcObjs);
            Collection<IMerlinObj> rest = MerlinUtil.flatten(srcObjs, IMerlinObj.class);
            Undo.insertUndoEntry_restore(md, rest);
            TransformInfo xform = xforms[0];
            ArrayList<SchematicRoom> subtractors = new ArrayList<SchematicRoom>();
            for (IMerlinGeomSrc iMerlinGeomSrc : TransformAction.getGeom(md, theUtil.filter(srcObjs, copyXformFilter))) {
                iMerlinGeomSrc.transform(xform);
                if (!(iMerlinGeomSrc instanceof SchematicRoom)) continue;
                subtractors.add((SchematicRoom)iMerlinGeomSrc);
            }
            SubtractAction.subtract(app, md, sopts, toClean, subtractors);
            Collection<ISchematicComp> sortable = FloorSortActions.getSortableObjs(md, srcObjs);
            FloorSortActions.updateComponentFloors(md, sortable);
            return Collections.EMPTY_LIST;
        }
        LinkedIdentityHashSet<IMerlinObj> srcObjs = new LinkedIdentityHashSet<IMerlinObj>((Collection<IMerlinObj>)objs);
        Predicate<IMerlinObj> copyXformFilter = TransformAction.getCopyXformFilter(md, srcObjs);
        ArrayList<List<IMerlinObj>> newObjs = new ArrayList<List<IMerlinObj>>(numCopies);
        int copy = 0;
        TransformInfo[] subtractors = xforms;
        int sortable = subtractors.length;
        boolean bl = false;
        while (var13_24 < sortable) {
            TransformInfo ti = subtractors[var13_24];
            LinkedIdentityHashMap<IMerlinObj, IMerlinObj> copyMap = new LinkedIdentityHashMap<IMerlinObj, IMerlinObj>();
            ArrayList<IMerlinObj> copiedObjs = new ArrayList<IMerlinObj>(objs.size());
            newObjs.add(copiedObjs);
            String copyNamePostfix = String.format(Intl.intl("_%s"), ++copy);
            for (IMerlinObj obj : theUtil.filter(srcObjs, copyXformFilter)) {
                IMerlinObj newObj = TransformAction.copy(md, copyMap, ti, obj);
                if (newObj == obj) continue;
                TransformAction.renameCopy(newObj, copyNamePostfix);
                Composite parent = (Composite)md.hierarchy.getParent(obj);
                Undo.insertUndoEntry_delete(md, parent, newObj);
                parent.add(newObj);
                copiedObjs.add(newObj);
            }
            TransformAction.fixRefs(srcObjs, copyMap);
            ++var13_24;
        }
        ArrayList<ISchematicComp> sortableComps = new ArrayList<ISchematicComp>();
        for (List list : newObjs) {
            sortableComps.addAll(FloorSortActions.getSortableObjs(md, list));
        }
        FloorSortActions.updateComponentFloors(md, sortableComps);
        for (int m = 0; m < newObjs.size(); ++m) {
            ArrayList arrayList = new ArrayList((Collection)newObjs.get(m));
            for (int n = m + 1; n < newObjs.size(); ++n) {
                arrayList.addAll((Collection)newObjs.get(n));
            }
            Collection<SchematicRoom> newXformedRooms = MerlinUtil.flatten(arrayList, SchematicRoom.class);
            newXformedRooms.forEach(toClean);
            SubtractAction.subtract(app, md, sopts, toClean, newXformedRooms);
        }
        md.selection.clear();
        for (List list : newObjs) {
            for (IMerlinObj obj : list) {
                if (md.hierarchy.getParent(obj) == null) continue;
                md.selection.select(obj);
            }
        }
        return newObjs;
    }

    private static void renameCopy(IMerlinObj newObj, String copyNamePostfix) {
        if (newObj instanceof INamed) {
            String newName = ((INamed)((Object)newObj)).getName() + copyNamePostfix;
            ((INamed)((Object)newObj)).setName(newName);
        }
        if (!(newObj instanceof Composite)) {
            for (IMerlinObj iMerlinObj : newObj.getChildren()) {
                TransformAction.renameCopy(iMerlinObj, copyNamePostfix);
            }
        }
    }

    private static IMerlinObj copy(VentusData md, Map<IMerlinObj, IMerlinObj> copyMap, TransformInfo ti, IMerlinObj obj) {
        Object copiedObj;
        if (obj instanceof Composite) {
            Composite group = (Composite)obj;
            Object newGroup = group.clone();
            ((Composite)newGroup).clear();
            for (IMerlinObj child : group.getMembers()) {
                ((Composite)newGroup).add(TransformAction.copy(md, copyMap, ti, child));
            }
            copiedObj = newGroup;
        } else if (obj instanceof IMerlinGeomSrc) {
            IMerlinGeomSrc newObj = (IMerlinGeomSrc)((IMerlinGeomSrc)((Object)obj)).clone();
            newObj.transform(ti);
            copiedObj = (IMerlinObj)((Object)newObj);
        } else {
            copiedObj = (IMerlinObj)obj.clone();
        }
        copyMap.put(obj, (IMerlinObj)copiedObj);
        return copiedObj;
    }

    private static Predicate<IMerlinObj> getCopyXformFilter(VentusData md, Set<IMerlinObj> xformObjs) {
        IdentityHashSet excludeObjs = new IdentityHashSet();
        return Filters.reject(excludeObjs);
    }

    private static void fixRefs(Collection<? extends IMerlinObj> copyObjs, Map<IMerlinObj, IMerlinObj> copyMap) {
        for (IMerlinObj obj : MerlinUtil.flatten(copyObjs, IMerlinObj.class)) {
            if ((obj = copyMap.get(obj)) != null) continue;
        }
    }
}

