/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Delete;
import ventus.actions.Undo;
import ventus.actions.geomops.SeparateGeom;
import ventus.data.AMerlinObj;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.util.BitOptions;

public class SubtractAction {
    public static final int OPT_EXCLUDE_SUBTRACT_COMPONENTS = 1;
    public static final int OPT_NO_SEPARATE_ROOMS = 2;
    public static final int OPT_FILE_LOAD = 4;

    public static void subtract(VentusApp app, VentusData md, int options, Consumer<? super SchematicRoom> toClean, SchematicRoom ... subComps) {
        SubtractAction.subtract(app, md, options, toClean, Arrays.asList(subComps));
    }

    public static void subtract(VentusApp app, VentusData md, int options, Consumer<? super SchematicRoom> toClean, BiConsumer<? super SchematicRoom, ? super SchematicRoom> separatedRooms, SchematicRoom ... subComps) {
        SubtractAction.subtract(app, md, options, toClean, separatedRooms, Arrays.asList(subComps));
    }

    public static void subtract(VentusApp app, VentusData md, int options, Consumer<? super SchematicRoom> toClean, Collection<SchematicRoom> subComps) {
        SubtractAction.subtract(app, md, options, toClean, (? super SchematicRoom keyRoom, ? super SchematicRoom childRoom) -> {}, subComps);
    }

    public static void subtract(VentusApp app, VentusData md, int options, Consumer<? super SchematicRoom> toClean, BiConsumer<? super SchematicRoom, ? super SchematicRoom> separatedRooms, Collection<SchematicRoom> subComps) {
        BitOptions opts = new BitOptions(options);
        Map<SchematicRoom, List<SchematicRoom>> subMap = SubtractAction.getReplaceMap(app, md, opts, subComps);
        if (subMap.isEmpty()) {
            subComps.forEach(toClean);
            return;
        }
        md.pauseUpdates();
        if (!opts.get(4L)) {
            Undo.begin(Intl.intl("Subtract"));
        }
        SubtractAction.performSubtract(subComps, subMap, opts, md, toClean, separatedRooms);
        if (!opts.get(4L)) {
            Undo.end(md);
        }
        md.resumeUpdates();
    }

    public static Map<SchematicRoom, List<SchematicRoom>> getReplaceMap(VentusApp app, VentusData md, int opts, Collection<SchematicRoom> subComps) {
        return SubtractAction.getReplaceMap(app, md, new BitOptions(opts), subComps);
    }

    private static Map<SchematicRoom, List<SchematicRoom>> getReplaceMap(VentusApp app, VentusData md, BitOptions opts, Collection<SchematicRoom> subComps) {
        Set exclusionsSet = Collections.EMPTY_SET;
        if (opts.get(1L)) {
            exclusionsSet = subComps instanceof Set ? (Set<Object>)subComps : new IdentityHashSet<SchematicRoom>(subComps);
        }
        LinkedIdentityHashMap<SchematicRoom, List<SchematicRoom>> subMap = new LinkedIdentityHashMap<SchematicRoom, List<SchematicRoom>>();
        for (SchematicRoom subComp : subComps) {
            List<SchematicRoom> potSubtractors = SubtractAction.findNearComponents(md, subComp, exclusionsSet);
            for (SchematicRoom potSubtractor : potSubtractors) {
                ArrayList<SchematicRoom> potSubComps;
                SchematicRoom keep = subComp;
                SchematicRoom replace = potSubtractor;
                if (!potSubtractor.getModificationsAllowed()) {
                    keep = potSubtractor;
                    replace = subComp;
                }
                if ((potSubComps = (ArrayList<SchematicRoom>)subMap.get(replace)) == null) {
                    potSubComps = new ArrayList<SchematicRoom>();
                    subMap.put(replace, potSubComps);
                }
                potSubComps.add(keep);
            }
        }
        return subMap;
    }

    private static void performSubtract(Collection<SchematicRoom> subComps, Map<SchematicRoom, List<SchematicRoom>> subMap, BitOptions opts, VentusData md, Consumer<? super SchematicRoom> toClean, BiConsumer<? super SchematicRoom, ? super SchematicRoom> separated) {
        LinkedIdentityHashSet toDelete = new LinkedIdentityHashSet();
        for (Map.Entry<SchematicRoom, List<SchematicRoom>> entry : subMap.entrySet()) {
            SchematicRoom potSubtractor = entry.getKey();
            if (!potSubtractor.getModificationsAllowed()) continue;
            AMerlinObj momento = potSubtractor.getRestoreObj();
            boolean subtracted = false;
            for (SchematicRoom subtract : entry.getValue()) {
                if (!(subtracted |= potSubtractor.sub(subtract))) continue;
                toClean.accept(subtract);
            }
            if (!subtracted) continue;
            if (!opts.get(4L)) {
                Undo.insertUndoEntry_restore(md, (IMerlinObj)potSubtractor, momento);
            }
            if (!opts.get(2L)) {
                SeparateGeom.separate(md, Collections.singleton(potSubtractor), toClean, separated);
            }
            if (potSubtractor.getRoomArea() == 0.0) {
                toDelete.add(potSubtractor);
                continue;
            }
            toClean.accept(potSubtractor);
        }
        Delete.headlessDelete(md, toDelete, false);
    }

    private static List<SchematicRoom> findNearComponents(VentusData md, final ISchematicComp comp, final Set<SchematicRoom> exclusions) {
        AABoxTest test = new AABoxTest(comp.getBounds(), 1.0E-6);
        final ArrayList<SchematicRoom> nearComps = new ArrayList<SchematicRoom>();
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc src, Containment ctmt) {
                if (src instanceof SchematicRoom && src != comp && !exclusions.contains(src)) {
                    nearComps.add((SchematicRoom)src);
                }
            }
        };
        md.geomLocation.getLocator().find((ITest<AABox>)test, (IResult<? super IDisplayableGeomSrc>)result, 3);
        return nearComps;
    }
}

