/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.data.camera.IViewObj;

public class ShowView
extends AMerlinOp
implements IEventObserver {
    public static final UIHook CONTEXT_HOOK = new UIHook(new ShowView(), Intl.intl("Show in 3D View,-,Shows the 3D view from the view's perspective."));

    public ShowView() {
        SelectionObserver.add(this, IViewObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(this.getEnabled());
    }

    private boolean getEnabled() {
        VentusData md = VentusApp.getApp().getData();
        if (!md.selection.isExclusive(IViewObj.class)) {
            return false;
        }
        Set sel = md.selection.getSelected(IViewObj.class);
        return sel.size() == 1;
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set selCameras = md.selection.getSelected(IViewObj.class);
        if (selCameras.isEmpty()) {
            return;
        }
        ShowView.showIn3DView(md, (IViewObj)selCameras.iterator().next());
    }

    public static void showIn3DView(VentusData md, IViewObj cam) {
        VentusApp.getApp().getModelView().applyCamera(cam.getCameraState());
    }
}

