/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.ShowReferencingObjects;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;

public class SelectReferencing
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectReferencing(), Intl.intl("Select Referencing Objects"));

    public SelectReferencing() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusData vd = VentusApp.getApp().getData();
        this.setEnabled(!vd.selection.isDeepEmpty(IMerlinObj.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Select Referencing Objects"));
            Undo.insertUndoEntry_restoreSelection(md);
            Set<IMerlinObj> referencing = ShowReferencingObjects.getReferencing(md);
            md.selection.set(referencing);
            Undo.end(md);
        }
    }
}

