/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import javax.swing.JOptionPane;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicComp;

public class SelectConnectedComps
extends AMerlinOp
implements IEventObserver {
    private static final String ADJACENT = Intl.intl("Immediately adjacent");
    private static final String ALL = Intl.intl("Entire graph");
    public static final UIHook UI_HOOK = new UIHook(new SelectConnectedComps(), Intl.intl("Select Connected Components"));
    private String d_defOption = ADJACENT;

    public SelectConnectedComps() {
        SelectionObserver.add(this, ISchematicComp.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusApp app = VentusApp.getApp();
        VentusData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(ISchematicComp.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set<ISchematicComp> connected;
        Object[] optionsList = new String[]{ADJACENT, ALL};
        Object selectedOption = JOptionPane.showInputDialog(app.getActiveFrame(), Intl.intl("Which connected components should be selected?"), Intl.intl("Select Connected Components"), 3, null, optionsList, this.d_defOption);
        Undo.begin(Intl.intl("Select Connected Components"));
        Set comps = md.selection.getDeepSelected(ISchematicComp.class);
        if (selectedOption == ADJACENT) {
            connected = SelectConnectedComps.getAdjacentComps(md, comps);
        } else if (selectedOption == ALL) {
            connected = SelectConnectedComps.getConnectedComps(md, comps);
        } else {
            return;
        }
        this.d_defOption = (String)selectedOption;
        Undo.insertUndoEntry_restoreSelection(md);
        md.selection.selectAll(connected);
        Undo.end(md);
    }

    public static Set<ISchematicComp> getAdjacentComps(VentusData md, Collection<? extends ISchematicComp> nodes) {
        LinkedIdentityHashSet<ISchematicComp> connected = new LinkedIdentityHashSet<ISchematicComp>();
        for (ISchematicComp iSchematicComp : nodes) {
            Collection<? extends ISchematicObj> x = iSchematicComp.getConnections();
            for (ISchematicObj iSchematicObj : x) {
                if (!(iSchematicObj instanceof ISchematicComp)) continue;
                connected.add((ISchematicComp)iSchematicObj);
            }
        }
        return connected;
    }

    public static Set<ISchematicComp> getConnectedComps(VentusData md, Collection<? extends ISchematicComp> nodes) {
        LinkedIdentityHashSet<ISchematicComp> closed = new LinkedIdentityHashSet<ISchematicComp>((Collection<ISchematicComp>)nodes);
        ArrayDeque<? extends ISchematicComp> open = new ArrayDeque<ISchematicComp>(nodes);
        while (!open.isEmpty()) {
            ISchematicComp elem = (ISchematicComp)open.pop();
            for (ISchematicObj iSchematicObj : elem.getConnections()) {
                if (!(iSchematicObj instanceof ISchematicComp) || !closed.add((ISchematicComp)iSchematicObj)) continue;
                open.push((ISchematicComp)iSchematicObj);
            }
        }
        return closed;
    }
}

