/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import thunderheadeng.gui.dialogs.CustomKeyAcceleratorDlg;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.io.KeyboardAcceleratorIO;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Shortcut;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.actions.VentusShortcuts;
import ventus.builders.ToolName;
import ventus.feature.comps.IHotkey;
import ventus.gui.guiUtil;
import ventus.mv.ModelView;

public class MerlinActionMap {
    private final ModelView d_modelView;
    private final Map<String, Shortcut> s_idToShortcutMap;
    private final Map<String, Tool> toolNameToolMap;
    private final Collection<ToolName> viewSwitchTools = Arrays.asList(ToolName.PERSPECTIVE_VIEW, ToolName.TOP_VIEW, ToolName.FRONT_VIEW, ToolName.LEFT_VIEW);

    public MerlinActionMap(VentusApp app, ModelView mv) {
        this.d_modelView = mv;
        this.s_idToShortcutMap = new HashMap<String, Shortcut>();
        this.toolNameToolMap = new HashMap<String, Tool>();
        ToolManager tm = this.d_modelView.getTools();
        for (Tool t : tm.getTools()) {
            this.toolNameToolMap.put(tm.getToolAction(t).getName(), t);
        }
        for (Shortcut sc : this.getShortcuts()) {
            this.s_idToShortcutMap.put(sc.getKey(), sc);
        }
        this.d_modelView.mapShortcuts();
    }

    private Collection<Shortcut> getShortcuts() {
        Collection<Shortcut> shortcuts = VentusShortcuts.getAll();
        VentusApp.getApp().getComponents(IHotkey.class).forEach(obj -> shortcuts.add(obj.getKeyboardShortcut()));
        return shortcuts;
    }

    public void updateShortcuts(Map<String, KeyStroke> newKeyStrokeValues) {
        for (Map.Entry<String, KeyStroke> kvPair : newKeyStrokeValues.entrySet()) {
            Shortcut sc = this.s_idToShortcutMap.get(kvPair.getKey());
            String ksString = kvPair.getValue() == null ? "" : kvPair.getValue().toString();
            sc.setKeystroke(ksString);
        }
        this.updateActions();
    }

    private void updateActions() {
        BiConsumer<Shortcut, String> viewSwitchUpdater = (sc, name) -> {
            KeyStroke ks = KeyStroke.getKeyStroke(sc.getKeystroke());
            guiUtil.keyboardShortcutUpdate(this.d_modelView.getViewsToolbar(), ks, name);
        };
        for (Shortcut sc2 : this.getShortcuts()) {
            Object operator = sc2.getOperator();
            if (operator instanceof UIHook) {
                KeyStroke ks = KeyStroke.getKeyStroke(sc2.getKeystroke());
                ((UIHook)operator).setKeyStroke(ks);
                continue;
            }
            if (!(operator instanceof ToolName)) continue;
            ToolName toolName = (ToolName)((Object)operator);
            if (this.viewSwitchTools.contains((Object)toolName)) {
                viewSwitchUpdater.accept(sc2, toolName.get());
                continue;
            }
            ToolManager tm = this.d_modelView.getTools();
            KeyStroke ks = KeyStroke.getKeyStroke(sc2.getKeystroke());
            ToolManager.ToolProps tp = tm.getProps(this.toolNameToolMap.get(toolName.get()));
            guiUtil.keyboardShortcutUpdate(tp.toolbarBtn, ks, tp.action.getTool());
        }
    }

    public KeyStroke getKeyStrokeForActionKey(String key) {
        Shortcut sc = this.s_idToShortcutMap.get(key);
        return KeyStroke.getKeyStroke(sc.getKeystroke());
    }

    public KeyStroke getDefaultKeyStrokeForActionKey(String key) {
        Shortcut sc = this.s_idToShortcutMap.get(key);
        return KeyStroke.getKeyStroke(sc.getDefaultKeystroke());
    }

    private String getActionNameForShortcut(Shortcut sc) {
        if (sc.hasOverrideName()) {
            return sc.getOverrideName();
        }
        if (sc.getOperator() instanceof UIHook) {
            return (String)((UIHook)sc.getOperator()).getValue("Name");
        }
        if (sc.getOperator() instanceof ToolName) {
            return ((ToolName)((Object)sc.getOperator())).get();
        }
        assert (false) : sc.getKey() + " isn't in the map!";
        return "";
    }

    private String getActionNameForActionKey(String key) {
        Shortcut sc = this.s_idToShortcutMap.get(key);
        return this.getActionNameForShortcut(sc);
    }

    private String getTooltipForActionKey(String key) {
        Tool tool;
        Shortcut sc = this.s_idToShortcutMap.get(key);
        AbstractAction action = null;
        if (sc.getOperator() instanceof UIHook) {
            action = (UIHook)sc.getOperator();
        } else if (sc.getOperator() instanceof ToolName && (tool = this.toolNameToolMap.get(((ToolName)((Object)sc.getOperator())).get())) != null) {
            ToolManager tm = this.d_modelView.getTools();
            action = tm.getProps((Tool)tool).action;
        }
        if (action != null) {
            String longDesc = (String)action.getValue("LongDescription");
            if (longDesc != null && longDesc != "") {
                return longDesc;
            }
            return (String)action.getValue("ShortDescription");
        }
        return null;
    }

    public KeyboardAcceleratorIO.IKeyboardAcceleratorHelper getIoHelper(VentusApp app) {
        return new MerlinKeyboardAcceleratorIOHelper(app, this);
    }

    public CustomKeyAcceleratorDlg.ICustomKeyUIHelper getUiHelper() {
        return new MerlinCustomUIHelper(this);
    }

    private static String getLabelForShortcutType(ShortcutInfo.Category type) {
        switch (type) {
            case FILE: {
                return Intl.intl("File");
            }
            case EDIT: {
                return Intl.intl("Edit");
            }
            case MODEL: {
                return Intl.intl("Model");
            }
            case VIEW: {
                return Intl.intl("View");
            }
            case SIMULATION: {
                return Intl.intl("Simulation");
            }
            case RESULTS: {
                return Intl.intl("Results");
            }
            case HELP: {
                return Intl.intl("Help");
            }
            case SELECTION: {
                return Intl.intl("Selection");
            }
            case CONTEXT: {
                return Intl.intl("Context");
            }
            case TOOL: {
                return Intl.intl("Tool");
            }
        }
        return Intl.intl("General");
    }

    private List<String> getActionKeysForShortcutType(ShortcutInfo.Category type) {
        Collection<Shortcut> scs = this.getShortcutsForShortcutType(type);
        ArrayList<String> actionKeys = new ArrayList<String>();
        for (Shortcut sc : scs) {
            actionKeys.add(sc.getKey());
        }
        return actionKeys;
    }

    private Collection<Shortcut> getShortcutsForShortcutType(ShortcutInfo.Category type) {
        return theUtil.filter(this.getShortcuts(), sc -> sc.getCategory().equals((Object)type));
    }

    private static class MerlinKeyboardAcceleratorIOHelper
    implements KeyboardAcceleratorIO.IKeyboardAcceleratorHelper {
        private final VentusApp d_merApp;
        private final MerlinActionMap d_merMap;

        public MerlinKeyboardAcceleratorIOHelper(VentusApp app, MerlinActionMap merMap) {
            this.d_merApp = app;
            this.d_merMap = merMap;
        }

        @Override
        public String getDefaultFileLocation() {
            return this.d_merApp.getAppDataDir() + "keybindings.json";
        }

        @Override
        public void updateActionMap(Map<String, KeyStroke> newKeyStrokeValues) {
            this.d_merMap.updateShortcuts(newKeyStrokeValues);
        }

        @Override
        public Collection<String> getSortedActionList() {
            return this.d_merMap.s_idToShortcutMap.values().stream().map(sc -> sc.getKey()).sorted().collect(Collectors.toList());
        }

        @Override
        public KeyStroke getKeyStrokeForActionKey(String key) {
            return this.d_merMap.getKeyStrokeForActionKey(key);
        }
    }

    private static class MerlinCustomUIHelper
    implements CustomKeyAcceleratorDlg.ICustomKeyUIHelper {
        private final MerlinActionMap d_merMap;

        public MerlinCustomUIHelper(MerlinActionMap merMap) {
            this.d_merMap = merMap;
        }

        @Override
        public KeyStroke getKeyStrokeForID(String id) {
            return this.d_merMap.getKeyStrokeForActionKey(id);
        }

        @Override
        public KeyStroke getDefaultKeyStrokeForID(String id) {
            return this.d_merMap.getDefaultKeyStrokeForActionKey(id);
        }

        @Override
        public String getActionNameForID(String id) {
            return this.d_merMap.getActionNameForActionKey(id);
        }

        @Override
        public String getTooltipForID(String id) {
            return this.d_merMap.getTooltipForActionKey(id);
        }

        @Override
        public void saveToActionMap(Map<String, KeyStroke> keystrokes) {
            this.d_merMap.updateShortcuts(keystrokes);
        }

        @Override
        public Collection<Pair<String, Collection<String>>> getTabStrings() {
            ArrayList<Pair<String, Collection<String>>> tabList = new ArrayList<Pair<String, Collection<String>>>();
            for (ShortcutInfo.Category type : ShortcutInfo.Category.values()) {
                String labelForType = MerlinActionMap.getLabelForShortcutType(type);
                List<String> actionKeys = type.equals((Object)ShortcutInfo.Category.TOOL) || type.equals((Object)ShortcutInfo.Category.SELECTION) || type.equals((Object)ShortcutInfo.Category.CONTEXT) ? this.getSortedActionKeys(type) : this.d_merMap.getActionKeysForShortcutType(type);
                tabList.add(new Pair<String, List<String>>(labelForType, actionKeys));
            }
            return tabList;
        }

        private List<String> getSortedActionKeys(ShortcutInfo.Category type) {
            Collection<Shortcut> scs = this.d_merMap.getShortcutsForShortcutType(type);
            HashMap<String, String> idToNameMap = new HashMap<String, String>();
            for (Shortcut sc : scs) {
                idToNameMap.put(sc.getKey(), this.getActionNameForID(sc.getKey()));
            }
            ArrayList asList = new ArrayList(idToNameMap.entrySet());
            asList.sort(Map.Entry.comparingByValue());
            ArrayList<String> sortedVals = new ArrayList<String>();
            for (Map.Entry entry : asList) {
                sortedVals.add((String)entry.getKey());
            }
            return sortedVals;
        }
    }
}

