/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.IntPredicate;
import javax.swing.JOptionPane;
import thunderheadeng.geometry.objs.node.GeomNodesMerger;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.Deletion;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.Delete;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.ImportType;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.util.MerlinUtil;

public class MergeImportedGeomAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new MergeImportedGeomAction(), Intl.intl("Merge selected objects,-,Merge the selected objects into a single object."));

    public MergeImportedGeomAction() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        this.setEnabled(MergeImportedGeomAction.testSelection(md));
    }

    public static boolean testSelection(VentusData md) {
        IFilteredCollection<IMerlinObj> igeom = MergeImportedGeomAction.getObjs(md);
        return !md.selection.flatten(ImportedGeom.class).isEmpty() && MergeImportedGeomAction.testFilteredSize(MerlinUtil.flatten(igeom), size -> size >= 2) && igeom.isExclusive();
    }

    public static IFilteredCollection<IMerlinObj> getObjs(VentusData md) {
        return md.selection.get(IMerlinObj.class, obj -> obj instanceof ImportedGeom || obj instanceof GeomComposite && md.hierarchy.isDescendent(md.sceneGeom, obj));
    }

    private static boolean testFilteredSize(Collection<?> coll, IntPredicate testSize) {
        int size = 0;
        if (testSize.test(size)) {
            return true;
        }
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            if (testSize.test(++size)) {
                return true;
            }
            it.next();
        }
        return false;
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Optional<Runnable> task = MergeImportedGeomAction.startUiMerge(app, md, MergeImportedGeomAction.getObjs(md));
        if (task.isEmpty()) {
            return;
        }
        task.get().run();
    }

    public static Optional<Runnable> startUiMerge(VentusApp app, VentusData md, Collection<IMerlinObj> objs) {
        Runnable delTask = () -> {};
        ArrayList<IMerlinObj> toRemove = new ArrayList<IMerlinObj>(objs);
        Collection<ImportedGeom> igeoms = MerlinUtil.flatten(objs, ImportedGeom.class);
        ImportType importType = igeoms.iterator().next().getImportedType();
        Collection<ImportType> importTypes = theUtil.map(igeoms, ig -> ig.get(ImportedGeom.PROP_IMPORTED_TYPE));
        if (!theUtil.isUniform(importTypes)) {
            Pair<ImportType, Integer> maxType = theUtil.getMaxOccurrence(importTypes, ImportType.class);
            assert (maxType != null);
            importType = (ImportType)((Object)maxType.v1);
            int option = md.ui(() -> JOptionPane.showConfirmDialog(app.getActiveFrame(), String.format("<html>" + Intl.intl("The selected objects have different <b>Import Types</b>. The resulting object be assigned<br>\"%s\", which can be changed in the property panel."), ((ImportType)((Object)((Object)maxType.v1))).name), Intl.intl("Different BIM Types"), 2, 2));
            if (option != 0) {
                return Optional.empty();
            }
        }
        Pair<Deletion.DelStatus, Runnable> status = Delete.startUiDelete(app, md, toRemove, false);
        if (status.v1 != Deletion.DelStatus.SUCCESS) {
            return Optional.empty();
        }
        delTask = (Runnable)status.v2;
        ImportedGeom toAdd = MergeImportedGeomAction.merge(igeoms, MerlinUtil.getName((IMerlinObj)toRemove.iterator().next()), importType);
        Object commonParent = md.hierarchy.getCommonParent(toRemove);
        GeomComposite parent = commonParent instanceof GeomComposite && md.hierarchy.isDescendent(md.sceneGeom, commonParent) ? (GeomComposite)commonParent : md.sceneGeom;
        Runnable deleteTask = delTask;
        return Optional.of(() -> {
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Merge objects"));
                deleteTask.run();
                AddObject.add(md, parent, Collections.singleton(toAdd));
                Undo.end(md);
            }
        });
    }

    public static ImportedGeom merge(Collection<ImportedGeom> igeoms, String name, ImportType itype) {
        assert (!igeoms.isEmpty());
        ImportedGeom first = igeoms.iterator().next();
        if (igeoms.size() == 1) {
            return first;
        }
        GeomNodesMerger builder = new GeomNodesMerger();
        PropsBuilder props = new PropsBuilder();
        for (ImportedGeom obj : igeoms) {
            IGeomNode geom = obj.getGeom();
            int numPrims = geom.getNumPrims(7);
            props.add(obj.getDisplayProps(), numPrims);
            builder.add(geom, numPrims);
        }
        IGeomNode node = builder.finish();
        ImportedGeom merged = first.clone();
        merged.setName(name);
        merged.setGeom(node);
        merged.setDisplayProps(props.finalizeProps());
        merged.setImportedType(itype);
        return merged;
    }
}

