/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.Undo;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;

public class ImportedGeomOpts
extends AMerlinOp
implements IEventObserver {
    private final String d_name;
    private final int d_options;
    private final boolean d_state;

    public ImportedGeomOpts(String name, boolean state, int options) {
        this.d_name = name;
        this.d_options = options;
        this.d_state = state;
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!VentusApp.getApp().getData().selection.isDeepEmpty(ImportedGeom.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(this.d_name);
            Set<ImportedGeom> objs = md.selection.getDeepSelected(ImportedGeom.class);
            objs.forEach(o -> o.insertUndoEntry_propRestore(ImportedGeom.PROP_OPTIONS));
            for (ImportedGeom ig : objs) {
                ig.setOptionsState(this.d_state, this.d_options);
            }
            Undo.end(md);
        }
    }
}

