/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.ImportType;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;

public class IgnoreImportedGeom
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new IgnoreImportedGeom(), Intl.intl("Exclude from room extraction"));

    public IgnoreImportedGeom() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!VentusApp.getApp().getData().selection.isDeepEmpty(ImportedGeom.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Exclude from room extraction"));
            Set<ImportedGeom> objs = md.selection.getDeepSelected(ImportedGeom.class);
            objs.forEach(o -> o.insertUndoEntry_propRestore(ImportedGeom.PROP_IMPORTED_TYPE));
            for (ImportedGeom ig : objs) {
                ig.setImportedType(ImportType.IGNORED);
            }
            Undo.end(md);
        }
    }
}

