/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.FileFilters;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.gui.guiUtil;

public class ExportObj
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new ExportObj(), Intl.intl("Export Imported Geometry..."));

    @Override
    public void run(VentusApp app, VentusData md) {
        String result;
        String filename = md.filename;
        if (filename == null) {
            filename = "untitled";
        }
        if ((result = ExportObj.promptForSaveFile(app, md, filename)) == null) {
            return;
        }
        filename = result;
        String ext = FilenameManager.getExtension(filename);
        try {
            if (ext.equalsIgnoreCase("obj")) {
                ExportObj.exportWavefront(md, filename);
            }
        }
        catch (IOException e) {
            guiUtil.showError(app, "Export Error", "Could not export imported geometry", (Throwable)e);
        }
    }

    private static String promptForSaveFile(VentusApp app, VentusData md, String fn) {
        guiJFXFileChooser chooser;
        File saveFile;
        if (fn == null) {
            fn = Intl.intl("untitled.obj");
        }
        if ((saveFile = (chooser = new guiJFXFileChooser(fn, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_WAVEFRONT)).showSaveDialog()) == null) {
            return null;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, saveFile.getParent());
        return saveFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportWavefront(VentusData md, String filename) throws IOException {
        File f = new File(filename);
        try (PrintStream out = null;){
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
            out.printf("mtllib %s.mtl%n", FilenameManager.splitFilename(f.getName())[0]);
            out.printf("o %s%n", f.getName());
            int voffset = 1;
            for (ImportedGeom gobj : md.sceneGeom.getDeepMembers(ImportedGeom.class)) {
                IGeom geom = gobj.getGeom().flatten().getLocalGeom();
                for (IFace face : GeomUtil.explode(geom, IFace.class)) {
                    int m;
                    Mesh mesh = face.triangulate(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR));
                    for (Point3d p : mesh.vertices) {
                        out.print("v ");
                        out.print(p.x);
                        out.print(' ');
                        out.print(p.z);
                        out.print(' ');
                        out.println(-p.y);
                    }
                    for (m = 0; m < mesh.vertices.length; ++m) {
                        out.println("vn 0.0 1.0 0.0");
                    }
                    for (m = 0; m < mesh.vertices.length; ++m) {
                        out.println("vt 0.0 0.0");
                    }
                    out.println("g Generic");
                    out.println("usemtl Default");
                    m = 0;
                    while (m < mesh.indices.length) {
                        int i1 = voffset + mesh.indices[m++];
                        int i2 = voffset + mesh.indices[m++];
                        int i3 = voffset + mesh.indices[m++];
                        int[] i = new int[]{i1, i2, i3};
                        out.print("f ");
                        for (int iv : i) {
                            out.print(iv);
                            out.print('/');
                            out.print(iv);
                            out.print('/');
                            out.print(iv);
                            out.print(' ');
                        }
                        out.println();
                    }
                    voffset += mesh.vertices.length;
                }
            }
        }
    }
}

