/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.JOptionPane;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.AMerlinObj;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ASchematicComp;
import ventus.data.schematics.geom.SchematicRoom;

public class EnableAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_ENABLE_HOOK = new UIHook(new EnableAction(true), Intl.intl("Enable"));
    public static final UIHook UI_DISABLE_HOOK = new UIHook(new EnableAction(false), Intl.intl("Disable"));
    private final boolean d_enable;

    public EnableAction(boolean enable) {
        this.d_enable = enable;
        VentusApp.getApp().getData().getEvents().addObserver(this);
        this.updateEnabled();
    }

    @Override
    public void update(Events events) {
        IEventRecord<IMerlinObj> evts = events.getEvents(IMerlinObj.class, new Class[0]);
        if (evts.hasChangedObjs(VentusData.SELECTION_CHANGED, VentusData.ENABLED) || evts.hasRemovedObjs() || evts.hasAddedObjs()) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        VentusData md = VentusApp.getApp().getData();
        Set sel = md.selection.getSelected(IMerlinObj.class);
        Set<TypedProp<?>> sharedProps = CompositePropertyUtil.getSupportedProps(IMerlinObj.SupportMode.UNION, sel);
        if (!sharedProps.contains(VentusData.ENABLED)) {
            this.setEnabled(false);
            return;
        }
        PropValue<Boolean> val = CompositePropertyUtil.getValue(VentusData.ENABLED, sel);
        if (this.d_enable) {
            this.setEnabled(val.map(b -> b == false).orElse(true));
        } else {
            this.setEnabled(val.orElse(true));
        }
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        String undoName = this.d_enable ? Intl.intl("Enable") : Intl.intl("Disable");
        Set<IMerlinObj> sel = md.selection.getDeepSelected(IMerlinObj.class);
        Optional<Set<IMerlinObj>> allObjs = this.collectAndValidate(sel, app, md);
        if (allObjs.isPresent()) {
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(undoName);
                CompElementActions.setProperty(VentusData.ENABLED, (Collection<? extends IMerlinObj>)allObjs.get(), this.d_enable);
                Undo.end(md);
            }
        }
    }

    private Optional<Set<IMerlinObj>> collectAndValidate(Set<IMerlinObj> sel, VentusApp app, VentusData md) {
        IFilteredCollection<ASchematicComp> selectedComponents = theUtil.filter(sel, ASchematicComp.class);
        LinkedHashSet<AMerlinObj> connectedObjs = new LinkedHashSet<AMerlinObj>();
        for (ASchematicComp comp : selectedComponents) {
            connectedObjs.addAll(comp.getConnObjectsForEnable(md));
        }
        IFilteredCollection<AMerlinObj> connObjs = theUtil.filter(connectedObjs, o -> {
            PropValue<Boolean> supported = o.getWithDetails(VentusData.ENABLED);
            if (supported.isEmpty()) {
                return false;
            }
            if (supported.get() == this.d_enable) {
                return false;
            }
            return !sel.contains(o);
        });
        if (!connObjs.isEmpty()) {
            String title;
            String msg;
            int choice;
            IFilteredCollection<SchematicRoom> rooms = theUtil.filter(connObjs, SchematicRoom.class);
            Object connObjMsg = "";
            if (!rooms.isEmpty()) {
                connObjMsg = (String)connObjMsg + String.format(rooms.size() == 1 ? Intl.intl("%d room") : Intl.intl("%d rooms"), rooms.size());
            }
            if ((choice = md.ui(() -> EnableAction.lambda$collectAndValidate$2(app, msg = String.format(this.d_enable ? Intl.intl("Other connected objects (%s) will be enabled.\n Do you still want to enable selected objects?") : Intl.intl("Other connected objects (%s) will be disabled.\n Do you still want to disable selected objects?"), connObjMsg), title = this.d_enable ? Intl.intl("Enable?") : Intl.intl("Disable?"))).intValue()) != 0) {
                return Optional.empty();
            }
        }
        LinkedHashSet<IMerlinObj> collectedObjs = new LinkedHashSet<IMerlinObj>(sel);
        collectedObjs.addAll(connObjs);
        return Optional.of(collectedObjs);
    }

    private static /* synthetic */ Integer lambda$collectAndValidate$2(VentusApp app, String msg, String title) throws Exception {
        return JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, title, 0);
    }
}

