/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.dependencies.Dependency;
import thunderheadeng.gui.framework.Deletion;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.builders.NewCompUtil;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.gui.MerlinComboBox;
import ventus.gui.ShowObjectsDlg;
import ventus.util.MerlinUtil;

public class Delete
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Delete16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Delete(), Intl.intl("&Delete...,D,Delete selected objects"), ICON);

    public Delete() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    private boolean canDelete(VentusData md) {
        return !md.selection.isEmpty();
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        this.setEnabled(this.canDelete(md));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set explicitSelObjs = md.selection.getSelected(IMerlinObj.class);
        Delete.uiDelete(app, md, explicitSelObjs, true);
    }

    public static Deletion.DelStatus uiDelete(VentusApp app, VentusData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean confirmDel) {
        Pair<Deletion.DelStatus, Runnable> result = Delete.startUiDelete(app, md, explicitSelObjs, confirmDel);
        if (result.v1 != Deletion.DelStatus.SUCCESS) {
            return (Deletion.DelStatus)((Object)result.v1);
        }
        ((Runnable)result.v2).run();
        return (Deletion.DelStatus)((Object)result.v1);
    }

    public static Pair<Deletion.DelStatus, Runnable> startUiDelete(VentusApp app, VentusData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean confirmDel) {
        return Delete.helper(md).startUiDelete(app, explicitSelObjs, confirmDel);
    }

    private static Deletion<VentusData, IMerlinObj> helper(VentusData md) {
        return new Deletion<VentusData, IMerlinObj>(new AppCallback(md));
    }

    public static Deletion.DelStatus headlessDelete(VentusData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean removeContainedObjs) {
        return Delete.helper(md).headlessDelete(md, explicitSelObjs, removeContainedObjs);
    }

    public static Deletion.DelStatus headlessDelete(VentusData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean removeContainedObjs, Consumer<? super IMerlinObj> failedDeletions) {
        return Delete.helper(md).headlessDelete(md, explicitSelObjs, removeContainedObjs, failedDeletions);
    }

    static {
        UI_HOOK.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        UI_HOOK.putValue("AcceleratorKey1", KeyStroke.getKeyStroke(8, 0));
    }

    private static class AppCallback
    implements Deletion.IAppCallback<VentusData, IMerlinObj> {
        private final VentusData md;

        private AppCallback(VentusData data) {
            this.md = data;
        }

        @Override
        public Predicate<? super IMerlinObj> getUiDependentObjFilter() {
            return obj -> EntryPointFactory.get(obj).canShowInReferencingLists(this.md, (IMerlinObj)obj);
        }

        @Override
        public VentusData getDomain() {
            return this.md;
        }

        @Override
        public Class<IMerlinObj> getObjType() {
            return IMerlinObj.class;
        }

        @Override
        public DepSnapshot<VentusData> takeDependencySnapshot() {
            return this.md.takeFullDependencySnapshot();
        }

        public Composite<? extends IMerlinObj> getRoot(IMerlinObj obj) {
            EntryPoint<IMerlinObj> ep = EntryPointFactory.get(obj);
            return ep.getRootComposite(this.md);
        }

        @Override
        public IMerlinObj getParent(Object obj) {
            return (IMerlinObj)this.md.hierarchy.getParent(obj);
        }

        @Override
        public Collection<? extends IMerlinObj> getChildren(IMerlinObj obj) {
            return theUtil.filter(this.md.hierarchy.getChildren(obj), IMerlinObj.class);
        }

        @Override
        public String getDisplayName(IMerlinObj obj) {
            return MerlinUtil.getName(obj);
        }

        @Override
        public String getCategoryName(IMerlinObj obj) {
            return EntryPointFactory.get(obj).getCategoryName(this.md, obj);
        }

        @Override
        public boolean isGroup(Object obj) {
            return obj instanceof Composite;
        }

        @Override
        public boolean isAutoDeleteGroup(IMerlinObj obj) {
            return EntryPointFactory.get(obj).isAutoDeleteGroup(this.md, obj);
        }

        @Override
        public int getNumChildren(Object obj) {
            return this.md.hierarchy.getNumChildren(obj);
        }

        @Override
        public Collection<? extends IMerlinObj> flatten(Collection<?> objs) {
            return MerlinUtil.flatten(objs, IMerlinObj.class);
        }

        @Override
        public <T> Collection<? extends T> flatten(Collection<?> objs, Class<T> type) {
            return MerlinUtil.flatten(objs, type);
        }

        @Override
        public boolean isDeletionUndoable(IMerlinObj obj) {
            return EntryPointFactory.get(obj).isDeleteUndoable(this.md, obj);
        }

        @Override
        public Exception getDeletionError(Object obj) {
            EntryPoint<Object> ep = EntryPointFactory.get(obj);
            return ep.getDeletionErr(this.md, obj);
        }

        @Override
        public <T> Class<? super T> getDomainRequiredType(T obj) {
            return EntryPointFactory.get(obj).getDomainRequiredType(this.md, obj);
        }

        @Override
        public void showObjects(Window parent, String title, Collection<? extends IMerlinObj> objs) {
            ShowObjectsDlg showObjs = new ShowObjectsDlg(parent, this.md, title, "", false, true, objs);
            showObjs.doModal();
        }

        @Override
        public <T extends IMerlinObj> guiComboBox<T> newComboBox(Class<?> type, List<T> objs, String nullName) {
            MerlinComboBox combo = new MerlinComboBox(this.md, type, data -> objs);
            combo.setNullName(nullName);
            return combo;
        }

        @Override
        public <T extends IMerlinObj> Comparator<T> getSorter(Collection<? extends T> objs) {
            return MerlinUtil.getSorter(this.md, objs);
        }

        @Override
        public Collection<? extends IMerlinObj> gatherAddObjs(Deletion.DelInfo<VentusData, IMerlinObj> delInfo) throws CancelledException {
            return Collections.emptyList();
        }

        @Override
        public void performDelete(Collection<? extends IMerlinObj> restoreSel, Deletion.DelInfo<VentusData, IMerlinObj> delInfo, Collection<? extends IMerlinObj> addObjs, boolean undoable) {
            try (VentusData.WriteLock lock = this.md.lockWrite();){
                Undo.begin(Intl.intl("Delete"));
                if (!undoable) {
                    Undo.insertEntry_breakChain(this.md);
                }
                this.restoreSelection(restoreSel);
                this.delete(delInfo);
                IFilteredCollection<ISchematicComp> addComps = theUtil.filter(addObjs, ISchematicComp.class);
                assert (addComps.isExclusive());
                NewCompUtil.addSchematicComps(this.md, true, addComps);
                Undo.end(this.md);
            }
        }

        @Override
        public void delete(Deletion.DelInfo<VentusData, IMerlinObj> delInfo) {
            if (delInfo.delObjs().isEmpty()) {
                return;
            }
            Predicate<Object> isMarkedForDeletion = obj -> {
                Object o = obj;
                while (o != null) {
                    if (delInfo.delObjs().contains(o)) {
                        return true;
                    }
                    o = this.md.hierarchy.getParent(o);
                }
                return false;
            };
            record RestoreInfo(Object src, DepCallback callback, Object ref) {
            }
            LinkedHashSet<RestoreInfo> toRestore = new LinkedHashSet<RestoreInfo>();
            for (Map.Entry<IMerlinObj, IMerlinObj> entry : delInfo.replacements().entrySet()) {
                IMerlinObj refObj = entry.getKey();
                Set dependents = delInfo.deps().getDependents(refObj);
                for (Dependency dep : dependents) {
                    if (dep.callback == null || isMarkedForDeletion.test(dep.source) || !dep.supportsReplacement()) continue;
                    toRestore.add(new RestoreInfo(dep.source, dep.callback, refObj));
                }
            }
            toRestore.forEach(info -> info.callback.replDep().insertUndoEntry(this.md, info.src, info.ref));
            for (Map.Entry<IMerlinObj, IMerlinObj> entry : delInfo.replacements().entrySet()) {
                Set dependents = delInfo.deps().getDependents(entry.getKey());
                for (Dependency dep : dependents) {
                    if (dep.callback == null || isMarkedForDeletion.test(dep.source)) continue;
                    assert (dep.supportsReplacement() || dep.link() == DLink.CONTAINED_BY);
                    if (!dep.supportsReplacement()) continue;
                    dep.replaceDependency(this.md, entry.getKey(), entry.getValue());
                }
            }
            for (IMerlinObj obj2 : delInfo.delObjs()) {
                EntryPoint<IMerlinObj> ep = EntryPointFactory.get(obj2);
                if (ep == null) continue;
                if (ep.isIndexed(this.md, obj2)) {
                    Undo.insertUndoEntry_insert(this.md, obj2);
                } else {
                    Undo.insertUndoEntry_add(this.md, obj2);
                }
                ep.delete(this.md, obj2);
            }
        }

        private void restoreSelection(Collection<? extends IMerlinObj> objs) {
            Undo.insertUndoEntry_restoreSelection(this.md);
            this.md.selection.clear();
        }
    }
}

