/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;

public class CompElementActions {
    public static <T> void setProperty(TypedProp<T> prop, Collection<? extends IMerlinObj> objs, T newVal) {
        VentusData md = Composite.getDomain(objs);
        new DefProp<IMerlinObj, T>(prop).set(md, objs, newVal);
    }

    public static List<IMerlinObj> flattenToLocallyDefined(TypedProp<?> prop, Collection<? extends IMerlinObj> objs) {
        ArrayList<IMerlinObj> modObjs = new ArrayList<IMerlinObj>();
        CompElementActions.flattenToLocallyDefined(prop, objs, modObjs);
        return modObjs;
    }

    private static void flattenToLocallyDefined(TypedProp<?> prop, Collection<? extends IMerlinObj> objs, List<IMerlinObj> result) {
        for (IMerlinObj iMerlinObj : objs) {
            if (iMerlinObj.isSupportedLocally(prop)) {
                result.add(iMerlinObj);
                continue;
            }
            CompElementActions.flattenToLocallyDefined(prop, theUtil.filter(iMerlinObj.getChildren(), IMerlinObj.class), result);
        }
    }

    public static class DefProp<ObjT extends IMerlinObj, PropT>
    implements IObjectProp<ObjT, PropT> {
        private final TypedProp<PropT> d_prop;

        public DefProp(TypedProp<PropT> prop) {
            this.d_prop = prop;
        }

        public TypedProp<PropT> getProp() {
            return this.d_prop;
        }

        protected void saveState(VentusData md, TypedProp<PropT> prop, Collection<? extends ObjT> objs, PropT newVal) {
            List<IMerlinObj> modObjs = CompElementActions.flattenToLocallyDefined(this.d_prop, objs);
            modObjs.forEach(obj -> obj.insertUndoEntry_propRestore(prop));
        }

        protected void set(VentusData md, TypedProp<PropT> prop, ObjT obj, PropT newVal) {
            obj.set(this.d_prop, newVal);
        }

        protected PropValue<PropT> get(VentusData md, TypedProp<PropT> prop, ObjT obj) {
            return obj.getWithDetails(this.d_prop);
        }

        protected boolean equal(VentusData md, PropT obj1, PropT obj2) {
            return Objects.equals(obj1, obj2);
        }

        @Override
        public void set(VentusData md, Collection<? extends ObjT> objs, PropT newVal) {
            this.saveState(md, this.d_prop, objs, newVal);
            for (IMerlinObj obj : objs) {
                this.set(md, this.d_prop, obj, newVal);
            }
        }

        @Override
        public PropValue<PropT> get(VentusData md, Collection<? extends ObjT> objs) {
            if (objs.isEmpty()) {
                return PropValue.unsupported();
            }
            PropValue<Object> val = PropValue.unsupported();
            for (IMerlinObj obj : objs) {
                PropValue<PropT> val2 = this.get(md, this.d_prop, obj);
                if (val2.isNonUniform()) {
                    return PropValue.nonUniform();
                }
                if (val2.isUnsupported()) continue;
                if (val.isUnsupported()) {
                    val = val2;
                    continue;
                }
                if (this.equal(md, val.get(), val2.get())) continue;
                return PropValue.nonUniform();
            }
            return val;
        }
    }

    public static interface IObjectProp<ObjT, PropT> {
        public void set(VentusData var1, Collection<? extends ObjT> var2, PropT var3);

        public PropValue<PropT> get(VentusData var1, Collection<? extends ObjT> var2);
    }
}

